/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.util.pdf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.LinkedList;

public class PDFInfo {
    public static final String VERSION = "1.00";
    public static final Integer STATUS_SUCCESS = 0;
    public static final Integer STATUS_UNPROCESSED = 1;
    public static final Integer STATUS_INVALID_FORMAT = 2;
    public static final Integer STATUS_FAILED_TO_READ_HEADER = 3;
    public static final Integer STATUS_INVALID_XREF_MARKER = 4;
    public static final Integer STATUS_INVALID_XREF_MARKER_BELOW = 5;
    public static final Integer STATUS_INVALID_XREF_MARKER_HEADER = 6;
    public static final Integer STATUS_INVALID_XREF_MARKER_BEYOND = 7;
    public static final Integer STATUS_MISSING_EOF_MARKER = 8;
    public static final Integer STATUS_INVALID_XREF = 9;
    public static final Integer STATUS_CORRUPT_XREF_MISSING = 10;
    public static final Integer STATUS_CORRUPT_TRAILER_MISSING = 11;
    public static final Integer STATUS_CORRUPT_TRAILER_UNKNOWN = 12;
    public static final Integer STATUS_CORRUPT_TRAILER_DICT_XREF_MISSING = 13;
    private long beforeEOF = 1024L;
    private Integer status = STATUS_UNPROCESSED;
    private String PDFVersion;

    public Integer getStatus() {
        return this.status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFrom(String string) throws IOException {
        String string2;
        LinkedList<String> linkedList = new LinkedList<String>();
        byte[] byArray = new byte[5];
        long l = -1L;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        if (randomAccessFile.read(byArray) != 5) {
            this.status = STATUS_FAILED_TO_READ_HEADER;
            return false;
        }
        if (!Arrays.equals(byArray, new byte[]{37, 80, 68, 70, 45})) {
            this.status = STATUS_INVALID_FORMAT;
            return false;
        }
        this.PDFVersion = randomAccessFile.readLine();
        long l2 = randomAccessFile.length() - this.beforeEOF;
        if (l2 > 0L) {
            randomAccessFile.seek(l2);
        }
        while (true) {
            if ((string2 = randomAccessFile.readLine()) == null) {
                if (linkedList.size() <= 0) break;
                string2 = (String)linkedList.removeFirst();
                break;
            }
            linkedList.add(string2);
        }
        if (linkedList.size() <= 3) {
            this.status = STATUS_INVALID_XREF;
            return false;
        }
        if (!((String)linkedList.removeLast()).equals("%%EOF")) {
            this.status = STATUS_MISSING_EOF_MARKER;
            return false;
        }
        string2 = (String)linkedList.removeLast();
        try {
            l = Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.status = STATUS_INVALID_XREF_MARKER;
            return false;
        }
        if (l < 0L) {
            this.status = STATUS_INVALID_XREF_MARKER_BELOW;
            return false;
        }
        if (l < 7L) {
            this.status = STATUS_INVALID_XREF_MARKER_HEADER;
            return false;
        }
        if (l > randomAccessFile.length() - (long)(9 + Long.toString(l).length())) {
            this.status = STATUS_INVALID_XREF_MARKER_BEYOND;
            return false;
        }
        if (!((String)linkedList.removeLast()).equals("startxref")) {
            this.status = STATUS_CORRUPT_XREF_MISSING;
            return false;
        }
        if (!((String)linkedList.removeLast()).equals(">>")) {
            this.status = STATUS_CORRUPT_TRAILER_MISSING;
            return false;
        }
        while (linkedList.size() > 0) {
            string2 = (String)linkedList.removeLast();
            if (string2.equals("<<")) {
                if (linkedList.size() == 0) {
                    this.status = STATUS_CORRUPT_TRAILER_UNKNOWN;
                    return false;
                }
                if (!((String)linkedList.removeLast()).equals("trailer")) {
                    this.status = STATUS_CORRUPT_TRAILER_DICT_XREF_MISSING;
                    return false;
                }
                linkedList.clear();
                break;
            }
            if (!string2.substring(0, 6).equals("/Info ")) continue;
            System.out.println(string2);
        }
        randomAccessFile.seek(l);
        return true;
    }

    public static void main(String[] stringArray) {
        PDFInfo pDFInfo = new PDFInfo();
        try {
            if (pDFInfo.getFrom("test.pdf")) {
                System.out.println("File read successful.");
            } else {
                System.out.println("Error, status code = " + pDFInfo.getStatus());
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException " + iOException);
        }
    }
}

