/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.util.conf;

import com.internationalnetwork.math.ConvertNumber;
import com.internationalnetwork.util.ArrayTools;
import com.internationalnetwork.util.ElectronicMailAddress;
import com.internationalnetwork.util.Hostname;
import com.internationalnetwork.util.StringParser;
import com.internationalnetwork.util.conf.ConfigurationDirective;
import com.internationalnetwork.util.conf.RuleSet;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;

public class Rule {
    public static final String VERSION = "1.00";
    private static final String[] FORMATS = new String[]{"cidr", "domain-literal", "email", "filename", "flag", "hostname", "ip", "number", "path", "text", "uri"};
    private static final int CIDR = 0;
    private static final int DOMAIN_LITERAL = 1;
    private static final int EMAIL = 2;
    private static final int FILENAME = 3;
    private static final int FLAG = 4;
    private static final int HOSTNAME = 5;
    private static final int IP = 6;
    private static final int NUMBER = 7;
    private static final int PATH = 8;
    private static final int TEXT = 9;
    private static final int URI = 10;
    private static final String[] OPTIONS = new String[]{"default", "elements", "equal", "error", "length", "range", "regex", "require", "scope"};
    boolean flagContainer = false;
    final String originalDirective;
    final String originalDirectiveLiteral;
    final String[] originalOptions;
    final String directive;
    int[][] elements = new int[0][];
    final String SYNTAX_ERROR = "Invalid argument(s) for";
    String syntaxError = "Invalid argument(s) for";
    int set = -1;
    RuleSet[] ruleSet = new RuleSet[0];
    String[] optionScope = new String[0];

    private Rule(Rule rule) {
        this.flagContainer = rule.flagContainer;
        this.originalDirective = rule.originalDirective;
        this.originalDirectiveLiteral = rule.originalDirectiveLiteral;
        this.originalOptions = rule.originalOptions;
        this.directive = rule.directive;
        this.elements = rule.elements;
        this.syntaxError = rule.syntaxError;
        this.set = rule.set;
        this.ruleSet = (RuleSet[])rule.ruleSet.clone();
        this.optionScope = rule.optionScope;
    }

    public Rule(String ... stringArray) {
        if (stringArray.length < 2) {
            if (stringArray.length == 1) {
                throw new UnsupportedOperationException("Format was not defined");
            }
            throw new UnsupportedOperationException("Directive and Format were not defined");
        }
        if (stringArray[0].startsWith("<") && stringArray[0].endsWith(">")) {
            this.flagContainer = true;
            this.originalDirective = stringArray[0].substring(1, stringArray[0].length() - 1);
        } else {
            this.originalDirective = stringArray[0];
        }
        this.originalDirectiveLiteral = stringArray[0];
        this.directive = this.originalDirective.toLowerCase();
        for (String string : this.originalOptions = Arrays.copyOfRange(stringArray, 1, stringArray.length)) {
            Object object;
            String[] stringArray2;
            String[] stringArray3 = string.split("=", 2);
            if (stringArray3.length < 2) {
                ++this.set;
                this.ruleSet = ArrayTools.join(this.ruleSet, {new RuleSet()});
                this.ruleSet[this.set].format = ArrayTools.index(FORMATS, string);
                if (this.ruleSet[this.set].format == -1) {
                    throw new UnsupportedOperationException("Unrecognized Format/Type: " + string);
                }
                this.ruleSet[this.set].originalFormat = string;
                continue;
            }
            String string2 = stringArray3[0];
            String string3 = stringArray3[1];
            if (string2.equals("alias")) {
                stringArray2 = string3.split("=", 2);
                if (stringArray2.length < 2) {
                    throw new IllegalArgumentException("Invalid parameter for \"alias\" option");
                }
                if (this.ruleSet[this.set].optionAlias.containsKey(stringArray2[0])) {
                    throw new IllegalArgumentException("Alias " + stringArray2[0] + " was previously defined");
                }
                this.ruleSet[this.set].optionAlias.put(stringArray2[0], stringArray2[1]);
                this.ruleSet[this.set].flagAlias = true;
                continue;
            }
            if (string2.equals("copy")) {
                int n = Integer.parseInt(string3);
                if (n < 1) {
                    throw new IllegalArgumentException("Invalid parameter for \"copy\" option");
                }
                this.ruleSet = ArrayTools.join(this.ruleSet, this.ruleSet[this.set].clone(n));
                this.set += n;
                continue;
            }
            if (string2.equals("default")) {
                if (this.flagContainer) {
                    throw new UnsupportedOperationException("Option \"default\" is not valid for Containers");
                }
                if (this.ruleSet[this.set].optionDefault != null) {
                    throw new UnsupportedOperationException("Option \"default\" was previously defined");
                }
                this.ruleSet[this.set].optionDefault = string3;
                this.ruleSet[this.set].flagDefault = true;
                continue;
            }
            if (string2.equals("elements")) {
                int n;
                if (this.set >= 0) {
                    throw new IllegalArgumentException("Option \"elements\" must be defined before any formats");
                }
                stringArray2 = string3.split("\\.\\.", 2);
                if (stringArray2.length == 1) {
                    stringArray2 = new String[]{stringArray2[0], stringArray2[0]};
                }
                if (stringArray2[0].length() == 0 && stringArray2[1].length() == 0) {
                    throw new IllegalArgumentException("At least one range/specific value is required");
                }
                if (stringArray2[0].length() == 0) {
                    stringArray2[0] = "0";
                }
                if (stringArray2[1].length() == 0) {
                    stringArray2[1] = "2147483647";
                }
                for (int i = 0; i < 2; ++i) {
                    if (stringArray2[i].equals("none")) {
                        stringArray2[i] = "0";
                        continue;
                    }
                    if (stringArray2[i].equals("nybble")) {
                        stringArray2[i] = "7";
                        continue;
                    }
                    if (stringArray2[i].equals("byte")) {
                        stringArray2[i] = "127";
                        continue;
                    }
                    if (stringArray2[i].equals("short")) {
                        stringArray2[i] = "32767";
                        continue;
                    }
                    if (!stringArray2[i].equals("int")) continue;
                    stringArray2[i] = "2147483647";
                }
                int[] nArray = new int[]{Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1])};
                if (nArray[0] > nArray[1]) {
                    n = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n;
                }
                n = this.elements.length;
                object = new int[n + 1][];
                for (int i = 0; i < n; ++i) {
                    object[i] = this.elements[i];
                }
                object[n] = nArray;
                this.elements = object;
                continue;
            }
            if (string2.equals("equal")) {
                this.ruleSet[this.set].optionEqual = ArrayTools.join(this.ruleSet[this.set].optionEqual, {string3});
                continue;
            }
            if (string2.equals("error")) {
                if (this.ruleSet[this.set].optionError != null) {
                    throw new UnsupportedOperationException("Option \"error\" was previously defined");
                }
                this.ruleSet[this.set].optionError = string3;
                continue;
            }
            if (string2.equals("length")) {
                if (this.ruleSet[this.set].optionLength >= 0) {
                    throw new IllegalArgumentException("Option \"length\" was previously defined");
                }
                this.ruleSet[this.set].optionLength = Integer.parseInt(string3);
                if (this.ruleSet[this.set].optionLength >= 0) continue;
                throw new IllegalArgumentException("Length cannot be less than zero");
            }
            if (string2.equals("range")) {
                int n;
                stringArray2 = string3.split("\\.\\.", 2);
                if (stringArray2.length < 2) {
                    throw new IllegalArgumentException("Range delimiter is required");
                }
                if (stringArray2[0].length() == 0 && stringArray2[1].length() == 0) {
                    throw new IllegalArgumentException("At least one range value is required");
                }
                for (n = 0; n < 2; ++n) {
                    stringArray2[n] = ConvertNumber.typeAlias(stringArray2[n]);
                }
                if (stringArray2[0].indexOf(".") >= 0 || stringArray2[1].indexOf(".") >= 0) {
                    if (this.ruleSet[this.set].optionRange.length == 0) {
                        this.ruleSet[this.set].flagRangeDecimal = true;
                    } else if (!this.ruleSet[this.set].flagRangeDecimal) {
                        throw new NumberFormatException("Decimal number not allowed");
                    }
                }
                n = this.ruleSet[this.set].optionRange.length;
                Object object2 = this.ruleSet[this.set].flagRangeDecimal ? new BigDecimal[n + 1][] : new BigInteger[n + 1][];
                for (int i = 0; i < n; ++i) {
                    object2[i] = this.ruleSet[this.set].optionRange[i];
                }
                if (this.ruleSet[this.set].flagRangeDecimal) {
                    object = new BigDecimal[]{new BigDecimal(stringArray2[0]), new BigDecimal(stringArray2[1])};
                    if (object[0].compareTo((BigDecimal)object[1]) == 1) {
                        int[] nArray = object[0];
                        object[0] = object[1];
                        object[1] = nArray;
                    }
                    object2[n] = (BigDecimal[])object;
                } else {
                    object = new BigInteger[]{new BigInteger(stringArray2[0]), new BigInteger(stringArray2[1])};
                    if (object[0].compareTo((BigInteger)object[1]) == 1) {
                        int[] nArray = object[0];
                        object[0] = object[1];
                        object[1] = nArray;
                    }
                    object2[n] = (BigDecimal[])object;
                }
                this.ruleSet[this.set].optionRange = object2;
                continue;
            }
            if (string2.equals("regex")) {
                this.ruleSet[this.set].optionRegEx = ArrayTools.join(this.ruleSet[this.set].optionRegEx, {Pattern.compile(string3)});
                continue;
            }
            if (string2.equals("require")) {
                if (!ArrayTools.contains(new String[]{"absolute", "!absolute", "exist", "!exist", "hidden", "!hidden", "read", "!read", "write", "!write", "execute", "!execute"}, string3)) {
                    throw new IllegalArgumentException("Unrecognized Option requirement:  " + string3);
                }
                this.ruleSet[this.set].optionRequire = ArrayTools.join(this.ruleSet[this.set].optionRequire, {string3});
                continue;
            }
            if (string2.equals("scope")) {
                if (this.set >= 0) {
                    throw new IllegalArgumentException("Option \"scope\" must be defined before any formats");
                }
                this.optionScope = ArrayTools.join(this.optionScope, {string3});
                continue;
            }
            throw new IllegalArgumentException("Unrecognized Option name: " + string2);
        }
    }

    public boolean isContainer() {
        return this.flagContainer;
    }

    public final boolean isDirective() {
        return !this.flagContainer;
    }

    public String getName() {
        return this.originalDirective;
    }

    public String getNameLiteral() {
        return this.originalDirectiveLiteral;
    }

    public String getFormat() {
        return this.ruleSet[this.set].originalFormat;
    }

    public String[] getOptions() {
        return Arrays.copyOf(this.originalOptions, this.originalOptions.length);
    }

    public boolean hasAliases() {
        return this.ruleSet[this.set].flagAlias;
    }

    public HashMap<String, String> getAliases() {
        return (HashMap)this.ruleSet[this.set].optionAlias.clone();
    }

    public String convertAlias(String string) {
        String string2 = this.ruleSet[this.set].optionAlias.get(string);
        return string2 == null ? string : string2;
    }

    public boolean hasDefault() {
        return this.ruleSet[this.set].flagDefault;
    }

    public String getDefault() {
        return this.ruleSet[this.set].optionDefault;
    }

    public String[] getEqualStrings() {
        return Arrays.copyOf(this.ruleSet[this.set].optionEqual, this.ruleSet[this.set].optionEqual.length);
    }

    public int compareToEqual(String string) {
        if (this.ruleSet[this.set].optionEqual.length == 0) {
            return 0;
        }
        for (String string2 : this.ruleSet[this.set].optionEqual) {
            if (!string.equals(string2)) continue;
            return 1;
        }
        return -1;
    }

    public boolean hasError() {
        return this.ruleSet[this.set].optionError != null;
    }

    public String getError() {
        return this.ruleSet[this.set].optionError;
    }

    public int getLength() {
        return this.ruleSet[this.set].optionLength;
    }

    public boolean hasRanges() {
        return this.ruleSet[this.set].optionRange.length > 0;
    }

    public boolean isRangeDecimal() {
        return this.ruleSet[this.set].flagRangeDecimal;
    }

    public Number[][] getRanges() {
        int n = this.ruleSet[this.set].optionRange.length;
        Number[][] numberArray = new Number[n][];
        for (int i = 0; i < n; ++i) {
            numberArray[i] = new Number[]{this.ruleSet[this.set].optionRange[i][0], this.ruleSet[this.set].optionRange[i][1]};
        }
        return numberArray;
    }

    public int compareToRange(String string) {
        if (this.ruleSet[this.set].flagRangeDecimal) {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(ConvertNumber.typeAlias(string));
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            if (this.ruleSet[this.set].optionRange.length == 0) {
                return 0;
            }
            for (BigDecimal[] bigDecimalArray : (BigDecimal[][])this.ruleSet[this.set].optionRange) {
                if (bigDecimal.compareTo(bigDecimalArray[0]) < 0 || bigDecimal.compareTo(bigDecimalArray[1]) > 0) continue;
                return 1;
            }
        } else {
            BigInteger bigInteger;
            try {
                bigInteger = new BigInteger(ConvertNumber.typeAlias(string));
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            if (this.ruleSet[this.set].optionRange.length == 0) {
                return 0;
            }
            for (BigInteger[] bigIntegerArray : (BigInteger[][])this.ruleSet[this.set].optionRange) {
                if (bigInteger.compareTo(bigIntegerArray[0]) < 0 || bigInteger.compareTo(bigIntegerArray[1]) > 0) continue;
                return 1;
            }
        }
        return -1;
    }

    public boolean hasElementRanges() {
        return this.elements.length > 0;
    }

    public int[][] getElementRanges() {
        int n = this.elements.length;
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = new int[]{this.elements[i][0], this.elements[i][1]};
        }
        return nArrayArray;
    }

    public int compareToElementRange(int n) {
        if (this.elements.length == 0) {
            return 0;
        }
        for (int[] nArray : this.elements) {
            if (n < nArray[0] || n > nArray[1]) continue;
            return 1;
        }
        return -1;
    }

    public Pattern[] getRegExPatterns() {
        return Arrays.copyOf(this.ruleSet[this.set].optionRegEx, this.ruleSet[this.set].optionRegEx.length);
    }

    public int compareToRegEx(String string) {
        if (this.ruleSet[this.set].optionRegEx.length == 0) {
            return 0;
        }
        for (Pattern pattern : this.ruleSet[this.set].optionRegEx) {
            if (!pattern.matcher(string).matches()) continue;
            return 1;
        }
        return -1;
    }

    public String[] getRequire() {
        return Arrays.copyOf(this.ruleSet[this.set].optionRequire, this.ruleSet[this.set].optionRequire.length);
    }

    public int compareToRequire(boolean bl, String string) {
        File file = new File(string);
        if (this.ruleSet[this.set].optionRequire.length == 0) {
            return 0;
        }
        if (bl && !file.isFile() || !file.isDirectory()) {
            return -1;
        }
        for (String string2 : this.ruleSet[this.set].optionRequire) {
            if (string2.equals("absolute") && !file.isAbsolute()) {
                return -1;
            }
            if (string2.equals("exist") && !file.exists()) {
                return -1;
            }
            if (string2.equals("hidden") && !file.isHidden()) {
                return -1;
            }
            if (string2.equals("read") && !file.canRead()) {
                return -1;
            }
            if (string2.equals("write") && !file.canWrite()) {
                return -1;
            }
            if (string2.equals("execute") && !file.canExecute()) {
                return -1;
            }
            if (string2.equals("!absolute") && file.isAbsolute()) {
                return -1;
            }
            if (string2.equals("!exist") && file.exists()) {
                return -1;
            }
            if (string2.equals("!hidden") && file.isHidden()) {
                return -1;
            }
            if (string2.equals("!read") && file.canRead()) {
                return -1;
            }
            if (string2.equals("!write") && file.canWrite()) {
                return -1;
            }
            if (!string2.equals("!execute") || !file.canExecute()) continue;
            return -1;
        }
        return 1;
    }

    public String[] getScope() {
        return Arrays.copyOf(this.optionScope, this.optionScope.length);
    }

    public int compareToScope(String string) {
        int n = 0;
        for (String string2 : this.optionScope) {
            if (string2.startsWith("!")) {
                if (string.equals(string2.substring(1))) {
                    return -1;
                }
                n = 1;
                continue;
            }
            if (string.equals(string2)) {
                return 1;
            }
            n = -1;
        }
        return n;
    }

    public boolean hasValidSyntax(ConfigurationDirective configurationDirective) {
        int n;
        if (this.compareToScope(configurationDirective.parent.name) == -1) {
            this.syntaxError = "Incorrect container context for";
            return false;
        }
        String[] stringArray = StringParser.atomize(configurationDirective.value);
        if (!(this.compareToElementRange(stringArray.length) != -1 || configurationDirective.flagTerminator && stringArray.length == 0)) {
            this.syntaxError = "Incorrect number of arguments for";
            return false;
        }
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (!configurationDirective.flagAliasAlterations && this.ruleSet[n < this.ruleSet.length ? n : this.ruleSet.length - 1].flagAlias) {
                String string = stringArray[n];
                stringArray[n] = this.convertAlias(stringArray[n]);
                if (stringArray[n] != string) {
                    bl = true;
                }
            }
            if (this._hasValidSyntax(stringArray[n], n)) continue;
            return false;
        }
        if (bl) {
            configurationDirective.flagAliasAlterations = true;
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = StringParser.quoteMinimal(stringArray[n]);
            }
            configurationDirective.value = StringParser.joinStrings(" ", stringArray);
        }
        return true;
    }

    boolean _hasValidSyntax(String string, int n) {
        this.set = n >= this.ruleSet.length ? this.ruleSet.length - 1 : n;
        int n2 = this.compareToEqual(string);
        if (n2 > 0) {
            return true;
        }
        if (this.ruleSet[this.set].optionLength >= 0 && string.length() > this.ruleSet[this.set].optionLength) {
            this.syntaxError = "Value exceeds maximum length in";
            return false;
        }
        this.syntaxError = "Invalid argument(s) for";
        switch (this.ruleSet[this.set].format) {
            case 9: {
                switch (this.compareToRegEx(string)) {
                    case -1: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                }
                break;
            }
            case 7: {
                if (this.compareToRegEx(string) >= 0 && this.compareToRange(string) >= 0) break;
                this.syntaxError = "Value out of range for";
                return false;
            }
            case 5: {
                try {
                    if (this.compareToRegEx(string) < 0 || this.compareToRange(Integer.toString(new Hostname(string).getLevelCount())) < 0) {
                        this.syntaxError = "Invalid hostname for";
                        return false;
                    }
                    break;
                }
                catch (ParseException parseException) {
                    this.syntaxError = "Invalid hostname for";
                    return false;
                }
            }
            case 6: {
                if (this.compareToRegEx(string) >= 0 && StringParser.isIPAddressRelaxed(string)) break;
                this.syntaxError = "Invalid IP address for";
                return false;
            }
            case 1: {
                if (this.compareToRegEx(string) >= 0 && StringParser.isDomainLiteralRelaxed(string)) break;
                this.syntaxError = "Invalid domain literal for";
                return false;
            }
            case 0: {
                if (this.compareToRegEx(string) >= 0 && StringParser.isCIDRNotationRelaxed(string)) break;
                this.syntaxError = "Invalid CIDR notation for";
                return false;
            }
            case 2: {
                try {
                    new ElectronicMailAddress(string);
                }
                catch (ParseException parseException) {
                    this.syntaxError = "Malformed eMail address for";
                    return false;
                }
                if (this.compareToRegEx(string) >= 0) break;
                this.syntaxError = "Malformed eMail address for";
                return false;
            }
            case 8: {
                if (this.compareToRegEx(string) >= 0 && this.compareToRequire(false, string) >= 0) break;
                this.syntaxError = "Invalid path for";
                return false;
            }
            case 3: {
                if (this.compareToRegEx(string) >= 0 && this.compareToRequire(true, string) >= 0) break;
                this.syntaxError = "Invalid path and/or filename for";
                return false;
            }
            case 10: {
                try {
                    new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.syntaxError = uRISyntaxException.getReason() + " for";
                    return false;
                }
                if (this.compareToRegEx(string) >= 0) break;
                this.syntaxError = "Invalid or unrecognized URI for";
                return false;
            }
            case 4: {
                if (ArrayTools.contains(new String[]{"1", "on", "yes", "true", "enabled", "0", "off", "no", "false", "disabled"}, string.toLowerCase())) break;
                return false;
            }
        }
        return n2 >= 0;
    }

    public Rule clone() {
        return new Rule(this);
    }
}

