/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.util.conf;

import com.internationalnetwork.util.conf.ConfigurationDirective;
import com.internationalnetwork.util.conf.Container;
import com.internationalnetwork.util.conf.ContainerRoot;
import com.internationalnetwork.util.conf.Directive;
import com.internationalnetwork.util.conf.Rule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationResource {
    public static final String VERSION = "1.00";
    HashMap<String, Rule> ruleMap;
    Stack<BufferedReader> streams = new Stack();
    Stack<String> streamsFilename = new Stack();
    boolean flagWildcard = false;
    boolean flagReservedDirectives = true;
    static final Pattern reRemark = Pattern.compile("^\\s*(#.*)?$");
    static final Pattern reDirective = Pattern.compile("^\\s*(<(/)?([^\\s]+)\\s*(.*)?>|([^\\s]+)\\s*(.*)?)\\s*$");
    static final int RE_TERMINATOR = 2;
    static final int RE_CONTAINER_NAME = 3;
    static final int RE_CONTAINER_ARGS = 4;
    static final int RE_DIRECTIVE_NAME = 5;
    static final int RE_DIRECTIVE_ARGS = 6;

    public ConfigurationResource() {
        this.flagWildcard = true;
    }

    public ConfigurationResource(String[] ... stringArray) {
        if (stringArray.length == 0) {
            this.flagWildcard = true;
        } else {
            this.defineRules(stringArray);
        }
    }

    public ConfigurationResource(Rule ... ruleArray) {
        if (ruleArray.length == 0) {
            this.flagWildcard = true;
        } else {
            this.defineRules(ruleArray);
        }
    }

    public ConfigurationResource(InputStream inputStream, String[] ... stringArray) {
        this.streams.push(new BufferedReader(new InputStreamReader(inputStream)));
        this.streamsFilename.push(inputStream.toString());
        if (stringArray.length == 0) {
            this.flagWildcard = true;
        } else {
            this.defineRules(stringArray);
        }
    }

    public ConfigurationResource(InputStream inputStream, Rule ... ruleArray) {
        this.streams.push(new BufferedReader(new InputStreamReader(inputStream)));
        this.streamsFilename.push(inputStream.toString());
        if (ruleArray.length == 0) {
            this.flagWildcard = true;
        } else {
            this.defineRules(ruleArray);
        }
    }

    public ConfigurationResource(String string, String[] ... stringArray) throws IOException {
        this.streams.push(new BufferedReader(new InputStreamReader(new FileInputStream(string))));
        this.streamsFilename.push(string);
        if (stringArray.length == 0) {
            this.flagWildcard = true;
        } else {
            this.defineRules(stringArray);
        }
    }

    public ConfigurationResource(String string, Rule ... ruleArray) throws IOException {
        this.streams.push(new BufferedReader(new InputStreamReader(new FileInputStream(string))));
        this.streamsFilename.push(string);
        if (ruleArray.length == 0) {
            this.flagWildcard = true;
        } else {
            this.defineRules(ruleArray);
        }
    }

    public ConfigurationResource(File file, String[] ... stringArray) throws IOException {
        this.streams.push(new BufferedReader(new InputStreamReader(new FileInputStream(file))));
        this.streamsFilename.push(file.getPath());
        if (stringArray.length == 0) {
            this.flagWildcard = true;
        } else {
            this.defineRules(stringArray);
        }
    }

    public ConfigurationResource(File file, Rule ... ruleArray) throws IOException {
        this.streams.push(new BufferedReader(new InputStreamReader(new FileInputStream(file))));
        this.streamsFilename.push(file.getPath());
        if (ruleArray.length == 0) {
            this.flagWildcard = true;
        } else {
            this.defineRules(ruleArray);
        }
    }

    public boolean isWildcardFlag() {
        return this.flagWildcard;
    }

    public void setWildcardFlag(boolean bl) {
        this.flagWildcard = bl;
    }

    public boolean isReservedDirectivesFlag() {
        return this.flagReservedDirectives;
    }

    public void setReservedDirectivesFlag(boolean bl) {
        this.flagReservedDirectives = bl;
    }

    public ConfigurationResource defineRules(String[] ... stringArray) {
        if (this.ruleMap == null) {
            this.ruleMap = new HashMap(stringArray.length);
        }
        for (String[] stringArray2 : stringArray) {
            Rule rule = new Rule(stringArray2);
            String string = rule.getNameLiteral();
            if (this.ruleMap.containsKey(string)) {
                throw new IllegalArgumentException("Rule \"" + string + "\" is already defined");
            }
            this.ruleMap.put(string, rule);
        }
        return this;
    }

    public ConfigurationResource defineRules(Rule ... ruleArray) {
        if (this.ruleMap == null) {
            this.ruleMap = new HashMap(ruleArray.length);
        }
        for (Rule rule : ruleArray) {
            String string = rule.getNameLiteral();
            if (this.ruleMap.containsKey(string)) {
                throw new IllegalArgumentException("Rule \"" + string + "\" is already defined");
            }
            this.ruleMap.put(string, rule);
        }
        return this;
    }

    public ConfigurationResource reDefineRule(String[] stringArray) {
        Rule rule = new Rule(stringArray);
        String string = rule.getNameLiteral();
        if (!this.ruleMap.containsKey(string)) {
            throw new IllegalArgumentException("Rule \"" + string + "\" cannot be re-defined because it doesn't exist");
        }
        this.ruleMap.put(string, rule);
        return this;
    }

    public ConfigurationResource reDefineRule(Rule rule) {
        String string = rule.getNameLiteral();
        if (!this.ruleMap.containsKey(string)) {
            throw new IllegalArgumentException("Rule \"" + string + "\" cannot be re-defined because it doesn't exist");
        }
        this.ruleMap.put(string, rule);
        return this;
    }

    public ContainerRoot processStream(InputStream inputStream) throws IOException, ParseException {
        this.streams.push(new BufferedReader(new InputStreamReader(inputStream)));
        this.streamsFilename.push(inputStream.toString());
        return this.processStream();
    }

    public ContainerRoot processStream(String string) throws IOException, ParseException {
        this.streams.push(new BufferedReader(new InputStreamReader(new FileInputStream(string))));
        this.streamsFilename.push(string);
        return this.processStream();
    }

    public ContainerRoot processStream(File file) throws IOException, ParseException {
        this.streams.push(new BufferedReader(new InputStreamReader(new FileInputStream(file))));
        this.streamsFilename.push(file.getPath());
        return this.processStream();
    }

    public ContainerRoot processStream() throws IOException, ParseException {
        Stack<BufferedReader> stack = this.streams;
        this.streams = new Stack();
        Stack<String> stack2 = this.streamsFilename;
        this.streamsFilename = new Stack();
        Stack<Long> stack3 = new Stack<Long>();
        ContainerRoot containerRoot = new ContainerRoot();
        Container container = containerRoot;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        BufferedReader bufferedReader = stack.peek();
        while (!stack.empty()) {
            Rule rule;
            Object object;
            if (!bufferedReader.ready()) {
                bufferedReader.close();
                bufferedReader = stack.pop();
                if (stack.empty()) continue;
                stack2.pop();
                l = (Long)stack3.pop();
                continue;
            }
            String string = bufferedReader.readLine();
            l4 = ++l2;
            l3 = l2;
            ++l;
            while (string.endsWith("\\") && !string.endsWith("\\\\")) {
                string = string.substring(0, string.length() - 1) + bufferedReader.readLine();
                l4 = ++l;
            }
            if (reRemark.matcher(string).matches()) continue;
            Matcher matcher = reDirective.matcher(string);
            if (!matcher.matches()) {
                throw new ParseException("Unrecognized format error on line " + string + (stack2.empty() ? "" : " in " + stack2.peek()), string.length());
            }
            if (this.flagReservedDirectives && this.flagReservedDirectives && "Include".equals(matcher.group(5))) {
                object = matcher.group(6);
                if (stack2.contains(object)) {
                    throw new ParseException("Potential infinite loop error on line " + string + (stack2.empty() ? "" : " in " + stack2.peek()), string.length());
                }
                bufferedReader = stack.push(new BufferedReader(new InputStreamReader(new FileInputStream(stack2.push((String)object)))));
                stack2.push((String)object);
                stack3.push(l);
                l = 0L;
                continue;
            }
            Object object2 = object = matcher.group(5) == null ? new Container(matcher.group(3), matcher.group(4)) : new Directive(matcher.group(5), matcher.group(6));
            if (matcher.group(2) != null) {
                ((ConfigurationDirective)object).flagTerminator = true;
            }
            if ((rule = this.ruleMap.get(((ConfigurationDirective)object).getNameLiteral())) == null) {
                if (!this.flagWildcard) {
                    throw new ParseException("Unrecognized" + (((ConfigurationDirective)object).isContainer() ? " container" : " directive") + " \"" + ((ConfigurationDirective)object).getNameLiteral() + "\" on line " + l3 + (stack2.empty() ? "" : " in " + stack2.peek()), string.length());
                }
            } else {
                ((ConfigurationDirective)object).rule = rule;
                ((ConfigurationDirective)object).parent = container;
                if (!this.flagWildcard && !rule.hasValidSyntax((ConfigurationDirective)object)) {
                    throw new ParseException(rule.syntaxError + (((ConfigurationDirective)object).isContainer() ? " container" : " directive") + " \"" + ((ConfigurationDirective)object).getNameLiteral() + "\" on line " + l3 + (rule.hasError() ? " (" + rule.getError() + ")" : "") + (stack2.empty() ? "" : " in " + stack2.peek()), string.length());
                }
                ((ConfigurationDirective)object).parent = null;
            }
            if (((ConfigurationDirective)object).flagContainer) {
                if (!((ConfigurationDirective)object).flagTerminator) {
                    container.add((ConfigurationDirective)object);
                    container = (Container)object;
                    continue;
                }
                if (container.name.equals("_root")) {
                    throw new ParseException("There are no open containers for \"</" + ((ConfigurationDirective)object).name + ">\" on line " + l3 + (stack2.empty() ? "" : " in " + stack2.peek()) + " to terminate", string.length());
                }
                if (!container.name.equals(((ConfigurationDirective)object).name)) {
                    throw new ParseException("Container \"<" + container.name + ">\" can't be terminated by \"</" + ((ConfigurationDirective)object).name + ">\" on line " + l3 + (stack2.empty() ? "" : " in " + stack2.peek()), string.length());
                }
                for (Rule rule2 : this.ruleMap.values()) {
                    if (!rule2.ruleSet[0].flagDefault || container.contains(rule2.originalDirectiveLiteral) || rule2.compareToScope(container.name) == -1) continue;
                    container.add(new Directive(rule2.originalDirective, rule2.ruleSet[0].optionDefault));
                }
                container = container.parent;
                continue;
            }
            container.add((ConfigurationDirective)object);
        }
        return containerRoot;
    }

    public ConfigurationResource clone() {
        ConfigurationResource configurationResource = new ConfigurationResource();
        configurationResource.ruleMap = new HashMap(this.ruleMap.size());
        for (String string : this.ruleMap.keySet()) {
            configurationResource.ruleMap.put(string, this.ruleMap.get(string));
        }
        configurationResource.flagWildcard = this.flagWildcard;
        configurationResource.flagReservedDirectives = this.flagReservedDirectives;
        return configurationResource;
    }
}

