/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.util.conf;

import com.internationalnetwork.util.ArrayTools;
import com.internationalnetwork.util.StringParser;
import com.internationalnetwork.util.conf.Container;
import com.internationalnetwork.util.conf.Rule;
import java.util.ArrayList;
import java.util.HashMap;

public class ConfigurationDirective {
    public static final String VERSION = "1.00";
    long lineBegin;
    long lineEnd;
    final String name;
    final String nameLC;
    String value;
    boolean flagAliasAlterations = false;
    boolean flagContainer = false;
    boolean flagTerminator = false;
    Rule rule = null;
    Container parent = null;
    int branchesTotal = 0;
    ConfigurationDirective[] branches = new ConfigurationDirective[0];
    int childrenTotal = 0;
    ConfigurationDirective[] children = new ConfigurationDirective[0];
    HashMap<String, ArrayList<ConfigurationDirective>> childrenSet = null;
    ConfigurationDirective first = null;
    ConfigurationDirective last = null;
    ConfigurationDirective prev = null;
    ConfigurationDirective next = null;

    ConfigurationDirective() {
        this.name = null;
        this.nameLC = null;
        this.value = null;
    }

    ConfigurationDirective(String string, String string2) {
        this.name = string;
        this.nameLC = string.toLowerCase();
        this.value = string2;
    }

    public final void add(ConfigurationDirective configurationDirective) {
        String string;
        if (configurationDirective.parent != null) {
            throw new UnsupportedOperationException("A ConfigurationDirective object may only be added to one hierarchy once");
        }
        configurationDirective.parent = (Container)this;
        if (this.first == null) {
            this.first = this.last = configurationDirective;
        } else {
            configurationDirective.prev = this.last;
            this.last.next = this.last = configurationDirective;
        }
        ++this.childrenTotal;
        if (configurationDirective.flagContainer) {
            ++this.branchesTotal;
        }
        if (!this.childrenSet.containsKey(string = configurationDirective.getNameLiteral().toLowerCase())) {
            this.childrenSet.put(string, new ArrayList(1));
        }
        this.childrenSet.get(string).add(configurationDirective);
    }

    public final boolean isContainer() {
        return this.flagContainer;
    }

    public final boolean isContainerTerminator() {
        return this.flagTerminator;
    }

    public final boolean isDirective() {
        return !this.flagContainer;
    }

    public final boolean isRoot() {
        return this.flagContainer && this.parent == null;
    }

    public final boolean wasMultiLine() {
        return this.lineBegin != this.lineEnd;
    }

    public final long[] getLineNumbers() {
        return new long[]{this.lineBegin, this.lineEnd};
    }

    public final String getName() {
        return this.name;
    }

    public final String getNameLiteral() {
        return this.flagContainer ? "<" + this.name + ">" : this.name;
    }

    public final ConfigurationDirective[] getContainerDirectives(String string) {
        return this.flagContainer ? this.getDirectives(string) : this.parent.getDirectives(string);
    }

    public boolean containsChild(String string) {
        return (this.flagContainer ? this : this.parent).containsChild(string);
    }

    public final String[] getAtoms() {
        return StringParser.atomize(this.value);
    }

    public final String getAtom(int n) {
        String[] stringArray = StringParser.atomize(this.value);
        return stringArray.length == 0 || n >= stringArray.length ? null : stringArray[n];
    }

    public final String getAtom(String string, int n) {
        ConfigurationDirective[] configurationDirectiveArray = this.getDirectives(string);
        if (configurationDirectiveArray == null) {
            return null;
        }
        return configurationDirectiveArray.length == 0 ? null : configurationDirectiveArray[0].getAtom(n);
    }

    public final String getValue() {
        return this.value;
    }

    public final String[][] getAtoms(String string, int ... nArray) {
        String[][] stringArray;
        ConfigurationDirective[] configurationDirectiveArray = this.getDirectives(string);
        if (configurationDirectiveArray == null) {
            return new String[0][0];
        }
        if (nArray.length == 0) {
            stringArray = new String[configurationDirectiveArray.length][];
            int n = 0;
            for (ConfigurationDirective configurationDirective : configurationDirectiveArray) {
                stringArray[n++] = StringParser.atomize(configurationDirective.getValue());
            }
        } else {
            stringArray = new String[nArray.length][];
            int n = configurationDirectiveArray.length;
            for (int n2 : nArray) {
                stringArray[n2] = n2 < n ? StringParser.atomize(configurationDirectiveArray[n2].getValue()) : null;
            }
        }
        return stringArray;
    }

    public final String[] getAtomsCombined(String string, int ... nArray) {
        String[] stringArray = ArrayTools.join(this.getAtoms(string, nArray));
        return stringArray != null ? stringArray : new String[]{};
    }

    public final String getFirstValue(String string) {
        ConfigurationDirective[] configurationDirectiveArray = this.getDirectives(string);
        if (configurationDirectiveArray == null) {
            return null;
        }
        return configurationDirectiveArray.length == 0 ? null : configurationDirectiveArray[0].getValue();
    }

    public final String[] getValue(String string, int ... nArray) {
        String[] stringArray;
        ConfigurationDirective[] configurationDirectiveArray = this.getDirectives(string);
        if (configurationDirectiveArray == null) {
            return new String[0];
        }
        if (nArray.length == 0) {
            stringArray = new String[configurationDirectiveArray.length];
            int n = 0;
            for (ConfigurationDirective configurationDirective : configurationDirectiveArray) {
                stringArray[n++] = configurationDirective.getValue();
            }
        } else {
            stringArray = new String[nArray.length];
            int n = configurationDirectiveArray.length;
            for (int n2 : nArray) {
                stringArray[n2] = n2 < n ? configurationDirectiveArray[n2].getValue() : null;
            }
        }
        return stringArray;
    }

    ConfigurationDirective[] getDirectives(String string) {
        return this.flagContainer ? this.getDirectives(string) : this.parent.getDirectives(string);
    }

    public final String getDefaultValue() {
        if (this.rule == null) {
            return null;
        }
        return this.rule.getDefault();
    }

    public final boolean hasRule() {
        return this.rule != null;
    }

    public final Rule getRule() {
        return this.rule;
    }

    public final ConfigurationDirective first() {
        return this.first;
    }

    public final ConfigurationDirective last() {
        return this.last;
    }

    public final ConfigurationDirective prev() {
        return this.prev;
    }

    public final ConfigurationDirective previous() {
        return this.prev;
    }

    public final ConfigurationDirective next() {
        return this.next;
    }

    public final ConfigurationDirective parent() {
        return this.parent;
    }

    public final int getBranchesTotal() {
        return this.branchesTotal;
    }

    public final int getChildrenTotal() {
        return this.childrenTotal;
    }

    /*
     * WARNING - void declaration
     */
    public final ConfigurationDirective[] getBranches(String ... stringArray) {
        if (this.branchesTotal != this.branches.length) {
            void var3_5;
            this.branches = new ConfigurationDirective[this.branchesTotal];
            int n = 0;
            ConfigurationDirective object = this.first;
            while (var3_5 != null) {
                if (var3_5.flagContainer) {
                    this.branches[n++] = var3_5;
                }
                ConfigurationDirective configurationDirective = var3_5.next();
            }
        }
        if (stringArray.length == 0) {
            return this.branches;
        }
        ArrayList<ConfigurationDirective> arrayList = new ArrayList<ConfigurationDirective>();
        block1: for (ConfigurationDirective configurationDirective : this.branches) {
            String string = configurationDirective.getName();
            for (String string2 : stringArray) {
                if (!string.equals(string2)) continue;
                arrayList.add(configurationDirective);
                continue block1;
            }
        }
        return arrayList.toArray(new ConfigurationDirective[0]);
    }

    public final ConfigurationDirective[] getChildren() {
        if (this.childrenTotal != this.children.length) {
            this.children = new ConfigurationDirective[this.childrenTotal];
            int n = 0;
            for (ConfigurationDirective configurationDirective = this.first; configurationDirective != null; configurationDirective = configurationDirective.next()) {
                this.children[n++] = configurationDirective;
            }
        }
        return this.children;
    }
}

