/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.util;

import com.internationalnetwork.lang.Nybble;
import com.internationalnetwork.lang.VeryLong;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;

public class StringParser {
    public static final String VERSION = "1.20";
    static final String SAFE_FILENAME_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-+_!";

    private StringParser() {
    }

    public static String[] atomize(String string) {
        if (string == null || string.equals("")) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            block0 : switch (c) {
                case '\"': {
                    bl = !bl;
                    break;
                }
                case '\\': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') break;
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            stringBuilder.append(c);
                            break block0;
                        }
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    break;
                }
                case ' ': {
                    if (!bl) {
                        if (stringBuilder.length() <= 0) break;
                        arrayList.add(stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                        break;
                    }
                    stringBuilder.append(c);
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        if (arrayList.isEmpty()) {
            return new String[0];
        }
        return arrayList.toArray(new String[0]);
    }

    public static String commas(int n) {
        int n2;
        String string = Integer.toString(n);
        String string2 = "";
        if (n < 0) {
            string = string.substring(1);
        }
        for (n2 = string.length(); n2 > 3; n2 -= 3) {
            string2 = "," + string.substring(n2 - 3, n2) + string2;
        }
        string2 = (n < 0 ? "-" : "") + string.substring(0, n2) + string2;
        return string2;
    }

    public static String commas(long l) {
        int n;
        String string = Long.toString(l);
        String string2 = "";
        if (l < 0L) {
            string = string.substring(1);
        }
        for (n = string.length(); n > 3; n -= 3) {
            string2 = "," + string.substring(n - 3, n) + string2;
        }
        string2 = (l < 0L ? "-" : "") + string.substring(0, n) + string2;
        return string2;
    }

    public static String commas(short s) {
        int n;
        String string = Short.toString(s);
        String string2 = "";
        if (s < 0) {
            string = string.substring(1);
        }
        for (n = string.length(); n > 3; n -= 3) {
            string2 = "," + string.substring(n - 3, n) + string2;
        }
        string2 = (s < 0 ? "-" : "") + string.substring(0, n) + string2;
        return string2;
    }

    public static String convertFromRNAME(String string, String string2) throws ParseException {
        if (string == null) {
            string = "";
        }
        String[] stringArray = string.split("\\\\.");
        int n = stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].contains(".")) continue;
            throw new ParseException("Too many @ symbols implied", i);
        }
        stringArray[n] = stringArray[n].replaceFirst("\\.", "@");
        String string3 = StringParser.join(".", stringArray);
        if (string2 != null && !string3.contains("@")) {
            string3 = string3 + "@" + string2;
        }
        if (string3.endsWith(".")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    public static String executeBackspaces(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (c == '\b' || c == '\u007f') {
                int n = stringBuilder.length();
                if (n <= 0) continue;
                stringBuilder.deleteCharAt(--n);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isInternetName(String string) {
        return StringParser.isInternetName(string, string.length());
    }

    public static boolean isInternetName(String string, int n) {
        if (string == null) {
            return false;
        }
        int n2 = string.length() - 1;
        if (n2 == -1 || n < 0) {
            return false;
        }
        if (n2 >= n) {
            return false;
        }
        char c = string.charAt(0);
        if (c < 'A' || c > 'Z' && c < 'a' || c > 'z') {
            return false;
        }
        c = string.charAt(n2);
        if (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z') {
            return false;
        }
        if (n2 < 2) {
            return true;
        }
        for (int i = 1; i < n2; ++i) {
            c = string.charAt(i);
            if (!(c < '-' || c > '-' && c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static boolean isCIDRNotation(String string) {
        if (StringParser.isCIDRv4Notation(string)) {
            return true;
        }
        return StringParser.isCIDRv6Notation(string);
    }

    public static boolean isCIDRNotationRelaxed(String string) {
        if (StringParser.isCIDRv4NotationRelaxed(string)) {
            return true;
        }
        return StringParser.isCIDRv6Notation(string);
    }

    public static boolean isCIDRv4Notation(String string) {
        int n;
        int n2 = string.indexOf("/");
        int n3 = 3;
        if (n2 == -1) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (string.charAt(n) != '.') continue;
            --n3;
        }
        if (n3 < 0) {
            return false;
        }
        if (!StringParser.isIPv4Address(string.substring(0, n2) + ".0.0.0".substring(n3 << 1))) {
            return false;
        }
        try {
            n = Byte.valueOf(string.substring(n2 + 1)).byteValue();
            if (n < 0 || n > 32) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isCIDRv4NotationRelaxed(String string) {
        int n;
        int n2 = string.indexOf("/");
        int n3 = 3;
        if (n2 == -1) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (string.charAt(n) != '.') continue;
            --n3;
        }
        if (n3 < 0) {
            return false;
        }
        if (!StringParser.isIPv4AddressRelaxed(string.substring(0, n2) + ".0.0.0".substring(n3 << 1))) {
            return false;
        }
        try {
            n = Byte.valueOf(string.substring(n2 + 1)).byteValue();
            if (n < 0 || n > 32) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isCIDRv6Notation(String string) {
        int n = string.indexOf("/");
        if (n == -1) {
            return false;
        }
        if (!StringParser.isIPv6Address(string.substring(0, n))) {
            return false;
        }
        try {
            byte by = Byte.valueOf(string.substring(n + 1));
            if (by < 0 || by > 128) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isDomainLiteral(String string) {
        return string.startsWith("[") && string.endsWith("]") && StringParser.isIPAddress(string.substring(1, string.length() - 1));
    }

    public static boolean isDomainLiteralRelaxed(String string) {
        return string.startsWith("[") && string.endsWith("]") && StringParser.isIPAddressRelaxed(string.substring(1, string.length() - 1));
    }

    public static boolean isDomainLiteral4(String string) {
        return string.startsWith("[") && string.endsWith("]") && StringParser.isIPv4Address(string.substring(1, string.length() - 1));
    }

    public static boolean isDomainLiteral4Relaxed(String string) {
        return string.startsWith("[") && string.endsWith("]") && StringParser.isIPv4AddressRelaxed(string.substring(1, string.length() - 1));
    }

    public static boolean isDomainLiteral6(String string) {
        return string.startsWith("[") && string.endsWith("]") && StringParser.isIPv6Address(string.substring(1, string.length() - 1));
    }

    public static boolean isIPAddress(String string) {
        if (StringParser.isIPv4Address(string)) {
            return true;
        }
        return StringParser.isIPv6Address(string);
    }

    public static boolean isIPAddressRelaxed(String string) {
        if (StringParser.isIPv4AddressRelaxed(string)) {
            return true;
        }
        return StringParser.isIPv6Address(string);
    }

    public static boolean isIPv4Address(String string) {
        int n = -1;
        int n2 = 0;
        for (char c : string.toCharArray()) {
            if (c == '.') {
                if (n < 0) {
                    return false;
                }
                if (n2 > 3) {
                    return false;
                }
                n = -1;
                n2 = (short)(n2 + 1);
                continue;
            }
            if (c < '0' || c > '9') {
                return false;
            }
            if (n == 0) {
                return false;
            }
            if (n < 0) {
                ++n;
            }
            if ((n = n * 10 + (c - 48)) <= 255) continue;
            return false;
        }
        if (n2 < 3) {
            return false;
        }
        return n >= 0;
    }

    public static boolean isIPv4AddressRelaxed(String string) {
        int n = -1;
        int n2 = 0;
        for (char c : string.toCharArray()) {
            if (c == '.') {
                if (n < 0) {
                    return false;
                }
                if (n2 > 3) {
                    return false;
                }
                n = -1;
                n2 = (short)(n2 + 1);
                continue;
            }
            if (c < '0' || c > '9') {
                return false;
            }
            if (n < 0) {
                ++n;
            }
            if ((n = n * 10 + (c - 48)) <= 255) continue;
            return false;
        }
        if (n2 < 3) {
            return false;
        }
        return n >= 0;
    }

    public static boolean isIPv6Address(String string) {
        int n = string.length();
        int n2 = -1;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                if (n3 > 6) {
                    return false;
                }
                if (i > 0) {
                    if (string.charAt(i - 1) == ':') {
                        if (bl) {
                            return false;
                        }
                        bl = true;
                    } else if (i == n) {
                        return false;
                    }
                }
                n2 = -1;
                n3 = (short)(n3 + 1);
                continue;
            }
            if (c == '.') {
                if (n5 == 0) {
                    return false;
                }
                if (bl ? n3 > 6 : n3 != 6) {
                    return false;
                }
                return StringParser.isIPv4Address(string.substring(n5));
            }
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                return false;
            }
            if (n4 > 4) {
                return false;
            }
            if (n2 < 0) {
                ++n2;
                n4 = 0;
                n5 = i;
            }
            n4 = (byte)(n4 + 1);
            if (c >= '0' && c <= '9') {
                n2 *= 16 + (c - 48);
            } else if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                n2 *= 16 + (c - 65) + 10;
            } else {
                return false;
            }
            if (n2 <= 65535) continue;
            return false;
        }
        if (bl) {
            if (n3 > 7) {
                return false;
            }
        } else {
            if (n3 != 7) {
                return false;
            }
            if (n2 < 0) {
                return false;
            }
        }
        return true;
    }

    public static String join(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        if (string == "") {
            string = null;
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        int n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String joinStrings(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        if (string == "") {
            string = null;
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        int n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            if (string == null || stringArray[i] == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String minimumLeadingDigits(int n, int n2) {
        if (n < 0) {
            return "-" + StringParser.substring(StringParser.x("0", n2) + Math.abs(n), 0 - n2);
        }
        return StringParser.substring(StringParser.x("0", n2) + n, 0 - n2);
    }

    public static String minimumTrailingDigits(int n, int n2) {
        if (n < 0) {
            return "-" + StringParser.substring(Math.abs(n) + StringParser.x("0", n2), 0 - n2);
        }
        return StringParser.substring(n + StringParser.x("0", n2), 0 - n2);
    }

    public static Object[] options(long l, String[] stringArray, String ... stringArray2) throws ParseException {
        int n;
        if (stringArray2.length == 0) {
            throw new IllegalArgumentException("No bitFields were specified");
        }
        long l2 = l;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        HashMap<String, Long> hashMap = new HashMap<String, Long>(stringArray2.length, 1.0f);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(stringArray2.length, 1.0f);
        for (String stringArray3 : stringArray2) {
            n = stringArray3.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("Option key/value pair definition number " + n2 + " is invalid");
            }
            String string = stringArray3.substring(0, n).toUpperCase();
            if (!StringParser.isInternetName(string)) {
                throw new IllegalArgumentException("Option key name in key/value pair definition number " + n2 + " contains invalid characters");
            }
            if (hashMap.containsKey(string)) {
                throw new IllegalArgumentException("Option key/value pair " + string + " defined twice");
            }
            String string2 = stringArray3.substring(n + 1);
            if (string2.equals("*")) {
                hashMap.put(string + "=", 0L);
                hashMap2.put(string + "=", stringArray3.substring(0, n));
            } else if (string2.equals("+")) {
                hashMap.put(string + "=", 1L);
                hashMap2.put(string + "=", stringArray3.substring(0, n));
            } else {
                hashMap.put(string, Long.decode(string2));
                hashMap2.put(string, stringArray3.substring(0, n));
            }
            ++n2;
        }
        n2 = 0;
        boolean bl = true;
        for (String string : stringArray) {
            int n3 = 0;
            int n4 = 0;
            switch (string.charAt(0)) {
                case '+': {
                    n3 = 1;
                    string = string.substring(1);
                    break;
                }
                case '-': {
                    n4 = 1;
                    string = string.substring(1);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            n = string.indexOf(61);
            switch (n) {
                case 0: {
                    throw new ParseException("Option name is too short", n2);
                }
                case -1: {
                    String string3 = string.toUpperCase();
                    if (hashMap.containsKey(string3)) {
                        long string4 = (Long)hashMap.get(string3);
                        if (string4 == 0L) {
                            if (n3 != 0 || n4 != 0) {
                                throw new ParseException("This option not permitted to have a prefix", n2);
                            }
                            if (n2 > 0 || stringArray.length > 1) {
                                throw new ParseException("This option must stand alone", n2);
                            }
                            l2 = 0L;
                            break;
                        }
                        if (n4 != 0) {
                            l2 -= l2 & string4;
                            break;
                        }
                        l2 |= string4;
                        break;
                    }
                    n = string.length() - 1;
                }
                default: {
                    String string3 = string.substring(0, n + 1).toUpperCase();
                    String string4 = string.substring(n + 1);
                    if (hashMap.containsKey(string3)) {
                        if ((Long)hashMap.get(string3) == 1L && string4.length() == 0) {
                            throw new ParseException("A value must be supplied", n2);
                        }
                        arrayList.add((String)hashMap2.get(string3) + "=" + string4);
                        break;
                    }
                    if (n == -1) {
                        throw new ParseException("Invalid option", n2);
                    }
                    String string5 = string3.substring(0, n);
                    if (hashMap.containsKey(string3)) {
                        if ((Long)hashMap.get(string3) == 1L) {
                            throw new ParseException("A value must be supplied", n2);
                        }
                        arrayList.add((String)hashMap2.get(string3) + "=" + string4);
                        break;
                    }
                    throw new ParseException("Invalid option", n2);
                }
            }
            ++n2;
        }
        return new Object[]{l2, arrayList.toArray(new String[0])};
    }

    public static Object[] options(BigInteger bigInteger, String[] stringArray, String ... stringArray2) throws ParseException {
        int n;
        if (stringArray2.length == 0) {
            throw new IllegalArgumentException("No bitFields were specified");
        }
        BigInteger bigInteger2 = bigInteger == null ? BigInteger.valueOf(0L) : bigInteger;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        HashMap<String, BigInteger> hashMap = new HashMap<String, BigInteger>(stringArray2.length, 1.0f);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(stringArray2.length, 1.0f);
        for (String stringArray3 : stringArray2) {
            n = stringArray3.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("Option key/value pair definition number " + n2 + " is invalid");
            }
            String string = stringArray3.substring(0, n).toUpperCase();
            if (!StringParser.isInternetName(string)) {
                throw new IllegalArgumentException("Option key name in key/value pair definition number " + n2 + " contains invalid characters");
            }
            if (hashMap.containsKey(string)) {
                throw new IllegalArgumentException("Option key/value pair " + string + " defined twice");
            }
            String string2 = stringArray3.substring(n + 1);
            if (string2.equals("*")) {
                hashMap.put(string + "=", BigInteger.valueOf(0L));
                hashMap2.put(string + "=", stringArray3.substring(0, n));
            } else if (string2.equals("+")) {
                hashMap.put(string + "=", BigInteger.valueOf(1L));
                hashMap2.put(string + "=", stringArray3.substring(0, n));
            } else {
                hashMap.put(string, new BigInteger(string2));
                hashMap2.put(string, stringArray3.substring(0, n));
            }
            ++n2;
        }
        n2 = 0;
        boolean bl = true;
        for (String string : stringArray) {
            int n3 = 0;
            int n4 = 0;
            switch (string.charAt(0)) {
                case '+': {
                    n3 = 1;
                    string = string.substring(1);
                    break;
                }
                case '-': {
                    n4 = 1;
                    string = string.substring(1);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            n = string.indexOf(61);
            switch (n) {
                case 0: {
                    throw new ParseException("Option name is too short", n2);
                }
                case -1: {
                    Object object;
                    String string3 = string.toUpperCase();
                    if (hashMap.containsKey(string3)) {
                        object = (BigInteger)hashMap.get(string3);
                        if (((BigInteger)object).equals(BigInteger.valueOf(0L))) {
                            if (n3 != 0 || n4 != 0) {
                                throw new ParseException("This option not permitted to have a prefix", n2);
                            }
                            if (n2 > 0 || stringArray.length > 1) {
                                throw new ParseException("This option must stand alone", n2);
                            }
                            bigInteger2 = BigInteger.valueOf(0L);
                            break;
                        }
                        if (n4 != 0) {
                            bigInteger2 = bigInteger2.subtract(bigInteger2.and((BigInteger)object));
                            break;
                        }
                        bigInteger2 = bigInteger2.or((BigInteger)object);
                        break;
                    }
                    n = string.length() - 1;
                }
                default: {
                    String string3 = string.substring(0, n + 1).toUpperCase();
                    Object object = string.substring(n + 1);
                    if (hashMap.containsKey(string3)) {
                        if (((BigInteger)hashMap.get(string3)).equals(BigInteger.valueOf(1L)) && ((String)object).length() == 0) {
                            throw new ParseException("A value must be supplied", n2);
                        }
                        arrayList.add((String)hashMap2.get(string3) + "=" + (String)object);
                        break;
                    }
                    if (n == -1) {
                        throw new ParseException("Invalid option", n2);
                    }
                    String string4 = string3.substring(0, n);
                    if (hashMap.containsKey(string3)) {
                        if (((BigInteger)hashMap.get(string3)).equals(BigInteger.valueOf(1L))) {
                            throw new ParseException("A value must be supplied", n2);
                        }
                        arrayList.add((String)hashMap2.get(string3) + "=" + (String)object);
                        break;
                    }
                    throw new ParseException("Invalid option", n2);
                }
            }
            ++n2;
        }
        return new Object[]{bigInteger2, arrayList.toArray(new String[0])};
    }

    public static String padLeft(int n, String string, String string2) {
        if (n <= 0 || string == null) {
            return string2;
        }
        if (string2 == null) {
            return StringParser.x(string, n);
        }
        int n2 = string2.length();
        if (n2 >= n) {
            return string2;
        }
        return StringParser.x(string, n - n2).substring(0, n - n2) + string2;
    }

    public static String padRight(int n, String string, String string2) {
        if (n <= 0 || string2 == null) {
            return string;
        }
        if (string == null) {
            return StringParser.x(string2, n);
        }
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        return string + StringParser.x(string2, n - n2).substring(0, n - n2);
    }

    public static boolean parseBoolean(String string, boolean bl, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                string = stringArray[i].substring(string2.length());
                break;
            }
        }
        try {
            return Boolean.parseBoolean(string);
        }
        catch (NumberFormatException numberFormatException) {
            return bl;
        }
    }

    public static byte parseByte(String string, byte by, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                string = stringArray[i].substring(string2.length());
                break;
            }
        }
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return by;
        }
    }

    public static double parseDouble(String string, double d, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                string = stringArray[i].substring(string2.length());
                break;
            }
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static float parseFloat(String string, float f, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                string = stringArray[i].substring(string2.length());
                break;
            }
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static int parseInt(String string, int n, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                string = stringArray[i].substring(string2.length());
                break;
            }
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static long parseLong(String string, long l, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                string = stringArray[i].substring(string2.length());
                break;
            }
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static byte parseNybble(String string, byte by, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                string = stringArray[i].substring(string2.length());
                break;
            }
        }
        try {
            return Nybble.parseNybble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Nybble.coerce(by);
        }
    }

    public static VeryLong parseVeryLong(String string, VeryLong veryLong, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                string = stringArray[i].substring(string2.length());
                break;
            }
        }
        try {
            return VeryLong.parseVeryLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return veryLong;
        }
    }

    public static short parseShort(String string, short s, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                string = stringArray[i].substring(string2.length());
                break;
            }
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return s;
        }
    }

    public static String refineIPAddress(String string) {
        if (StringParser.isIPv4AddressRelaxed(string)) {
            return StringParser.refineIPv4Address(string);
        }
        if (StringParser.isIPv6Address(string)) {
            return StringParser.refineIPv6Address(string);
        }
        throw new IllegalArgumentException("Invalid IP address");
    }

    public static String refineIPv4Address(String string) {
        if (!StringParser.isIPv4AddressRelaxed(string)) {
            throw new IllegalArgumentException("Invalid IPv4 address");
        }
        String[] stringArray = string.split("\\.");
        return Integer.parseInt(stringArray[0]) + "." + Integer.parseInt(stringArray[1]) + "." + Integer.parseInt(stringArray[2]) + "." + Integer.parseInt(stringArray[3]);
    }

    public static String refineIPv6Address(String string) {
        if (!StringParser.isIPv6Address(string)) {
            throw new IllegalArgumentException("Invalid IPv6 address");
        }
        String[] stringArray = string.split(":");
        if (stringArray.length < 8) {
            int n = string.indexOf("::");
            stringArray = ((n == 0 ? "0" : string.substring(0, n)) + StringParser.x(":0", 9 - stringArray.length) + string.substring(n + 1)).split(":");
        }
        return Integer.toHexString(Integer.parseInt(stringArray[0], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[1], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[2], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[3], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[4], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[5], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[6], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[7], 16));
    }

    public static String refineDomainLiteral(String string) {
        if (StringParser.isDomainLiteral4(string)) {
            return StringParser.refineDomainLiteral4(string);
        }
        if (StringParser.isDomainLiteral6(string)) {
            return StringParser.refineDomainLiteral6(string);
        }
        throw new IllegalArgumentException("Invalid domain literal");
    }

    public static String refineDomainLiteral4(String string) {
        if (!StringParser.isDomainLiteral4(string)) {
            throw new IllegalArgumentException("Invalid IPv4 domain literal");
        }
        String[] stringArray = string.substring(1, string.length() - 1).split("\\.");
        return "[" + Integer.parseInt(stringArray[0]) + "." + Integer.parseInt(stringArray[1]) + "." + Integer.parseInt(stringArray[2]) + "." + Integer.parseInt(stringArray[3]) + "]";
    }

    public static String refineDomainLiteral6(String string) {
        if (!StringParser.isDomainLiteral6(string)) {
            throw new IllegalArgumentException("Invalid IPv6 address");
        }
        String[] stringArray = string.substring(1, string.length() - 1).split(":");
        if (stringArray.length < 8) {
            int n = string.indexOf("::");
            stringArray = ((n == 0 ? "0" : string.substring(1, n)) + StringParser.x(":0", 9 - stringArray.length) + string.substring(n + 1, string.length() - 1)).split(":");
        }
        return "[" + Integer.toHexString(Integer.parseInt(stringArray[0], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[1], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[2], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[3], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[4], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[5], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[6], 16)) + ":" + Integer.toHexString(Integer.parseInt(stringArray[7], 16)) + "]";
    }

    public static HashMap<String, String[]> refineSASLExchange(String string) throws ParseException {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        if (string == null) {
            return hashMap;
        }
        HashMap hashMap2 = new HashMap();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string + ",");
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        boolean bl2 = false;
        int n = -1;
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            ++n;
            switch (c) {
                case '\"': {
                    if (bl) {
                        throw new ParseException("Key names can't contain quotation marks", n);
                    }
                    if (!bl2 && stringBuilder.length() > 0) {
                        throw new ParseException("Malformed quoted value", n);
                    }
                    bl2 = !bl2;
                    stringBuilder.append(c);
                    break;
                }
                case '\\': {
                    if (bl) {
                        throw new ParseException("Key names can't contain escaped literal characters", n);
                    }
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        throw new ParseException("Literal character is missing", n);
                    }
                    if (c < ' ' || c == '\u007f') {
                        throw new ParseException("Invalid charater", n);
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    break;
                }
                case ' ': {
                    if (!bl2) {
                        throw new ParseException("White space characters not permitted", n);
                    }
                    stringBuilder.append(c);
                    break;
                }
                case '=': {
                    if (bl2) {
                        stringBuilder.append(c);
                        break;
                    }
                    if (!bl) {
                        throw new ParseException("Invalid character", n);
                    }
                    boolean bl3 = bl = !bl;
                    if (stringBuilder.length() == 0) {
                        throw new ParseException("Missing key name", n);
                    }
                    string2 = stringBuilder.toString();
                    stringBuilder = new StringBuilder();
                    break;
                }
                case ',': {
                    if (bl2) {
                        stringBuilder.append(c);
                        break;
                    }
                    if (bl) {
                        throw new ParseException("Invalid character", n);
                    }
                    boolean bl4 = bl = !bl;
                    if (stringBuilder.charAt(0) == '\"' && stringBuilder.charAt(stringBuilder.length() - 1) != '\"') {
                        throw new ParseException("Malformed quoted value", n);
                    }
                    if (!hashMap2.containsKey(string2)) {
                        hashMap2.put(string2, new ArrayList());
                    }
                    if (!arrayList.contains(string2)) {
                        arrayList.add(string2);
                    }
                    ((ArrayList)hashMap2.get(string2)).add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    break;
                }
                default: {
                    if (c < ' ' || c == '\u007f') {
                        throw new ParseException("Invalid character", n);
                    }
                    if (bl && "()<>@,;:\\\"/[]?={} ".indexOf(c) != -1) {
                        throw new ParseException("Invalid character", n);
                    }
                    stringBuilder.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        if (bl2) {
            throw new ParseException("Incomplete value", n);
        }
        hashMap.put(null, arrayList.toArray(new String[0]));
        for (String string3 : hashMap.get(null)) {
            hashMap.put(string3, ((ArrayList)hashMap2.get(string3)).toArray(new String[0]));
        }
        return hashMap;
    }

    public static String[] splitPairs(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0 || string == null || string.length() == 0) {
            return new String[0];
        }
        String[] stringArray2 = StringParser.atomize(string);
        int n = stringArray2.length;
        int n2 = stringArray.length;
        String[] stringArray3 = new String[n2];
        block0: for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i] + "=";
            for (int j = 0; j < n; ++j) {
                if (!stringArray2[j].startsWith(string2)) continue;
                stringArray3[i] = stringArray2[j].substring(string2.length());
                continue block0;
            }
        }
        return stringArray3;
    }

    public static String substring(String string, int n) {
        if (n >= string.length()) {
            return string;
        }
        if (n >= 0) {
            return string.substring(n);
        }
        int n2 = string.length() + n;
        if (n2 > 0) {
            return string.substring(n2);
        }
        return string;
    }

    public static boolean transmuteBoolean(String string, boolean bl, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                try {
                    return Boolean.parseBoolean(stringArray[i].substring(string2.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return bl;
                }
            }
        }
        return bl;
    }

    public static byte transmuteByte(String string, byte by, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                try {
                    return Byte.parseByte(stringArray[i].substring(string2.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return by;
                }
            }
        }
        return by;
    }

    public static double transmuteDouble(String string, double d, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                try {
                    return Double.parseDouble(stringArray[i].substring(string2.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return d;
                }
            }
        }
        return d;
    }

    public static float transmuteFloat(String string, float f, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                try {
                    return Float.parseFloat(stringArray[i].substring(string2.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return f;
                }
            }
        }
        return f;
    }

    public static int transmuteInt(String string, int n, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                try {
                    return Integer.parseInt(stringArray[i].substring(string2.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return n;
                }
            }
        }
        return n;
    }

    public static long transmuteLong(String string, long l, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                try {
                    return Long.parseLong(stringArray[i].substring(string2.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return l;
                }
            }
        }
        return l;
    }

    public static byte transmuteNybble(String string, byte by, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                try {
                    return Nybble.parseNybble(stringArray[i].substring(string2.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return by;
                }
            }
        }
        return by;
    }

    public static VeryLong transmuteVeryLong(String string, VeryLong veryLong, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                try {
                    return VeryLong.parseVeryLong(stringArray[i].substring(string2.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return veryLong;
                }
            }
        }
        return veryLong;
    }

    public static short transmuteShort(String string, short s, String ... stringArray) {
        if (stringArray != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "=";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].startsWith(string2)) continue;
                try {
                    return Short.parseShort(stringArray[i].substring(string2.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    return s;
                }
            }
        }
        return s;
    }

    public static String trimQuotes(String string) {
        if (string == null) {
            return "";
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String quote(String string) {
        if (string == null) {
            return "";
        }
        string = string.replaceAll("\\", "\\\\").replaceAll("\"", "\\\"");
        return "\"" + string + "\"";
    }

    public static String quoteMinimal(String string) {
        if (string == null) {
            return "";
        }
        return (string = string.replaceAll("\\\\", "\\\\").replaceAll("\\\"", "\\\"")).indexOf(" ") != -1 || string.indexOf("\t") != -1 ? "\"" + string + "\"" : string;
    }

    public static String x(String string, int n) {
        if (string == null || string.equals("") || n < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static boolean isSafeFilename(String string) {
        if (string.startsWith("-")) {
            return false;
        }
        if (string.indexOf("..") >= 0) {
            return false;
        }
        if (string.endsWith(".")) {
            return false;
        }
        if (string.indexOf(32) >= 0) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (SAFE_FILENAME_CHARACTERS.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSafeFilename(int n, String string, String string2) {
        if (string2.startsWith("-")) {
            return false;
        }
        if (string2.indexOf("..") >= 0) {
            return false;
        }
        if (string2.endsWith(".")) {
            return false;
        }
        if (string2.indexOf(32) >= 0) {
            return false;
        }
        String string3 = string == null ? SAFE_FILENAME_CHARACTERS : string;
        for (char c : string2.toCharArray()) {
            if (string.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }
}

