/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.util;

import com.internationalnetwork.util.StringParser;
import java.text.ParseException;

public class Hostname {
    public static final String VERSION = "1.00";
    final String LET = "AaEeIiOoUuYyBbCcDdFfGgHhJjKkLlMmNnPpQqRrSsTtVvWwXxZz";
    final String DIG = "0123456789";
    final String DIG_HYP = "0123456789-";
    final String LET_DIG = "AaEeIiOoUuYyBbCcDdFfGgHhJjKkLlMmNnPpQqRrSsTtVvWwXxZz0123456789";
    final String LET_DIG_HYP = "AaEeIiOoUuYyBbCcDdFfGgHhJjKkLlMmNnPpQqRrSsTtVvWwXxZz0123456789-";
    String[] reverseHostname = new String[0];
    boolean flagStandard = false;
    int levels = 0;
    boolean flagDigBegin = false;
    boolean flagDigBeginM = false;
    boolean flagHypBegin = false;
    boolean flagHypBeginM = false;
    boolean flagHypEnd = false;
    boolean flagHypEndM = false;
    boolean flagLabelLong = false;
    boolean flagLabelLongM = false;

    public Hostname() {
    }

    public Hostname(String string) throws ParseException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            throw new ParseException("Hostname too short", 0);
        }
        switch (string.charAt(0)) {
            case '.': {
                throw new ParseException("Hostname cannot begin with a period", 0);
            }
            case '-': {
                this.flagHypBegin = true;
                break;
            }
            default: {
                if ("0123456789".indexOf(string.charAt(0)) <= -1) break;
                this.flagDigBegin = true;
            }
        }
        switch (string.charAt(n - 1)) {
            case '.': {
                throw new ParseException("Hostname cannot end with a period", n2);
            }
            case '-': {
                this.flagHypEnd = true;
            }
        }
        this.levels = 1;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '.') {
                if (string.charAt(n2 + 1) == '.') {
                    throw new ParseException("Hostname cannot contain consecutive periods", n2);
                }
                if (string.charAt(n2 - 1) == '-') {
                    if (this.flagHypEnd) {
                        this.flagHypEndM = true;
                    } else {
                        this.flagHypEnd = true;
                    }
                }
                if (string.charAt(n2 + 1) == '-') {
                    if (this.flagHypBegin) {
                        this.flagHypBeginM = true;
                    } else {
                        this.flagHypBegin = true;
                    }
                } else if ("0123456789".indexOf(string.charAt(n2 + 1)) != -1) {
                    if (this.flagDigBegin) {
                        this.flagDigBeginM = true;
                    } else {
                        this.flagDigBegin = true;
                    }
                }
                if (n2 - n3 > 63) {
                    if (this.flagLabelLong) {
                        this.flagLabelLongM = true;
                    } else {
                        this.flagLabelLong = true;
                    }
                }
                ++this.levels;
                n3 = n2 + 1;
            } else if ("AaEeIiOoUuYyBbCcDdFfGgHhJjKkLlMmNnPpQqRrSsTtVvWwXxZz0123456789-".indexOf(c) == -1) {
                throw new ParseException("Invalid character in hostname", n2);
            }
            ++n2;
        }
        this.flagStandard = !this.flagDigBegin && !this.flagHypBegin && !this.flagHypEnd && !this.flagLabelLong;
        this.reverseHostname = string.split("\\.");
    }

    public String getLevel(int n) {
        if (n > 0) {
            return this.reverseHostname[this.reverseHostname.length - (n - 1)];
        }
        if (n == 0) {
            return this.toString();
        }
        return this.reverseHostname[-1 - n];
    }

    public int getLevelCount() {
        return this.levels;
    }

    public String toString() {
        return StringParser.join(".", this.reverseHostname);
    }

    public boolean isStandard() {
        return this.flagStandard;
    }

    public boolean hasLongLabel() {
        return this.flagLabelLong;
    }

    public boolean hasLongLabels() {
        return this.flagLabelLongM;
    }

    public boolean hasLeadingDigit() {
        return this.flagDigBegin;
    }

    public boolean hasLeadingDigits() {
        return this.flagDigBeginM;
    }

    public boolean hasLeadingHyphen() {
        return this.flagHypBegin;
    }

    public boolean hasLeadingHyphens() {
        return this.flagHypBeginM;
    }

    public boolean hasTrailingHyphen() {
        return this.flagHypEnd;
    }

    public boolean hasTrailingHyphens() {
        return this.flagHypEndM;
    }

    public static void main(String ... stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage:  Hostname example.com");
            System.exit(1);
        }
        try {
            Hostname hostname = new Hostname(stringArray[0]);
            System.out.println("Standard:  " + hostname.isStandard());
            System.out.println("  Levels:  " + hostname.getLevelCount());
        }
        catch (ParseException parseException) {
            System.out.println("Error message:  " + parseException.getMessage());
            System.out.println("       Offset:  " + parseException.getErrorOffset());
        }
    }
}

