/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.util;

import com.internationalnetwork.util.StringParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;

public class ElectronicMailAddress {
    public static final String VERSION = "1.00";
    final String ATEXT = "!#$%&'*+-/0123456789=?ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz{|}~";
    final String ATEXTOBSOLETE = " \t!#$%&'*+-./0123456789=?ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz{|}~";
    final String CTEXT = "!\"#$%&'*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~";
    final String CTEXTWSP = " \t!\"#$%&'*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~";
    final String DTEXT = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz{|}~";
    final String FWS = " \t\n\r";
    final String QTEXT = " !#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~";
    final String TEXT = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f";
    final String WSP = " \t";
    boolean tabConversion = true;
    String GNData = "";
    int GNFlags = 0;
    boolean GNObsolete = false;
    String DNData = "";
    int DNFlags = 0;
    boolean DNObsolete = false;
    String LPData = "";
    int LPFlags = 0;
    boolean LPObsolete = false;
    String IDNData = "";
    int IDNFlags = 0;
    int IDNLevelCount = 0;
    int IDNLevelCountTemp = 0;
    boolean IDNObsolete = false;
    String additionalData = "";
    boolean valid = false;
    String error = "";
    boolean nullAngleAddr = false;
    boolean localAddress = false;
    boolean angleAddr = false;

    public ElectronicMailAddress() {
    }

    public ElectronicMailAddress(String string) throws ParseException {
        String string2 = "";
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        block42: while (true) {
            n5 = 0;
            try {
                switch (n2) {
                    case 0: 
                    case 1: {
                        n3 = this.checkDN(string.substring(n4));
                        n2 = 2;
                    }
                    case 2: {
                        n3 = this.checkLP(string.substring(n4));
                        break;
                    }
                    case 3: {
                        n3 = this.checkIDN(string.substring(n4));
                        break;
                    }
                    case 4: {
                        n3 = this.checkCFWS(string.substring(n4));
                        break;
                    }
                    default: {
                        this.additionalData = string.substring(n4);
                        break;
                    }
                }
            }
            catch (ParseException parseException) {
                n5 = parseException.getErrorOffset();
                string3 = parseException.getMessage();
                if (n4 + n5 >= n) break;
                switch (string.charAt(n4 + n5)) {
                    case ':': {
                        if (n2 == 3) {
                            ++n4;
                            continue block42;
                        }
                        if (n2 >= 1) {
                            if (bl) {
                                throw new ParseException("Group construct cannot be nested", n4);
                            }
                            throw new ParseException("Group construct not allowed here", n4);
                        }
                        if (n5 == 0) {
                            throw new ParseException("Group construct display-name too short", n4);
                        }
                        try {
                            this.GNData = string.substring(n4, n4 + n5);
                            this.GNFlags = this.checkDN(this.GNData);
                        }
                        catch (ParseException parseException2) {
                            throw new ParseException(parseException2.getMessage(), n4 + parseException2.getErrorOffset());
                        }
                        bl = true;
                        n2 = 1;
                        n4 += n5 + 1;
                        continue block42;
                    }
                    case '<': {
                        if (this.angleAddr) {
                            throw new ParseException("Too many opening angle brackets", n4);
                        }
                        if (n2 >= 2) {
                            throw new ParseException(string3, n4);
                        }
                        try {
                            this.DNData = string.substring(n4, n4 + n5);
                            this.DNFlags = this.checkDN(this.DNData);
                        }
                        catch (ParseException parseException3) {
                            throw new ParseException(parseException3.getMessage(), n4 + parseException3.getErrorOffset());
                        }
                        this.angleAddr = true;
                        n2 = 2;
                        n4 += n5 + 1;
                        continue block42;
                    }
                    case '@': {
                        if (n2 >= 3) {
                            throw new ParseException(string3, n4 + n5);
                        }
                        try {
                            this.LPData = string.substring(n4, n4 + n5);
                            this.LPFlags = this.checkLP(this.LPData);
                        }
                        catch (ParseException parseException4) {
                            throw new ParseException(parseException4.getMessage(), n4 + parseException4.getErrorOffset());
                        }
                        n2 = 3;
                        n4 += n5 + 1;
                        continue block42;
                    }
                    case '>': {
                        if (!this.angleAddr) {
                            throw new ParseException("Missing opening angle bracket", n4 + n5);
                        }
                        if (bl2) {
                            throw new ParseException("Too many closing angle brackets", n4 + n5);
                        }
                        try {
                            switch (n2) {
                                case 3: {
                                    this.IDNData = string.substring(n4, n4 + n5);
                                    this.IDNFlags = this.checkIDN(this.IDNData);
                                    this.IDNLevelCount = this.IDNLevelCountTemp;
                                    break;
                                }
                                default: {
                                    this.LPData = string.substring(n4, n4 + n5);
                                    this.LPFlags = this.checkIDN(this.LPData);
                                    break;
                                }
                            }
                        }
                        catch (ParseException parseException5) {
                            throw new ParseException(parseException5.getMessage(), n4 + parseException5.getErrorOffset());
                        }
                        bl2 = true;
                        n2 = 4;
                        n4 += n5 + 1;
                        continue block42;
                    }
                    case ';': {
                        if (!bl) {
                            throw new ParseException("Group construct display-name not defined", n4 + n5);
                        }
                        bl = false;
                    }
                    case ',': {
                        if (this.angleAddr && n2 < 4) {
                            throw new ParseException("Missing closing angle bracket", n4 + n5);
                        }
                        try {
                            switch (n2) {
                                case 3: {
                                    if (this.angleAddr) break;
                                    this.IDNData = string.substring(n4, n4 + n5);
                                    this.IDNFlags = this.checkIDN(this.IDNData);
                                    this.IDNLevelCount = this.IDNLevelCountTemp;
                                    break;
                                }
                                case 0: 
                                case 1: 
                                case 2: {
                                    this.LPData = string.substring(n4, n4 + n5);
                                    this.LPFlags = this.checkLP(this.LPData);
                                }
                            }
                        }
                        catch (ParseException parseException6) {
                            throw new ParseException(parseException6.getMessage(), n4 + parseException6.getErrorOffset());
                        }
                        n2 = 5;
                        n4 += n5 + 1;
                        continue block42;
                    }
                }
                throw new ParseException(string3, n4 + n5);
            }
            break;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                try {
                    this.setLP(string.substring(n4));
                    break;
                }
                catch (ParseException parseException) {
                    throw new ParseException(parseException.getMessage(), n4 + parseException.getErrorOffset());
                }
            }
            case 3: {
                try {
                    this.setIDN(string.substring(n4));
                    break;
                }
                catch (ParseException parseException) {
                    throw new ParseException(parseException.getMessage(), n4 + parseException.getErrorOffset());
                }
            }
            case 4: {
                this.additionalData = (this.GNData.length() > 0 ? this.GNData + ":" : "") + string.substring(n4);
            }
        }
        if (this.angleAddr && n2 < 4) {
            throw new ParseException("Missing closing angle bracket", n4);
        }
        if (bl) {
            if (this.additionalData.length() == 0) {
                throw new ParseException("Group construct must be terminated", 0);
            }
            this.additionalData = this.GNData + ":" + this.additionalData;
        }
    }

    public int checkCFWS(String string) throws ParseException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = string.length();
        boolean bl6 = false;
        int n2 = 0;
        int n3 = 0;
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl6 && " \t!\"#$%&'*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c) != -1) continue;
            switch (c) {
                case '\\': {
                    if (!bl6) {
                        throw new ParseException("Quoted-pair not permitted here", i);
                    }
                    if (++i == n) {
                        throw new ParseException("Literal character missing from quoted-pair", --i);
                    }
                    c = string.charAt(i);
                    bl2 = true;
                    if (c > '\u007f' || c < '\u0000') {
                        throw new ParseException("8-bit character encountered", i);
                    }
                    if (c != '\u0000' && c != '\n' && c != '\r') continue block10;
                    bl5 = true;
                    continue block10;
                }
                case '(': {
                    switch (n2) {
                        case 0: {
                            bl6 = true;
                            bl3 = true;
                            n3 = i;
                            break;
                        }
                        case 1: {
                            bl4 = true;
                        }
                    }
                    ++n2;
                    continue block10;
                }
                case ')': {
                    if (n2 == 0) {
                        throw new ParseException("Unbalanced comment terminator", i);
                    }
                    if (--n2 != 0) continue block10;
                    bl6 = false;
                    continue block10;
                }
                case '\r': {
                    if (++i == n) {
                        throw new ParseException("CRLF 1*WSP sequence incomplete", --i);
                    }
                    c = string.charAt(i);
                    if (c != '\n') {
                        throw new ParseException("Invalid character - CR must preceed LF", i);
                    }
                    if (++i == n) {
                        throw new ParseException("CRLF 1*WSP sequence incomplete", --i);
                    }
                    c = string.charAt(i);
                    if (" \t".indexOf(c) == -1) {
                        throw new ParseException("Invalid character - CRLF must preceed WSP", i);
                    }
                    bl5 = true;
                    continue block10;
                }
                default: {
                    if (" \t".indexOf(c) != -1) continue block10;
                    throw new ParseException("Invalid character", i);
                }
            }
        }
        if (bl6) {
            throw new ParseException("Unclosed comment", n3);
        }
        return (bl2 ? 2 : 0) + (bl3 ? 8 : 0) + (bl4 ? 16 : 0) + (bl5 ? 32 : 0);
    }

    public int checkDN(String string) throws ParseException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n2 = string.length();
        int n3 = 0;
        boolean bl7 = false;
        int n4 = 0;
        block10: for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (n4 > 0 && " \t!\"#$%&'*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c) != -1) continue;
            switch (c) {
                case '\"': {
                    bl7 = !bl7;
                    bl = true;
                    continue block10;
                }
                case '\\': {
                    if (!bl7 && n4 == 0) {
                        throw new ParseException("Quoted-pair not permitted here", n);
                    }
                    if (++n == n2) {
                        throw new ParseException("Literal character missing from quoted-pair", --n);
                    }
                    c = string.charAt(n);
                    bl2 = true;
                    if (c > '\u007f' || c < '\u0000') {
                        throw new ParseException("8-bit character encountered", n);
                    }
                    if (c != '\u0000' && c != '\n' && c != '\r') continue block10;
                    bl3 = true;
                    continue block10;
                }
                case '(': {
                    if (bl7) continue block10;
                    bl4 = true;
                    if (n4 > 0) {
                        bl5 = true;
                    }
                    ++n4;
                    continue block10;
                }
                case ')': {
                    if (bl7) continue block10;
                    if (n4 == 0) {
                        throw new ParseException("Unbalanced comment terminator", n);
                    }
                    --n4;
                    continue block10;
                }
                case '.': {
                    if (n3 == n) {
                        throw new ParseException("Period cannot come first", n);
                    }
                    if (bl7) continue block10;
                    bl3 = true;
                    continue block10;
                }
                case '\t': 
                case ' ': {
                    ++n3;
                    continue block10;
                }
                case '\r': {
                    if (++n == n2) {
                        throw new ParseException("Incomplete CRLF WSP sequence", --n);
                    }
                    if (string.charAt(n) != '\n') {
                        throw new ParseException("Invalid character (expecting LF)", n);
                    }
                    if (++n == n2) {
                        throw new ParseException("Incomplete CRLF WSP sequence", --n);
                    }
                    if (" \t".indexOf(string.charAt(n)) == -1) {
                        throw new ParseException("Invalid character (expecting WSP)", n);
                    }
                    n3 += 3;
                    bl6 = true;
                    continue block10;
                }
                case '\n': {
                    ++n3;
                }
                default: {
                    if (bl7) {
                        if (" !#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c) != -1) continue block10;
                        throw new ParseException("Invalid character in quoted-string", n);
                    }
                    if ("!#$%&'*+-/0123456789=?ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c) != -1) continue block10;
                    throw new ParseException("Invalid character", n);
                }
            }
        }
        if (bl7) {
            throw new ParseException("Unclosed quoted-string", n);
        }
        if (n4 > 0) {
            throw new ParseException("Unclosed comment", n);
        }
        this.DNFlags = (bl ? 1 : 0) + (bl2 ? 2 : 0) + (bl3 ? 4 : 0) + (bl4 ? 8 : 0) + (bl5 ? 16 : 0) + (bl6 ? 32 : 0);
        return this.DNFlags;
    }

    public int checkLP(String string) throws ParseException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        boolean bl8 = false;
        int n5 = 0;
        char c = '\u0000';
        block10: for (n = 0; n < n2; ++n) {
            char c2 = string.charAt(n);
            ++n3;
            if (" \t\n\r".indexOf(c2) == -1) {
                c = c2;
            }
            if (n5 > 0 && " \t!\"#$%&'*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c2) != -1) continue;
            switch (c2) {
                case '\"': {
                    if (bl && !bl8) {
                        bl7 = true;
                        bl3 = true;
                    }
                    bl8 = !bl8;
                    bl = true;
                    continue block10;
                }
                case '\\': {
                    if (!bl8 && n5 == 0) {
                        throw new ParseException("Quoted-pair not permitted here", n);
                    }
                    if (++n == n2) {
                        throw new ParseException("Literal character missing from quoted-pair", --n);
                    }
                    c2 = string.charAt(n);
                    bl2 = true;
                    if (c2 > '\u007f' || c2 < '\u0000') {
                        throw new ParseException("8-bit character encountered", n);
                    }
                    if (c2 != '\u0000' && c2 != '\n' && c2 != '\r') continue block10;
                    bl3 = true;
                    continue block10;
                }
                case '(': {
                    if (bl8) continue block10;
                    bl4 = true;
                    if (n5 > 0) {
                        bl5 = true;
                    }
                    ++n5;
                    continue block10;
                }
                case ')': {
                    if (bl8) continue block10;
                    if (n5 == 0) {
                        throw new ParseException("Unbalanced comment terminator", n);
                    }
                    --n5;
                    continue block10;
                }
                case '.': {
                    if (n4 == n) {
                        throw new ParseException("Period cannot come first", n);
                    }
                    if (bl8) continue block10;
                    bl3 = true;
                    continue block10;
                }
                case '\t': 
                case ' ': {
                    ++n4;
                    continue block10;
                }
                case '\r': {
                    if (++n == n2) {
                        throw new ParseException("Incomplete CRLF WSP sequence", --n);
                    }
                    if (string.charAt(n) != '\n') {
                        throw new ParseException("Invalid character (expecting LF)", n);
                    }
                    if (++n == n2) {
                        throw new ParseException("Incomplete CRLF WSP sequence", --n);
                    }
                    if (" \t".indexOf(string.charAt(n)) == -1) {
                        throw new ParseException("Invalid character (expecting WSP)", n);
                    }
                    n4 += 3;
                    n3 += 2;
                    bl6 = true;
                    continue block10;
                }
                case '\n': {
                    ++n4;
                }
                default: {
                    if (bl8) {
                        if (" !#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c2) != -1) continue block10;
                        throw new ParseException("Invalid character in quoted-string", n);
                    }
                    if ("!#$%&'*+-/0123456789=?ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c2) != -1) continue block10;
                    throw new ParseException("Invalid character", n);
                }
            }
        }
        if (n3 == 0) {
            throw new ParseException("Local-part too short", 0);
        }
        if (n3 > 64) {
            throw new ParseException("Local-part too long", n);
        }
        if (n4 == n2) {
            throw new ParseException("Local-part too short", 0);
        }
        if (bl8) {
            throw new ParseException("Unclosed quoted-string", n);
        }
        if (n5 > 0) {
            throw new ParseException("Unclosed comment", n);
        }
        if (c == '.') {
            throw new ParseException("Period cannot be last", n);
        }
        this.LPFlags = (bl ? 1 : 0) + (bl2 ? 2 : 0) + (bl3 ? 4 : 0) + (bl4 ? 8 : 0) + (bl5 ? 16 : 0) + (bl6 ? 32 : 0);
        return this.LPFlags;
    }

    public int checkIDN(String string) throws ParseException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        boolean bl8 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        this.IDNLevelCountTemp = 1;
        block12: for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            ++n3;
            if (" \t\n\r".indexOf(c) == -1) {
                n9 = n7;
                n10 = n8;
                n7 = c;
                n8 = n;
            }
            if (n6 > 0 && " \t!\"#$%&'*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c) != -1) continue;
            switch (c) {
                case '\"': {
                    throw new ParseException("Quoted-string not allowed in domain", n);
                }
                case '\\': {
                    if (!bl8 && n6 == 0) {
                        throw new ParseException("Quoted-pair not permitted here", n);
                    }
                    if (++n == n2) {
                        throw new ParseException("Literal character missing from quoted-pair", --n);
                    }
                    c = string.charAt(n);
                    bl2 = true;
                    if (c > '\u007f' || c < '\u0000') {
                        throw new ParseException("8-bit character encountered", n);
                    }
                    if (c != '\u0000' && c != '\n' && c != '\r') continue block12;
                    bl3 = true;
                    continue block12;
                }
                case '[': {
                    if (n4 != n) {
                        throw new ParseException("A domain-literal cannot be combined with a domain", n);
                    }
                    if (bl8) {
                        throw new ParseException("Cannot nest domain-literals", n);
                    }
                    if (bl) {
                        throw new ParseException("Only one domain-literal is allowed", n);
                    }
                    bl8 = true;
                    bl = true;
                    n5 = n + 1;
                    continue block12;
                }
                case ']': {
                    if (!bl) {
                        throw new ParseException("Cannot close unopened domain-literal", n);
                    }
                    if (!StringParser.isIPAddress(string.substring(n5, n))) {
                        throw new ParseException("Invalid IP address in domain-literal", n5);
                    }
                    bl8 = false;
                    continue block12;
                }
                case '(': {
                    if (bl8) continue block12;
                    bl4 = true;
                    if (n6 > 0) {
                        bl5 = true;
                    }
                    ++n6;
                    continue block12;
                }
                case ')': {
                    if (bl8) continue block12;
                    if (n6 == 0) {
                        throw new ParseException("Unbalanced comment terminator", n);
                    }
                    --n6;
                    continue block12;
                }
                case '.': {
                    if (n4 == n) {
                        throw new ParseException("Period cannot come first", n);
                    }
                    if (!bl) {
                        if (n9 == 46) {
                            throw new ParseException("Consecutive periods are not permitted", n10);
                        }
                        ++this.IDNLevelCountTemp;
                        continue block12;
                    }
                    if (bl8) continue block12;
                    throw new ParseException("A domain-literal cannot be combined with additional data", n);
                }
                case '\t': 
                case ' ': {
                    ++n4;
                    continue block12;
                }
                case '\r': {
                    if (++n == n2) {
                        throw new ParseException("Incomplete CRLF WSP sequence", --n);
                    }
                    if (string.charAt(n) != '\n') {
                        throw new ParseException("Invalid character (expecting LF)", n);
                    }
                    if (++n == n2) {
                        throw new ParseException("Incomplete CRLF WSP sequence", --n);
                    }
                    if (" \t".indexOf(string.charAt(n)) == -1) {
                        throw new ParseException("Invalid character (expecting WSP)", n);
                    }
                    n4 += 3;
                    n3 += 2;
                    bl6 = true;
                    continue block12;
                }
                case '\n': {
                    ++n4;
                }
                default: {
                    if (bl) {
                        if (bl8) {
                            if ("!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c) != -1) continue block12;
                            throw new ParseException("Invalid character in domain-literal", n);
                        }
                        if (" \t\n\r".indexOf(c) != -1) continue block12;
                        throw new ParseException("A domain-literal cannot be combined with a domain", n);
                    }
                    if ("!#$%&'*+-/0123456789=?ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(c) != -1) continue block12;
                    throw new ParseException("Invalid character", n);
                }
            }
        }
        if (n3 == 0) {
            throw new ParseException("Domain too short", 0);
        }
        if (n3 > 255) {
            throw new ParseException("Domain too long", n);
        }
        if (n4 == n2) {
            throw new ParseException("Domain not specified", 0);
        }
        if (bl8) {
            throw new ParseException("Unclosed domain-literal", n);
        }
        if (n6 > 0) {
            throw new ParseException("Unclosed comment", n);
        }
        if (n7 == 46) {
            throw new ParseException("Period cannot be last", n - 1);
        }
        if (bl) {
            this.IDNLevelCountTemp = -1;
        }
        this.IDNFlags = (bl ? 1 : 0) + (bl2 ? 2 : 0) + (bl3 ? 4 : 0) + (bl4 ? 8 : 0) + (bl5 ? 16 : 0) + (bl6 ? 32 : 0) + (this.IDNLevelCountTemp > 0 ? 64 : 0);
        return this.IDNFlags;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getErrorMessage() {
        return this.error;
    }

    public String getGN() {
        return this.GNData;
    }

    public int getGNFlags() {
        return this.GNFlags;
    }

    public boolean isGNObsolete() {
        return this.GNObsolete;
    }

    public String setGN(String string) {
        String string2 = this.GNData;
        this.GNData = string;
        return string2;
    }

    public boolean isInGroup() {
        return this.GNData.length() > 0;
    }

    public String getDN() {
        return this.DNData;
    }

    public int getDNFlags() {
        return this.DNFlags;
    }

    public boolean isDNObsolete() {
        return this.DNObsolete;
    }

    public String setDN(String string) throws ParseException {
        this.checkDN(string);
        String string2 = this.DNData;
        this.DNData = string;
        return string2;
    }

    public String getLP() {
        return this.LPData;
    }

    public int getLPFlags() {
        return this.LPFlags;
    }

    public boolean isLPObsolete() {
        return this.LPObsolete;
    }

    public String setLP(String string) throws ParseException {
        this.checkLP(string);
        String string2 = this.LPData;
        this.LPData = string;
        return string2;
    }

    public boolean isIDL() {
        return this.IDNData.endsWith("]");
    }

    public String getIDN() {
        return this.IDNData;
    }

    public int getIDNFlags() {
        return this.IDNFlags;
    }

    public int getIDNLevelCount() {
        return this.IDNLevelCount;
    }

    public boolean isIDNObsolete() {
        return this.IDNObsolete;
    }

    public String setIDN(String string) throws ParseException {
        this.checkIDN(string);
        this.IDNLevelCount = this.IDNLevelCountTemp;
        String string2 = this.IDNData;
        this.IDNData = string;
        return string2;
    }

    public boolean isAngleAddr() {
        return this.angleAddr;
    }

    public boolean isNullAngleAddr() {
        return this.nullAngleAddr;
    }

    public boolean isLocalAddress() {
        return this.localAddress;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public String setAdditionalData(String string) {
        String string2 = this.additionalData;
        this.additionalData = string;
        return string2;
    }

    public boolean getTabConversionMode() {
        return this.tabConversion;
    }

    public boolean setTabConversionMode(boolean bl) {
        boolean bl2 = this.tabConversion;
        this.tabConversion = bl;
        return bl2;
    }

    public String[] toArray() {
        return new String[]{this.GNData, this.DNData, this.LPData, this.IDNData, this.additionalData};
    }

    public String toString() {
        return this.LPData + "@" + this.IDNData;
    }

    public String toString(String ... stringArray) {
        String string;
        if (stringArray.length > 2) {
            throw new IllegalArgumentException("Too many arguments");
        }
        String string2 = this.LPData;
        if (string2.length() == 0) {
            string2 = stringArray.length >= 1 ? stringArray[0] : "nobody";
        }
        if ((string = this.IDNData).length() == 0) {
            string = stringArray.length >= 2 ? stringArray[1] : "localhost";
        }
        return this.DNData + "<" + this.LPData + "@" + this.IDNData + ">";
    }

    public static void main(String ... stringArray) {
        boolean bl = false;
        int n = -1;
        String string = "";
        if (stringArray.length == 1) {
            if (stringArray[0].equals("cfws")) {
                n = 0;
                string = stringArray[0];
            } else if (stringArray[0].equals("display-name")) {
                n = 1;
                string = stringArray[0];
            } else if (stringArray[0].equals("local-part")) {
                n = 2;
                string = stringArray[0];
            } else if (stringArray[0].equals("domain")) {
                n = 3;
                string = stringArray[0];
            } else if (stringArray[0].equals("mailbox")) {
                n = 4;
                string = stringArray[0];
            }
        }
        if (n == -1) {
            System.out.println("Usage:  com.internationalnetwork.util.ElectronicMailAddress [mode]");
            System.out.println("<Modes>");
            System.out.println("  cfws           (Interactive testing of the CFWS rule)");
            System.out.println("  display-name   (Interactive testing of the display-name rule)");
            System.out.println("  local-part     (Interactive testing of the local-part rule)");
            System.out.println("  domain         (Interactive testing of the domain rule)");
            System.out.println("  mailbox        (Interactive testing of the mailbox rule)");
            System.exit(1);
        }
        ElectronicMailAddress electronicMailAddress = null;
        if (n < 4) {
            electronicMailAddress = new ElectronicMailAddress();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string2 = null;
        System.out.print("Enter " + string + ": ");
        block11: while (true) {
            if (string2 != null) {
                System.out.print("\nEnter another " + string + ": ");
            }
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
            if (string2 == null || string2.length() == 0) break;
            try {
                int n2 = 0;
                switch (n) {
                    case 0: {
                        n2 = electronicMailAddress.checkCFWS(string2);
                        break;
                    }
                    case 1: {
                        n2 = electronicMailAddress.checkDN(string2);
                        break;
                    }
                    case 2: {
                        n2 = electronicMailAddress.checkLP(string2);
                        break;
                    }
                    case 3: {
                        n2 = electronicMailAddress.checkIDN(string2);
                        break;
                    }
                    case 4: {
                        electronicMailAddress = new ElectronicMailAddress(string2);
                        System.out.println("Group construct: " + electronicMailAddress.getGN());
                        System.out.println("          Flags: " + StringParser.minimumLeadingDigits(StringParser.parseInt(Integer.toBinaryString(electronicMailAddress.getGNFlags()), 0, new String[0]), 32));
                        System.out.println("   Display-name: " + electronicMailAddress.getDN());
                        System.out.println("          Flags: " + StringParser.minimumLeadingDigits(StringParser.parseInt(Integer.toBinaryString(electronicMailAddress.getDNFlags()), 0, new String[0]), 32));
                        System.out.println("     Local-part: " + electronicMailAddress.getLP());
                        System.out.println("          Flags: " + StringParser.minimumLeadingDigits(StringParser.parseInt(Integer.toBinaryString(electronicMailAddress.getLPFlags()), 0, new String[0]), 32));
                        System.out.println("         Domain: " + electronicMailAddress.getIDN());
                        System.out.println("          Flags: " + StringParser.minimumLeadingDigits(StringParser.parseInt(Integer.toBinaryString(electronicMailAddress.getIDNFlags()), 0, new String[0]), 32));
                        System.out.println("Additional data: " + electronicMailAddress.getAdditionalData());
                        continue block11;
                    }
                }
                System.out.println(" Flags: " + StringParser.minimumLeadingDigits(StringParser.parseInt(Integer.toBinaryString(n2), 0, new String[0]), 32));
            }
            catch (ParseException parseException) {
                System.out.println(" Error: " + parseException.getMessage());
                System.out.println("Offset: " + parseException.getErrorOffset());
                System.out.println("  Text: " + string2);
                System.out.println("        " + StringParser.x(" ", parseException.getErrorOffset()) + "^");
            }
        }
    }
}

