/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.util;

import java.lang.reflect.Array;

public class CircularArray<Type> {
    public static final String VERSION = "1.00";
    Class<Type> type;
    Type[] array;
    int head;
    int tail;
    int size;
    int max;

    private CircularArray() {
    }

    public CircularArray(Class<Type> clazz, int n, Type ... TypeArray) {
        if (n <= 0) {
            if (n < 0) {
                throw new NegativeArraySizeException();
            }
            throw new IllegalArgumentException("Zero is not a positive integer (it's a concept)");
        }
        this.type = clazz;
        this.max = n;
        this.array = (Object[])Array.newInstance(clazz, this.max);
        this.put(TypeArray);
    }

    public CircularArray(Class<Type> clazz, Type ... TypeArray) {
        if (TypeArray.length == 0) {
            throw new IllegalArgumentException("At least one element is required");
        }
        this.type = clazz;
        this.max = TypeArray.length;
        this.array = (Object[])Array.newInstance(clazz, this.max);
        this.put(TypeArray);
    }

    public boolean add(Type ... TypeArray) {
        if (TypeArray.length > this.max - this.size) {
            return false;
        }
        this.size = TypeArray.length;
        for (Type Type2 : TypeArray) {
            this.array[this.head] = Type2;
            if (++this.head != this.max) continue;
            this.head = 0;
        }
        return true;
    }

    public int chomp() {
        int n = this.max;
        if (this.size == 0) {
            this.max = 1;
            this.array = (Object[])Array.newInstance(this.type, this.max);
            this.head = 0;
            this.tail = 0;
        } else {
            this.array = this.toArray();
            this.max = this.array.length;
            this.tail = 0;
            this.head = this.max - 1;
        }
        return n - this.max;
    }

    public Type delete() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Array is empty");
        }
        Type Type2 = this.array[this.tail];
        this.array[this.tail] = null;
        if (++this.tail == this.max) {
            this.tail = 0;
        }
        --this.size;
        return Type2;
    }

    public Type get() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Array is empty");
        }
        return this.array[this.tail];
    }

    public Type get(int n) {
        int n2;
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Array is empty");
        }
        if (n >= this.size || -n > this.size) {
            if (n >= this.max) {
                throw new IndexOutOfBoundsException("" + n);
            }
            throw new IndexOutOfBoundsException(n + " is outside head-to-tail range");
        }
        if (n < 0) {
            n += this.size;
        }
        if ((n2 = this.tail + n) >= this.max) {
            n2 -= this.max;
        }
        return this.array[n2];
    }

    public int head() {
        return this.head;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFragmented() {
        return this.size > 0 && this.head <= this.tail;
    }

    public boolean isFull() {
        return this.size == this.max;
    }

    public boolean isOptimal() {
        return this.tail == 0;
    }

    public int length() {
        return this.max;
    }

    public boolean optimize() {
        if (this.tail == 0) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            Type Type2 = this.array[i];
            this.array[i] = this.array[this.tail];
            this.array[this.tail] = Type2;
            if (++this.tail != this.max) continue;
            --this.tail;
        }
        this.head = this.size;
        this.tail = 0;
        return true;
    }

    public Type[] put(Type ... TypeArray) {
        int n = 0;
        Object[] objectArray = (Object[])Array.newInstance(this.type, TypeArray.length > this.max - this.size ? TypeArray.length - (this.max - this.size) : 0);
        for (Type Type2 : TypeArray) {
            if (this.size == this.max) {
                objectArray[n++] = this.array[this.tail];
                if (++this.tail == this.max) {
                    this.tail = 0;
                }
            } else {
                ++this.size;
            }
            this.array[this.head] = Type2;
            if (++this.head != this.max) continue;
            this.head = 0;
        }
        return objectArray;
    }

    public Type[] resize(int n) {
        Object[] objectArray;
        Object[] objectArray2 = (Object[])Array.newInstance(this.type, n);
        int n2 = this.tail;
        if (n < this.size) {
            int n3;
            objectArray = (Object[])Array.newInstance(this.type, this.size - n);
            for (n3 = 0; n3 < this.size - n; ++n3) {
                objectArray[n3] = this.array[n2];
                if (++n2 != this.max) continue;
                n2 = 0;
            }
            for (n3 = 0; n3 < n; ++n3) {
                objectArray2[n3] = this.array[n2];
                if (++n2 != this.max) continue;
                n2 = 0;
            }
            this.size = n;
        } else {
            objectArray = (Object[])Array.newInstance(this.type, 0);
            for (int i = 0; i < this.size; ++i) {
                objectArray2[i] = this.array[n2];
                if (++n2 != this.max) continue;
                n2 = 0;
            }
        }
        this.array = objectArray2;
        this.head = this.size;
        this.tail = 0;
        return objectArray;
    }

    public int size() {
        return this.size;
    }

    public int tail() {
        return this.tail;
    }

    public Type[] toArray() {
        Object[] objectArray = (Object[])Array.newInstance(this.type, this.size);
        int n = this.tail;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = this.array[n];
            if (++n != this.max) continue;
            n = 0;
        }
        return objectArray;
    }
}

