/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;

public class ArrayTools {
    public static final String VERSION = "1.08";
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ArrayTools() {
    }

    public static boolean contains(boolean[] blArray, boolean bl) {
        for (boolean bl2 : blArray) {
            if (bl != bl2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(byte[] byArray, byte by) {
        for (byte by2 : byArray) {
            if (by != by2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] cArray, char c) {
        for (char c2 : cArray) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(double[] dArray, double d) {
        for (double d2 : dArray) {
            if (d != d2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(float[] fArray, float f) {
        for (float f2 : fArray) {
            if (f != f2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] lArray, long l) {
        for (long l2 : lArray) {
            if (l != l2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(short[] sArray, short s) {
        for (short s2 : sArray) {
            if (s != s2) continue;
            return true;
        }
        return false;
    }

    public static <Type> boolean contains(Type[] TypeArray, Type Type2) {
        for (Type Type3 : TypeArray) {
            if (!Type2.equals(Type3)) continue;
            return true;
        }
        return false;
    }

    public static <Type> HashMap<Type, Type> createHashMap(Type ... TypeArray) {
        if ((TypeArray.length & 1) != 0) {
            throw new UnsupportedOperationException("Odd number of elements encountered");
        }
        HashMap<Type, Type> hashMap = new HashMap<Type, Type>(TypeArray.length / 2);
        for (int i = 0; i < TypeArray.length; ++i) {
            hashMap.put(TypeArray[i], TypeArray[++i]);
        }
        return hashMap;
    }

    public static String hex(boolean[] blArray) {
        StringBuilder stringBuilder = new StringBuilder(blArray.length / 4 + 1);
        int n = 0;
        int n2 = 4 - (blArray.length & 3) & 3;
        for (boolean bl : blArray) {
            n = (byte)(n << 1);
            if (bl) {
                n = (byte)(n + 1);
            }
            if (++n2 <= 3) continue;
            stringBuilder.append(hexDigits[n]);
            n2 = 0;
            n = 0;
        }
        if (n2 != 0) {
            stringBuilder.append(hexDigits[n]);
        }
        return stringBuilder.toString();
    }

    public static String hex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length + byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(hexDigits[by >>> 4 & 0xF]);
            stringBuilder.append(hexDigits[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String hex(char[] cArray) {
        StringBuilder stringBuilder = new StringBuilder(cArray.length * 4);
        for (char c : cArray) {
            stringBuilder.append(hexDigits[c >>> 12 & 0xF]);
            stringBuilder.append(hexDigits[c >>> 8 & 0xF]);
            stringBuilder.append(hexDigits[c >>> 4 & 0xF]);
            stringBuilder.append(hexDigits[c & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String hex(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder(dArray.length * 16);
        for (double d : dArray) {
            stringBuilder.append(hexDigits[(int)((long)d >>> 60) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 56) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 52) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 48) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 44) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 40) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 36) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 32) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 28) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 24) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 20) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 16) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 12) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 8) & 0xF]);
            stringBuilder.append(hexDigits[(int)((long)d >>> 4) & 0xF]);
            stringBuilder.append(hexDigits[(int)d & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String hex(float[] fArray) {
        StringBuilder stringBuilder = new StringBuilder(fArray.length * 8);
        for (float f : fArray) {
            stringBuilder.append(hexDigits[(int)f >>> 28 & 0xF]);
            stringBuilder.append(hexDigits[(int)f >>> 24 & 0xF]);
            stringBuilder.append(hexDigits[(int)f >>> 20 & 0xF]);
            stringBuilder.append(hexDigits[(int)f >>> 16 & 0xF]);
            stringBuilder.append(hexDigits[(int)f >>> 12 & 0xF]);
            stringBuilder.append(hexDigits[(int)f >>> 8 & 0xF]);
            stringBuilder.append(hexDigits[(int)f >>> 4 & 0xF]);
            stringBuilder.append(hexDigits[(int)f & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String hex(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 8);
        for (int n : nArray) {
            stringBuilder.append(hexDigits[n >>> 28 & 0xF]);
            stringBuilder.append(hexDigits[n >>> 24 & 0xF]);
            stringBuilder.append(hexDigits[n >>> 20 & 0xF]);
            stringBuilder.append(hexDigits[n >>> 16 & 0xF]);
            stringBuilder.append(hexDigits[n >>> 12 & 0xF]);
            stringBuilder.append(hexDigits[n >>> 8 & 0xF]);
            stringBuilder.append(hexDigits[n >>> 4 & 0xF]);
            stringBuilder.append(hexDigits[n & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String hex(long[] lArray) {
        StringBuilder stringBuilder = new StringBuilder(lArray.length * 16);
        for (long l : lArray) {
            stringBuilder.append(hexDigits[(int)(l >>> 60) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 56) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 52) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 48) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 44) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 40) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 36) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 32) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 28) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 24) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 20) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 16) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 12) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 8) & 0xF]);
            stringBuilder.append(hexDigits[(int)(l >>> 4) & 0xF]);
            stringBuilder.append(hexDigits[(int)l & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String hex(short[] sArray) {
        StringBuilder stringBuilder = new StringBuilder(sArray.length * 4);
        for (short s : sArray) {
            stringBuilder.append(hexDigits[s >>> 12 & 0xF]);
            stringBuilder.append(hexDigits[s >>> 8 & 0xF]);
            stringBuilder.append(hexDigits[s >>> 4 & 0xF]);
            stringBuilder.append(hexDigits[s & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static <Type> String hex(Type[] TypeArray) {
        StringBuilder stringBuilder = new StringBuilder(TypeArray.length * 4);
        for (Type Type2 : TypeArray) {
            for (byte by : Type2.toString().getBytes()) {
                stringBuilder.append(hexDigits[by >>> 4 & 0xF]);
                stringBuilder.append(hexDigits[by & 0xF]);
            }
        }
        return stringBuilder.toString();
    }

    public static int index(boolean[] blArray, boolean bl) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            if (bl != blArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int index(byte[] byArray, byte by) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (by != byArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int index(char[] cArray, char c) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int index(double[] dArray, double d) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (d != dArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int index(float[] fArray, float f) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            if (f != fArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int index(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (n != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int index(long[] lArray, long l) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            if (l != lArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int index(short[] sArray, short s) {
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            if (s != sArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static <Type> int index(Type[] TypeArray, Type Type2) {
        int n = TypeArray.length;
        for (int i = 0; i < n; ++i) {
            if (!Type2.equals(TypeArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean[] join(boolean[] ... blArray) {
        int n = 0;
        for (boolean[] i : blArray) {
            n += i.length;
        }
        boolean[] blArray2 = new boolean[n];
        n = 0;
        boolean[][] blArray3 = blArray;
        int n2 = blArray3.length;
        for (int i = 0; i < n2; ++i) {
            boolean[] blArray4;
            for (boolean bl : blArray4 = blArray3[i]) {
                blArray2[n++] = bl;
            }
        }
        return blArray2;
    }

    public static byte[] join(byte[] ... byArray) {
        int n = 0;
        for (byte[] i : byArray) {
            n += i.length;
        }
        byte[] byArray2 = new byte[n];
        n = 0;
        byte[][] byArray3 = byArray;
        int n2 = byArray3.length;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray4;
            for (byte by : byArray4 = byArray3[i]) {
                byArray2[n++] = by;
            }
        }
        return byArray2;
    }

    public static char[] join(char[] ... cArray) {
        int n = 0;
        for (char[] i : cArray) {
            n += i.length;
        }
        char[] cArray2 = new char[n];
        n = 0;
        char[][] cArray3 = cArray;
        int n2 = cArray3.length;
        for (int i = 0; i < n2; ++i) {
            char[] cArray4;
            for (char c : cArray4 = cArray3[i]) {
                cArray2[n++] = c;
            }
        }
        return cArray2;
    }

    public static double[] join(double[] ... dArray) {
        int n = 0;
        for (double[] i : dArray) {
            n += i.length;
        }
        double[] dArray2 = new double[n];
        n = 0;
        double[][] dArray3 = dArray;
        int n2 = dArray3.length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray4;
            for (double d : dArray4 = dArray3[i]) {
                dArray2[n++] = d;
            }
        }
        return dArray2;
    }

    public static float[] join(float[] ... fArray) {
        int n = 0;
        for (float[] i : fArray) {
            n += i.length;
        }
        float[] fArray2 = new float[n];
        n = 0;
        float[][] fArray3 = fArray;
        int n2 = fArray3.length;
        for (int i = 0; i < n2; ++i) {
            float[] fArray4;
            for (float f : fArray4 = fArray3[i]) {
                fArray2[n++] = f;
            }
        }
        return fArray2;
    }

    public static int[] join(int[] ... nArray) {
        int n = 0;
        for (int[] i : nArray) {
            n += i.length;
        }
        int[] nArray2 = new int[n];
        n = 0;
        int[][] nArray3 = nArray;
        int n2 = nArray3.length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray4;
            for (int n3 : nArray4 = nArray3[i]) {
                nArray2[n++] = n3;
            }
        }
        return nArray2;
    }

    public static long[] join(long[] ... lArray) {
        int n = 0;
        for (long[] i : lArray) {
            n += i.length;
        }
        long[] lArray2 = new long[n];
        n = 0;
        long[][] lArray3 = lArray;
        int n2 = lArray3.length;
        for (int i = 0; i < n2; ++i) {
            long[] lArray4;
            for (long l : lArray4 = lArray3[i]) {
                lArray2[n++] = l;
            }
        }
        return lArray2;
    }

    public static short[] join(short[] ... sArray) {
        int n = 0;
        for (short[] i : sArray) {
            n += i.length;
        }
        short[] sArray2 = new short[n];
        n = 0;
        short[][] sArray3 = sArray;
        int n2 = sArray3.length;
        for (int i = 0; i < n2; ++i) {
            short[] sArray4;
            for (short s : sArray4 = sArray3[i]) {
                sArray2[n++] = s;
            }
        }
        return sArray2;
    }

    public static <Type> Type[] join(Type[] ... TypeArray) {
        int n = 0;
        for (Type[] TypeArray2 : TypeArray) {
            if (TypeArray2 == null) continue;
            n += TypeArray2.length;
        }
        ArrayList arrayList = new ArrayList(n);
        for (Type[] TypeArray3 : TypeArray) {
            if (TypeArray3 == null) continue;
            for (Type Type2 : TypeArray3) {
                arrayList.add(Type2);
            }
        }
        return TypeArray.length > 0 ? arrayList.toArray(TypeArray[0]) : null;
    }

    public static boolean max(boolean[] blArray) {
        boolean bl = blArray[0];
        for (boolean bl2 : blArray) {
            if (!bl2) continue;
            return true;
        }
        return bl;
    }

    public static byte max(byte[] byArray) {
        byte by = byArray[0];
        for (byte by2 : byArray) {
            if (by2 <= by) continue;
            by = by2;
        }
        return by;
    }

    public static char max(char[] cArray) {
        char c = cArray[0];
        for (char c2 : cArray) {
            if (c2 <= c) continue;
            c = c2;
        }
        return c;
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        for (double d2 : dArray) {
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static float max(float[] fArray) {
        float f = fArray[0];
        for (float f2 : fArray) {
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public static int max(int[] nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static long max(long[] lArray) {
        long l = lArray[0];
        for (long l2 : lArray) {
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public static short max(short[] sArray) {
        short s = sArray[0];
        for (short s2 : sArray) {
            if (s2 <= s) continue;
            s = s2;
        }
        return s;
    }

    public static <Type> Type max(Type[] TypeArray) {
        Type Type2 = TypeArray[0];
        for (Type Type3 : TypeArray) {
            if (Type3.hashCode() <= Type2.hashCode()) continue;
            Type2 = Type3;
        }
        return Type2;
    }

    public static boolean min(boolean[] blArray) {
        boolean bl = blArray[0];
        for (boolean bl2 : blArray) {
            if (bl2) continue;
            return false;
        }
        return bl;
    }

    public static byte min(byte[] byArray) {
        byte by = byArray[0];
        for (byte by2 : byArray) {
            if (by2 >= by) continue;
            by = by2;
        }
        return by;
    }

    public static char min(char[] cArray) {
        char c = cArray[0];
        for (char c2 : cArray) {
            if (c2 >= c) continue;
            c = c2;
        }
        return c;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        for (double d2 : dArray) {
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static float min(float[] fArray) {
        float f = fArray[0];
        for (float f2 : fArray) {
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public static int min(int[] nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static long min(long[] lArray) {
        long l = lArray[0];
        for (long l2 : lArray) {
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    public static <Type> Type min(Type[] TypeArray) {
        Type Type2 = TypeArray[0];
        for (Type Type3 : TypeArray) {
            if (Type3.hashCode() >= Type2.hashCode()) continue;
            Type2 = Type3;
        }
        return Type2;
    }

    public static boolean[] removeNULLs(Boolean[] booleanArray) {
        int n = booleanArray.length;
        for (Boolean bl : booleanArray) {
            if (bl != null) continue;
            --n;
        }
        boolean[] blArray = new boolean[n];
        n = 0;
        for (Boolean bl : booleanArray) {
            if (bl == null) continue;
            blArray[n++] = bl;
        }
        return blArray;
    }

    public static byte[] removeNULLs(Byte[] byteArray) {
        int n = byteArray.length;
        for (Byte by : byteArray) {
            if (by != null) continue;
            --n;
        }
        byte[] byArray = new byte[n];
        n = 0;
        for (Byte by : byteArray) {
            if (by == null) continue;
            byArray[n++] = by;
        }
        return byArray;
    }

    public static char[] removeNULLs(Character[] characterArray) {
        int n = characterArray.length;
        for (Character c : characterArray) {
            if (c != null) continue;
            --n;
        }
        char[] cArray = new char[n];
        n = 0;
        for (Character c : characterArray) {
            if (c == null) continue;
            cArray[n++] = c.charValue();
        }
        return cArray;
    }

    public static double[] removeNULLs(Double[] doubleArray) {
        int n = doubleArray.length;
        for (Double d : doubleArray) {
            if (d != null) continue;
            --n;
        }
        double[] dArray = new double[n];
        n = 0;
        for (Double d : doubleArray) {
            if (d == null) continue;
            dArray[n++] = d;
        }
        return dArray;
    }

    public static float[] removeNULLs(Float[] floatArray) {
        int n = floatArray.length;
        for (Float f : floatArray) {
            if (f != null) continue;
            --n;
        }
        float[] fArray = new float[n];
        n = 0;
        for (Float f : floatArray) {
            if (f == null) continue;
            fArray[n++] = f.floatValue();
        }
        return fArray;
    }

    public static int[] removeNULLs(Integer[] integerArray) {
        int n = integerArray.length;
        for (Integer n2 : integerArray) {
            if (n2 != null) continue;
            --n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (Integer n3 : integerArray) {
            if (n3 == null) continue;
            nArray[n++] = n3;
        }
        return nArray;
    }

    public static long[] removeNULLs(Long[] longArray) {
        int n = longArray.length;
        for (Long l : longArray) {
            if (l != null) continue;
            --n;
        }
        long[] lArray = new long[n];
        n = 0;
        for (Long l : longArray) {
            if (l == null) continue;
            lArray[n++] = l;
        }
        return lArray;
    }

    public static short[] removeNULLs(Short[] shortArray) {
        int n = shortArray.length;
        for (Short s : shortArray) {
            if (s != null) continue;
            --n;
        }
        short[] sArray = new short[n];
        n = 0;
        for (Short s : shortArray) {
            if (s == null) continue;
            sArray[n++] = s;
        }
        return sArray;
    }

    public static <Type> Type[] removeNULLs(Type[] TypeArray) {
        int n = TypeArray.length;
        for (Type Type2 : TypeArray) {
            if (Type2 != null) continue;
            --n;
        }
        Object[] objectArray = (Object[])Array.newInstance(TypeArray.getClass().getComponentType(), n);
        n = 0;
        for (Type Type3 : TypeArray) {
            if (Type3 == null) continue;
            objectArray[n++] = Type3;
        }
        return objectArray;
    }

    public static boolean[] resize(boolean[] blArray, int n) {
        int n2;
        boolean[] blArray2 = new boolean[n];
        int n3 = n2 = n < blArray.length ? n : blArray.length;
        while (n2 > 0) {
            blArray2[--n2] = blArray[n2];
        }
        return blArray2;
    }

    public static byte[] resize(byte[] byArray, int n) {
        int n2;
        byte[] byArray2 = new byte[n];
        int n3 = n2 = n < byArray.length ? n : byArray.length;
        while (n2 > 0) {
            byArray2[--n2] = byArray[n2];
        }
        return byArray2;
    }

    public static char[] resize(char[] cArray, int n) {
        int n2;
        char[] cArray2 = new char[n];
        int n3 = n2 = n < cArray.length ? n : cArray.length;
        while (n2 > 0) {
            cArray2[--n2] = cArray[n2];
        }
        return cArray2;
    }

    public static double[] resize(double[] dArray, int n) {
        int n2;
        double[] dArray2 = new double[n];
        int n3 = n2 = n < dArray.length ? n : dArray.length;
        while (n2 > 0) {
            dArray2[--n2] = dArray[n2];
        }
        return dArray2;
    }

    public static float[] resize(float[] fArray, int n) {
        int n2;
        float[] fArray2 = new float[n];
        int n3 = n2 = n < fArray.length ? n : fArray.length;
        while (n2 > 0) {
            fArray2[--n2] = fArray[n2];
        }
        return fArray2;
    }

    public static int[] resize(int[] nArray, int n) {
        int n2;
        int[] nArray2 = new int[n];
        int n3 = n2 = n < nArray.length ? n : nArray.length;
        while (n2 > 0) {
            nArray2[--n2] = nArray[n2];
        }
        return nArray2;
    }

    public static long[] resize(long[] lArray, int n) {
        int n2;
        long[] lArray2 = new long[n];
        int n3 = n2 = n < lArray.length ? n : lArray.length;
        while (n2 > 0) {
            lArray2[--n2] = lArray[n2];
        }
        return lArray2;
    }

    public static short[] resize(short[] sArray, int n) {
        int n2;
        short[] sArray2 = new short[n];
        int n3 = n2 = n < sArray.length ? n : sArray.length;
        while (n2 > 0) {
            sArray2[--n2] = sArray[n2];
        }
        return sArray2;
    }

    public static <Type> Type[] resize(Type[] TypeArray, int n) {
        int n2;
        Object[] objectArray = (Object[])Array.newInstance(TypeArray.getClass().getComponentType(), n);
        int n3 = n2 = n < TypeArray.length ? n : TypeArray.length;
        while (n2 > 0) {
            objectArray[--n2] = TypeArray[n2];
        }
        return objectArray;
    }
}

