/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.tui;

import com.internationalnetwork.tui.JScreenCharacter;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JScreenFont {
    public static final String VERSION = "1.00";
    private static final AlphaComposite alphaClear = AlphaComposite.getInstance(1, 0.0f);
    int[][] shapes;
    int width;
    int height;
    int underline;
    int strike;

    private JScreenFont() {
        this.shapes = new int[256][];
    }

    public JScreenFont(String string) throws IOException {
        this(new FileInputStream(string));
    }

    public JScreenFont(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream;
        block6: {
            this.shapes = new int[256][];
            if (inputStream == null) {
                throw new IOException("NULL is an invalid inputStream");
            }
            int n = 0;
            dataInputStream = new DataInputStream(inputStream);
            try {
                while (dataInputStream.readByte() != 26) {
                }
                this.height = dataInputStream.readUnsignedByte();
                this.width = dataInputStream.readUnsignedByte();
                this.underline = dataInputStream.readUnsignedByte();
                this.strike = dataInputStream.readUnsignedByte();
                for (n = 0; n < 256; ++n) {
                    int n2 = dataInputStream.readUnsignedShort();
                    this.shapes[n] = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        this.shapes[n][i] = dataInputStream.readUnsignedByte();
                    }
                }
            }
            catch (EOFException eOFException) {
                if (n >= 256) break block6;
                throw eOFException;
            }
        }
        dataInputStream.close();
    }

    public void display(JScreenCharacter jScreenCharacter, int n, int n2, boolean bl, BufferedImage bufferedImage) {
        int n3;
        Object object;
        int n4 = n * this.width;
        int n5 = n4 + this.width;
        int n6 = n2 * this.height;
        int n7 = n6 + this.height;
        int n8 = jScreenCharacter.foreground;
        if (jScreenCharacter.transparent) {
            object = bufferedImage.createGraphics();
            Composite composite = ((Graphics2D)object).getComposite();
            ((Graphics2D)object).setComposite(alphaClear);
            for (n3 = n6; n3 < n7; ++n3) {
                for (int i = n4; i < n5; ++i) {
                    bufferedImage.setRGB(i, n3, 0);
                }
            }
            ((Graphics2D)object).setComposite(composite);
        } else {
            int n9 = jScreenCharacter.background;
            for (int i = n6; i < n7; ++i) {
                for (n3 = n4; n3 < n5; ++n3) {
                    bufferedImage.setRGB(n3, i, n9);
                }
            }
        }
        if (!jScreenCharacter.blink || !bl) {
            int n10;
            object = jScreenCharacter.shape;
            for (n10 = 0; n10 < ((Object)object).length; ++n10) {
                bufferedImage.setRGB(n4 + object[n10], n6 + object[++n10], n8);
            }
            if (jScreenCharacter.underline) {
                for (n10 = 0; n10 < this.width; ++n10) {
                    bufferedImage.setRGB(n4 + n10, n6 + this.underline, n8);
                }
            }
            if (jScreenCharacter.strike) {
                for (n10 = 0; n10 < this.width; ++n10) {
                    bufferedImage.setRGB(n4 + n10, n6 + this.strike, n8);
                }
            }
        }
    }
}

