/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.tui;

import com.internationalnetwork.tui.JScreen;
import com.internationalnetwork.tui.JScreenFont;
import com.internationalnetwork.util.ArrayTools;

public class JScreenCharacter {
    public static final String VERSION = "1.00";
    int character;
    int background;
    int foreground;
    boolean blink;
    boolean transparent;
    boolean underline;
    boolean strike;
    int[] shape;

    public JScreenCharacter clone() {
        JScreenCharacter jScreenCharacter = new JScreenCharacter(this.character);
        jScreenCharacter.background = this.background;
        jScreenCharacter.foreground = this.foreground;
        jScreenCharacter.blink = this.blink;
        jScreenCharacter.transparent = this.transparent;
        jScreenCharacter.underline = this.underline;
        jScreenCharacter.strike = this.strike;
        jScreenCharacter.shape = (int[])this.shape.clone();
        return jScreenCharacter;
    }

    private JScreenCharacter(int n) {
        this.character = n;
    }

    public JScreenCharacter(String string, JScreenFont jScreenFont, int ... nArray) {
        this.character = string.substring(0, 1).getBytes()[0];
        this.shape = jScreenFont.shapes[this.character];
        this.set(nArray);
    }

    public JScreenCharacter(char c, JScreenFont jScreenFont, int ... nArray) {
        this.character = String.valueOf(c).getBytes()[0];
        this.shape = jScreenFont.shapes[this.character];
        this.set(nArray);
    }

    public JScreenCharacter(byte by, JScreenFont jScreenFont, int ... nArray) {
        this.character = by;
        this.shape = jScreenFont.shapes[this.character];
        this.set(nArray);
    }

    public JScreenCharacter(byte[] byArray, JScreenFont jScreenFont, int ... nArray) {
        this.character = byArray[0];
        this.shape = jScreenFont.shapes[this.character];
        this.set(nArray);
    }

    public JScreenCharacter(short s, JScreenFont jScreenFont, int ... nArray) {
        this.character = s;
        this.shape = jScreenFont.shapes[this.character];
        this.set(nArray);
    }

    public JScreenCharacter(int n, JScreenFont jScreenFont, int ... nArray) {
        this.character = n;
        this.shape = jScreenFont.shapes[this.character];
        this.set(nArray);
    }

    public int getASCII() {
        return this.character;
    }

    public byte getASCIIByte() {
        return (byte)this.character;
    }

    public byte get() {
        return (byte)this.character;
    }

    public JScreenCharacter set(int ... nArray) {
        block14: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case -30: {
                    int n = nArray[++i];
                    if (n < 16) {
                        this.foreground = JScreen.colour[n];
                        continue block14;
                    }
                    if (!ArrayTools.contains(JScreen.colour, n)) {
                        throw new IllegalArgumentException("JCharacter foreground colour not recognized");
                    }
                    this.foreground = n;
                    continue block14;
                }
                case -32: {
                    this.foreground = nArray[++i];
                    continue block14;
                }
                case -35: {
                    int n = nArray[++i];
                    if (n < 16) {
                        this.background = JScreen.colour[n];
                        continue block14;
                    }
                    if (!ArrayTools.contains(JScreen.colour, n)) {
                        throw new IllegalArgumentException("JCharacter background colour not recognized");
                    }
                    this.background = n;
                    continue block14;
                }
                case -37: {
                    this.background = nArray[++i];
                    continue block14;
                }
                case -40: {
                    this.blink = true;
                    continue block14;
                }
                case -41: {
                    this.blink = false;
                    continue block14;
                }
                case -42: {
                    this.underline = true;
                    continue block14;
                }
                case -43: {
                    this.underline = false;
                    continue block14;
                }
                case -44: {
                    this.transparent = true;
                    continue block14;
                }
                case -45: {
                    this.transparent = false;
                    continue block14;
                }
                case -46: {
                    this.blink = true;
                    continue block14;
                }
                case -47: {
                    this.blink = false;
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException("JCharacter parameter not recognized");
                }
            }
        }
        return this;
    }
}

