/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.tui;

import com.internationalnetwork.tui.JScreenCharacter;
import com.internationalnetwork.tui.JScreenFont;
import com.internationalnetwork.tui.JScreenTransaction;
import com.internationalnetwork.util.ArrayTools;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.Timer;

public class JScreen
extends JComponent
implements ActionListener,
Runnable {
    public static final String VERSION = "1.00";
    public static final int END = -1;
    public static final int DOWN = -2;
    public static final int BOTTOM = -3;
    public static final int LEFT = -4;
    public static final int CENTRE = -5;
    public static final int RIGHT = -6;
    public static final int HOME = -7;
    public static final int UP = -8;
    public static final int TOP = -9;
    public static final int X = -20;
    public static final int COL = -20;
    public static final int COLUMN = -20;
    public static final int Y = -21;
    public static final int ROW = -21;
    public static final int XY = -22;
    public static final int YX = -23;
    public static final int CURSORFLASH_ON = -24;
    public static final int CURSORFLASH_OFF = -25;
    public static final int CURSORSTATE_ON = -26;
    public static final int CURSORSTATE_OFF = -27;
    public static final int CURSORSTYLE_BLOCK = -28;
    public static final int CURSORSTYLE_LINE = -29;
    public static final int FOREGROUND = -30;
    public static final int RGB_FOREGROUND = -31;
    public static final int RGBA_FOREGROUND = -32;
    public static final int BACKGROUND = -35;
    public static final int RGB_BACKGROUND = -36;
    public static final int RGBA_BACKGROUND = -37;
    public static final int BLINK_ON = -40;
    public static final int BLINK_OFF = -41;
    public static final int UNDERLINE_ON = -42;
    public static final int UNDERLINE_OFF = -43;
    public static final int TRANSPARENT_ON = -44;
    public static final int TRANSPARENT_OFF = -45;
    public static final int STRIKE_ON = -46;
    public static final int STRIKE_OFF = -47;
    public static final int CLEAR = -60;
    public static final int NEWLINE = -61;
    private static final int PRINT_CHAR = -62;
    private static final int PRINT = -63;
    private static final int PRINT_RAW = -64;
    private static final int PRINTLN = -65;
    private static final int PRINTLN_RAW = -66;
    public static final int PUSH = -80;
    public static final int PUSH_ATTR = -81;
    public static final int POP = -82;
    public static final int NO_REPAINT = -90;
    private static final int WAITPOINT = -91;
    public static final int TRANSACTION = -100;
    public static final int BLACK = -16777216;
    public static final int BLUE = -16777046;
    public static final int GREEN = -16733696;
    public static final int CYAN = -16733526;
    public static final int RED = -5636096;
    public static final int PURPLE = -5635926;
    public static final int BROWN = -5614336;
    public static final int BRIGHT_GREY = -5592406;
    public static final int BRIGHT_GRAY = -5592406;
    public static final int GREY = -11184811;
    public static final int GRAY = -11184811;
    public static final int DARK_GREY = -11184811;
    public static final int DARK_GRAY = -11184811;
    public static final int BRIGHT_BLUE = -11184641;
    public static final int LIME = -11141291;
    public static final int BRIGHT_GREEN = -11141291;
    public static final int BRIGHT_CYAN = -11141121;
    public static final int BRIGHT_RED = -43691;
    public static final int PINK = -43521;
    public static final int YELLOW = -171;
    public static final int WHITE = -1;
    static final int[] colour = new int[]{-16777216, -16777046, -16733696, -16733526, -5636096, -5635926, -5614336, -5592406, -11184811, -11184641, -11141291, -11141121, -43691, -43521, -171, -1};
    private JScreenFont font;
    private int x = 0;
    private int y = 0;
    private int cols;
    private int rows;
    private int width;
    private int height;
    private Dimension screenSize;
    private String screenName;
    private JScreenCharacter[][] screenData;
    private boolean screenDataDirty = true;
    private BufferedImage bi;
    private boolean blink = false;
    private boolean transparent = false;
    private boolean underline = false;
    private boolean strike = false;
    private boolean cursorFlash = true;
    private int cursorStyle = -29;
    private int cursorTop = 13;
    private int cursorHeight = 2;
    private int background = colour[0];
    private int foreground = colour[7];
    private int blinkState = 0;
    private int blinkStateFulcrum = 7;
    private int blinkStateMax = this.blinkStateFulcrum + this.blinkStateFulcrum;
    private boolean cursorFlashDirty = true;
    private int cursorFlashState = 0;
    private int cursorFlashFulcrum = 2;
    private int cursorFlashMax = this.cursorFlashFulcrum + this.cursorFlashFulcrum;
    private ArrayDeque<int[]> stack = new ArrayDeque(0);
    private LinkedBlockingQueue<int[]> queueCmds = new LinkedBlockingQueue();
    private ConcurrentHashMap<Integer, JScreenTransaction> transactions = new ConcurrentHashMap();
    private AtomicInteger transactionID = new AtomicInteger();
    private ConcurrentHashMap<Integer, CountDownLatch> waitPoints = new ConcurrentHashMap();
    private AtomicInteger waitPointID = new AtomicInteger();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ++this.blinkState;
        this.blinkState %= this.blinkStateMax;
        if (this.blinkState == 0 || this.blinkState == this.blinkStateFulcrum) {
            this.screenDataDirty = true;
            this.repaint();
        }
        if (this.cursorFlash) {
            ++this.cursorFlashState;
            this.cursorFlashState %= this.cursorFlashMax;
            if (this.cursorFlashState == 0 || this.cursorFlashState == this.cursorFlashFulcrum) {
                this.cursorFlashDirty = true;
                this.repaint();
            }
        }
    }

    public JScreen(int ... nArray) {
        this(null, nArray);
    }

    public JScreen(String string, int ... nArray) {
        this(25, 80, string, nArray);
    }

    public JScreen(int n, int n2, String string, int ... nArray) {
        this.screenName = string == null || string.equals("") ? "JScreen_" + System.currentTimeMillis() : string;
        if (n < 3) {
            throw new IllegalArgumentException("JScreen \"" + this.screenName + "\" rows are out of range");
        }
        if (n2 < 3) {
            throw new IllegalArgumentException("JScreen \"" + this.screenName + "\" columns are out of range");
        }
        try {
            this.font = new JScreenFont(this.getClass().getResourceAsStream("fonts/cp437.font"));
        }
        catch (IOException iOException) {
            throw new UnsupportedOperationException("JScreen \"" + this.screenName + "\" failed to load font; " + iOException);
        }
        this.cols = n2;
        this.rows = n;
        this.width = n2 * this.font.width;
        this.height = n * this.font.height;
        this.screenSize = new Dimension(this.width, this.height);
        this.screenData = new JScreenCharacter[n][n2];
        this.bi = new BufferedImage(this.width, this.height, 2);
        this._clear();
        this.cursorStyle = -29;
        this.cursorTop = this.font.underline;
        this.cursorHeight = 2;
        new Timer(64, this).start();
        new Thread((Runnable)this, this.screenName + " command queue manager").start();
        this.cmd(nArray);
    }

    int[] _cmd(int ... nArray) {
        block6: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case -90: 
                case -82: 
                case -81: 
                case -80: 
                case -61: 
                case -47: 
                case -46: 
                case -45: 
                case -44: 
                case -43: 
                case -42: 
                case -41: 
                case -40: 
                case -29: 
                case -28: 
                case -27: 
                case -26: 
                case -25: 
                case -24: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    continue block6;
                }
                case -23: 
                case -22: {
                    ++i;
                }
                case -91: 
                case -37: 
                case -36: 
                case -32: 
                case -31: 
                case -21: 
                case -20: {
                    ++i;
                    continue block6;
                }
                case -35: 
                case -30: {
                    int n = nArray[++i];
                    if (n >= 0 && n < 16) {
                        nArray[i] = colour[n];
                        continue block6;
                    }
                    if (ArrayTools.contains(colour, n)) continue block6;
                    throw new IllegalArgumentException("JScreen \"" + this.screenName + "\" colour (" + n + ") not recognized");
                }
                default: {
                    throw new IllegalArgumentException("JScreen \"" + this.screenName + "\" parameter not recognized (" + nArray[i] + ")");
                }
            }
        }
        return nArray;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    boolean bl = true;
                    int[] nArray = this.queueCmds.take();
                    block49: for (int i = 0; i < nArray.length; ++i) {
                        switch (nArray[i]) {
                            case -20: {
                                this.x = nArray[++i];
                                if (this.x < 0) {
                                    this.x = 0;
                                    continue block49;
                                }
                                if (this.x <= this.cols) continue block49;
                                this.x = this.cols - 1;
                                continue block49;
                            }
                            case -21: {
                                this.y = nArray[++i];
                                if (this.y < 0) {
                                    this.y = 0;
                                    continue block49;
                                }
                                if (this.y <= this.rows) continue block49;
                                this.y = this.rows - 1;
                                continue block49;
                            }
                            case -22: {
                                this.x = nArray[++i];
                                if (this.x < 0) {
                                    this.x = 0;
                                } else if (this.x > this.cols) {
                                    this.x = this.cols - 1;
                                }
                                this.y = nArray[++i];
                                if (this.y < 0) {
                                    this.y = 0;
                                    continue block49;
                                }
                                if (this.y <= this.rows) continue block49;
                                this.y = this.rows - 1;
                                continue block49;
                            }
                            case -23: {
                                this.y = nArray[++i];
                                if (this.y < 0) {
                                    this.y = 0;
                                } else if (this.y > this.rows) {
                                    this.y = this.rows - 1;
                                }
                                this.x = nArray[++i];
                                if (this.x < 0) {
                                    this.x = 0;
                                    continue block49;
                                }
                                if (this.x <= this.cols) continue block49;
                                this.x = this.cols - 1;
                                continue block49;
                            }
                            case -24: {
                                this.cursorFlash = true;
                                this.cursorFlashDirty = true;
                                bl = true;
                                continue block49;
                            }
                            case -25: {
                                this.cursorFlash = false;
                                this.cursorFlashDirty = true;
                                bl = true;
                                continue block49;
                            }
                            case -26: {
                                this.cursorFlashState = 0;
                                this.cursorFlashDirty = true;
                                bl = true;
                                continue block49;
                            }
                            case -27: {
                                this.cursorFlashState = this.cursorFlashFulcrum;
                                this.cursorFlashDirty = true;
                                bl = true;
                                continue block49;
                            }
                            case -28: {
                                this.cursorTop = 0;
                                this.cursorHeight = this.font.height;
                                this.cursorFlashDirty = true;
                                bl = true;
                                continue block49;
                            }
                            case -29: {
                                this.cursorTop = this.font.underline;
                                this.cursorHeight = 2;
                                this.cursorFlashDirty = true;
                                bl = true;
                                continue block49;
                            }
                            case -30: {
                                int n = nArray[++i];
                                if (n >= 0 && n < 16) {
                                    this.foreground = colour[n];
                                    continue block49;
                                }
                                this.foreground = n;
                                continue block49;
                            }
                            case -31: {
                                this.foreground = nArray[++i] & 0xFF000000;
                                continue block49;
                            }
                            case -32: {
                                this.foreground = nArray[++i];
                                continue block49;
                            }
                            case -35: {
                                int n = nArray[++i];
                                if (n >= 0 && n < 16) {
                                    this.background = colour[n];
                                    continue block49;
                                }
                                this.background = n;
                                continue block49;
                            }
                            case -36: {
                                this.background = nArray[++i] & 0xFF000000;
                                continue block49;
                            }
                            case -37: {
                                this.background = nArray[++i];
                                continue block49;
                            }
                            case -40: {
                                this.blink = true;
                                continue block49;
                            }
                            case -41: {
                                this.blink = false;
                                continue block49;
                            }
                            case -42: {
                                this.underline = true;
                                continue block49;
                            }
                            case -43: {
                                this.underline = false;
                                continue block49;
                            }
                            case -44: {
                                this.transparent = true;
                                continue block49;
                            }
                            case -45: {
                                this.transparent = false;
                                continue block49;
                            }
                            case -46: {
                                this.strike = true;
                                continue block49;
                            }
                            case -47: {
                                this.strike = false;
                                continue block49;
                            }
                            case -80: {
                                this.stack.push(new int[]{this.x, this.y, this.cursorFlash ? 1 : 0, this.foreground, this.background, this.blink ? 1 : 0, this.transparent ? 1 : 0, this.underline ? 1 : 0, this.strike ? 1 : 0});
                                continue block49;
                            }
                            case -81: {
                                this.stack.push(new int[]{-1, -1, this.cursorFlash ? 1 : 0, this.foreground, this.background, this.blink ? 1 : 0, this.transparent ? 1 : 0, this.underline ? 1 : 0, this.strike ? 1 : 0});
                                continue block49;
                            }
                            case -82: {
                                int[] nArray2 = this.stack.pop();
                                if (nArray2[0] != -1) {
                                    this.x = nArray2[0];
                                }
                                if (nArray2[1] != -1) {
                                    this.y = nArray2[1];
                                }
                                this.cursorFlash = nArray2[2] == 1;
                                this.foreground = nArray2[3];
                                this.background = nArray2[4];
                                this.blink = nArray2[5] == 1;
                                this.transparent = nArray2[6] == 1;
                                this.underline = nArray2[7] == 1;
                                this.strike = nArray2[8] == 1;
                                continue block49;
                            }
                            case -8: {
                                if (this.y <= 0) continue block49;
                                --this.y;
                                continue block49;
                            }
                            case -2: {
                                if (this.y >= this.rows - 1) continue block49;
                                ++this.y;
                                continue block49;
                            }
                            case -4: {
                                if (this.x <= 0) continue block49;
                                --this.x;
                                continue block49;
                            }
                            case -6: {
                                if (this.x >= this.cols - 1) continue block49;
                                ++this.x;
                                continue block49;
                            }
                            case -7: {
                                this.x = 0;
                                continue block49;
                            }
                            case -1: {
                                this.x = this.cols - 1;
                                continue block49;
                            }
                            case -9: {
                                this.y = 0;
                                continue block49;
                            }
                            case -3: {
                                this.y = this.rows - 1;
                                continue block49;
                            }
                            case -60: {
                                this.x = 0;
                                this.y = 0;
                                this._clear();
                                continue block49;
                            }
                            case -61: {
                                this._newLine();
                                continue block49;
                            }
                            case -62: {
                                this._printChar(nArray[++i]);
                                continue block49;
                            }
                            case -63: {
                                int n = nArray[++i];
                                this._print(Arrays.copyOfRange(nArray, i + 1, i + n + 1));
                                i += n;
                                continue block49;
                            }
                            case -65: {
                                int n = nArray[++i];
                                this._print(Arrays.copyOfRange(nArray, i + 1, i + n + 1));
                                i += n;
                                this._newLine();
                                continue block49;
                            }
                            case -90: {
                                bl = false;
                                continue block49;
                            }
                            case -91: {
                                this.waitPoints.remove(nArray[++i]).countDown();
                                continue block49;
                            }
                            case -100: {
                                int n = nArray[++i];
                                JScreenTransaction jScreenTransaction = this.transactions.get(n);
                                System.out.print("Processing transaction " + n + ":  ");
                                if (jScreenTransaction == null) {
                                    System.out.println("NULL transaction (processing not needed)");
                                    continue block49;
                                }
                                if (jScreenTransaction.ready.get()) {
                                    System.out.println("Ready for processing (and being removed from the queue)");
                                    continue block49;
                                }
                                System.out.println("Not ready for processing (being removed from the queue)");
                                continue block49;
                            }
                            default: {
                                throw new IllegalArgumentException("JScreen \"" + this.screenName + "\" parameter not recognized (" + nArray[i] + ")");
                            }
                        }
                    }
                    if (!bl) continue;
                    this.repaint();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.screenSize;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = bl = this.blinkState < this.blinkStateFulcrum;
        if (this.screenDataDirty) {
            this.screenDataDirty = false;
            for (n2 = 0; n2 < this.rows; ++n2) {
                for (n = 0; n < this.cols; ++n) {
                    this.font.display(this.screenData[n2][n], n, n2, bl, this.bi);
                }
            }
            if (this.cursorFlashState < this.cursorFlashFulcrum) {
                this.cursorFlashDirty = true;
            }
        }
        if (this.cursorFlashDirty) {
            if (this.cursorFlashState < this.cursorFlashFulcrum) {
                n2 = this.screenData[this.y][this.x].foreground;
                n = this.y * this.font.height + this.cursorTop;
                int n3 = n + this.cursorHeight;
                int n4 = this.x * this.font.width;
                int n5 = n4 + this.font.width;
                for (int i = n; i < n3; ++i) {
                    for (int j = n4; j < n5; ++j) {
                        this.bi.setRGB(j, i, n2);
                    }
                }
            } else {
                this.font.display(this.screenData[this.y][this.x], this.x, this.y, bl, this.bi);
            }
            this.cursorFlashDirty = false;
        }
        super.paintComponent(graphics);
        graphics.drawImage(this.bi, 0, 0, this);
    }

    private void _clear() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.screenData[i][j] = new JScreenCharacter(0, this.font, new int[0]);
                this.screenData[i][j].background = this.background;
                this.screenData[i][j].foreground = this.foreground;
                this.screenData[i][j].blink = this.blink;
                this.screenData[i][j].transparent = this.transparent;
                this.screenData[i][j].underline = this.underline;
                this.screenData[i][j].strike = this.strike;
            }
        }
        this.screenDataDirty = true;
    }

    private void _printChar(int n) {
        this.screenData[this.y][this.x].character = n;
        this.screenData[this.y][this.x].background = this.background;
        this.screenData[this.y][this.x].foreground = this.foreground;
        this.screenData[this.y][this.x].blink = this.blink;
        this.screenData[this.y][this.x].transparent = this.transparent;
        this.screenData[this.y][this.x].underline = this.underline;
        this.screenData[this.y][this.x].strike = this.strike;
        this.screenData[this.y][this.x].shape = this.font.shapes[n];
        this.screenDataDirty = true;
        if (this.x < this.cols - 1) {
            ++this.x;
        } else {
            this.x = 0;
            if (this.y < this.rows - 1) {
                ++this.y;
            } else {
                this._scroll(0, this.rows);
            }
        }
    }

    private void _print(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this._printChar(string.substring(n2++, n2).getBytes()[0]);
        }
    }

    private void _print(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            this.screenData[this.y][this.x].character = n2 = nArray2[i];
            this.screenData[this.y][this.x].background = this.background;
            this.screenData[this.y][this.x].foreground = this.foreground;
            this.screenData[this.y][this.x].blink = this.blink;
            this.screenData[this.y][this.x].transparent = this.transparent;
            this.screenData[this.y][this.x].underline = this.underline;
            this.screenData[this.y][this.x].strike = this.strike;
            this.screenData[this.y][this.x].shape = this.font.shapes[n2];
            if (this.x < this.cols - 1) {
                ++this.x;
                continue;
            }
            this.x = 0;
            if (this.y < this.rows - 1) {
                ++this.y;
                continue;
            }
            this._scroll(0, this.rows);
        }
        this.screenDataDirty = true;
    }

    private void _scroll(int n, int n2) {
        if (n < n2) {
            --n2;
            int n3 = n;
            while (n3 < n2) {
                this.screenData[n3++] = (JScreenCharacter[])this.screenData[n3].clone();
            }
        } else {
            int n4 = --n;
            while (n4 > n2) {
                this.screenData[n4--] = (JScreenCharacter[])this.screenData[n4].clone();
            }
        }
        this.screenDataDirty = true;
        this._clearLine(n2);
    }

    private void _clearLine(int n) {
        for (int i = 0; i < this.cols; ++i) {
            this.screenData[n][i] = new JScreenCharacter(0, this.font, new int[0]);
            this.screenData[n][i].background = this.background;
            this.screenData[n][i].foreground = this.foreground;
            this.screenData[n][i].blink = this.blink;
            this.screenData[n][i].transparent = this.transparent;
            this.screenData[n][i].underline = this.underline;
            this.screenData[n][i].strike = this.strike;
        }
        this.screenDataDirty = true;
    }

    private void _newLine() {
        this.x = 0;
        if (++this.y >= this.rows) {
            --this.y;
            this._scroll(0, this.rows);
        }
    }

    public JScreen cmd(int ... nArray) {
        this.queueCmds.add(this._cmd(nArray));
        return this;
    }

    public JScreenTransaction begin() {
        JScreenTransaction jScreenTransaction = new JScreenTransaction(this, this.transactionID.getAndIncrement());
        this.transactions.put(jScreenTransaction.getID(), jScreenTransaction);
        this.queueCmds.add(new int[]{-100, jScreenTransaction.getID()});
        return jScreenTransaction;
    }

    public JScreen gotoX(int n) {
        this.queueCmds.add(new int[]{-20, n});
        return this;
    }

    public JScreen gotoXY(int n, int n2) {
        this.queueCmds.add(new int[]{-20, n, -21, n2});
        return this;
    }

    public JScreen gotoY(int n) {
        this.queueCmds.add(new int[]{-21, n});
        return this;
    }

    public JScreen gotoYX(int n, int n2) {
        this.queueCmds.add(new int[]{-21, n, -20, n2});
        return this;
    }

    public JScreen printChar(String string) {
        this.queueCmds.add(new int[]{-62, string.substring(0, 1).getBytes()[0]});
        return this;
    }

    public JScreen printChar(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("JScreen \"" + this.screenName + "\" ASCII value " + n + " is out of range");
        }
        this.queueCmds.add(new int[]{-62, n});
        return this;
    }

    public JScreen print(String string) {
        byte[] byArray = string.getBytes();
        if (byArray.length == 0) {
            return this;
        }
        int[] nArray = new int[byArray.length + 2];
        nArray[0] = -63;
        nArray[1] = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i + 2] = byArray[i] & 0xFF;
        }
        this.queueCmds.add(nArray);
        return this;
    }

    public JScreen println(String string) {
        byte[] byArray = string.getBytes();
        if (byArray.length == 0) {
            this.queueCmds.add(new int[]{-61});
        } else {
            int[] nArray = new int[byArray.length + 2];
            nArray[0] = -65;
            nArray[1] = byArray.length;
            for (int i = 0; i < byArray.length; ++i) {
                nArray[i + 2] = byArray[i] & 0xFF;
            }
            this.queueCmds.add(nArray);
        }
        return this;
    }

    public JScreen println() {
        this.queueCmds.add(new int[]{-61});
        return this;
    }

    public JScreen newLine() {
        this.queueCmds.add(new int[]{-61});
        return this;
    }

    public JScreen push() {
        this.queueCmds.add(new int[]{-80});
        return this;
    }

    public JScreen pushAttr() {
        this.queueCmds.add(new int[]{-81});
        return this;
    }

    public JScreen pop() {
        this.queueCmds.add(new int[]{-82});
        return this;
    }

    public JScreen waitPoint() {
        int n = this.waitPointID.getAndIncrement();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.waitPoints.put(n, countDownLatch);
        this.queueCmds.add(new int[]{-91, n});
        while (countDownLatch.getCount() != 0L) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this;
    }

    public JScreen printANSI(String string) {
        byte[] byArray = string.getBytes();
        if (byArray.length == 0) {
            return this;
        }
        int[] nArray = new int[byArray.length + 2];
        nArray[0] = -63;
        nArray[1] = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i + 2] = byArray[i] & 0xFF;
        }
        this.queueCmds.add(nArray);
        return this;
    }
}

