/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.security;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Arrays;

public class Base64 {
    public static final String VERSION = "1.01";
    static final char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private Base64() {
    }

    public static byte[] decode(byte[] byArray) throws ParseException {
        int n = byArray.length;
        if (n == 0) {
            return new byte[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n - n / 4);
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        boolean bl = false;
        block13: do {
            byte by;
            if ((by = byArray[n4++]) >= 65 && by <= 90) {
                n5 = by - 65;
            } else if (by >= 97 && by <= 122) {
                n5 = by - 71;
            } else if (by >= 48 && by <= 57) {
                n5 = by + 4;
            } else if (by == 43) {
                n5 = 62;
            } else if (by == 47) {
                n5 = 63;
            } else {
                if (by == 61) {
                    switch (n2) {
                        case 3: {
                            if (n4 == n || byArray[n4] != 61) break block13;
                            throw new ParseException("Incomplete Base64 sequence", n4);
                        }
                        case 2: {
                            if (n4 == n) {
                                throw new ParseException("Incomplete Base64 sequence", n4);
                            }
                            if (byArray[n4] == 61) break block13;
                            throw new ParseException("Malformed Base64 sequence", n4);
                        }
                        default: {
                            throw new ParseException("Malformed Base64 sequence", n4);
                        }
                    }
                }
                switch (by) {
                    case 0: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block13;
                    }
                    default: {
                        throw new ParseException("Invalid character", n4);
                    }
                }
            }
            switch (n2) {
                case 0: {
                    n3 = n5 << 2;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 1: {
                    byteBuffer.put((byte)(n3 | n5 >> 4));
                    n3 = n5 & 0xF;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 2: {
                    byteBuffer.put((byte)(n3 << 4 | n5 >> 2));
                    n3 = n5 & 3;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 3: {
                    byteBuffer.put((byte)(n3 << 6 | n5));
                    n2 = 0;
                }
            }
        } while (n4 < n);
        return Arrays.copyOf(byteBuffer.array(), byteBuffer.position());
    }

    public static byte[] decode(String string) throws ParseException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n - n / 4);
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        boolean bl = false;
        block13: do {
            char c;
            if ((c = string.charAt(n4++)) >= 'A' && c <= 'Z') {
                n5 = c - 65;
            } else if (c >= 'a' && c <= 'z') {
                n5 = c - 71;
            } else if (c >= '0' && c <= '9') {
                n5 = c + 4;
            } else if (c == '+') {
                n5 = 62;
            } else if (c == '/') {
                n5 = 63;
            } else {
                if (c == '=') {
                    switch (n2) {
                        case 3: {
                            if (n4 == n || string.charAt(n4) != '=') break block13;
                            throw new ParseException("Incomplete Base64 sequence", n4);
                        }
                        case 2: {
                            if (n4 == n) {
                                throw new ParseException("Incomplete Base64 sequence", n4);
                            }
                            if (string.charAt(n4) == '=') break block13;
                            throw new ParseException("Malformed Base64 sequence", n4);
                        }
                        default: {
                            throw new ParseException("Malformed Base64 sequence", n4);
                        }
                    }
                }
                switch (c) {
                    case '\u0000': 
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block13;
                    }
                    default: {
                        throw new ParseException("Invalid character", n4);
                    }
                }
            }
            switch (n2) {
                case 0: {
                    n3 = n5 << 2;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 1: {
                    byteBuffer.put((byte)(n3 | n5 >> 4));
                    n3 = n5 & 0xF;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 2: {
                    byteBuffer.put((byte)(n3 << 4 | n5 >> 2));
                    n3 = n5 & 3;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 3: {
                    byteBuffer.put((byte)(n3 << 6 | n5));
                    n2 = 0;
                }
            }
        } while (n4 < n);
        return Arrays.copyOf(byteBuffer.array(), byteBuffer.position());
    }

    public static byte[] sloppyDecode(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n - n / 4);
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        boolean bl = false;
        do {
            char c;
            if ((c = string.charAt(n4++)) >= 'A' && c <= 'Z') {
                n5 = c - 65;
            } else if (c >= 'a' && c <= 'z') {
                n5 = c - 71;
            } else if (c >= '0' && c <= '9') {
                n5 = c + 4;
            } else if (c == '+') {
                n5 = 62;
            } else {
                if (c != '/') continue;
                n5 = 63;
            }
            switch (n2) {
                case 0: {
                    n3 = n5 << 2;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 1: {
                    byteBuffer.put((byte)(n3 | n5 >> 4));
                    n3 = n5 & 0xF;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 2: {
                    byteBuffer.put((byte)(n3 << 4 | n5 >> 2));
                    n3 = n5 & 3;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 3: {
                    byteBuffer.put((byte)(n3 << 6 | n5));
                    n2 = 0;
                }
            }
        } while (n4 < n);
        return Arrays.copyOf(byteBuffer.array(), byteBuffer.position());
    }

    public static byte[] sloppyDecode(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return new byte[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n - n / 4);
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        boolean bl = false;
        do {
            byte by;
            if ((by = byArray[n4++]) >= 65 && by <= 90) {
                n5 = by - 65;
            } else if (by >= 97 && by <= 122) {
                n5 = by - 71;
            } else if (by >= 48 && by <= 57) {
                n5 = by + 4;
            } else if (by == 43) {
                n5 = 62;
            } else {
                if (by != 47) continue;
                n5 = 63;
            }
            switch (n2) {
                case 0: {
                    n3 = n5 << 2;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 1: {
                    byteBuffer.put((byte)(n3 | n5 >> 4));
                    n3 = n5 & 0xF;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 2: {
                    byteBuffer.put((byte)(n3 << 4 | n5 >> 2));
                    n3 = n5 & 3;
                    n2 = (byte)(n2 + 1);
                    break;
                }
                case 3: {
                    byteBuffer.put((byte)(n3 << 6 | n5));
                    n2 = 0;
                }
            }
        } while (n4 < n);
        return Arrays.copyOf(byteBuffer.array(), byteBuffer.position());
    }

    public static String encode(String string) {
        return Base64.encode(string.getBytes());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String encode(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return "";
        }
        int n2 = n + (3 - n % 3);
        StringBuilder stringBuilder = new StringBuilder(n + n / 25 + 4);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        do {
            int n6 = byArray[n5] < 0 ? 256 + byArray[n5++] : byArray[n5++];
            switch (n3) {
                case 0: {
                    stringBuilder.append(alphabet[(n6 & 0xFC) >>> 2]);
                    n4 = (n6 & 3) << 4;
                    if (n5 == n) {
                        stringBuilder.append(alphabet[n4]);
                        stringBuilder.append("==");
                        return stringBuilder.toString();
                    }
                    n3 = (byte)(n3 + 1);
                    break;
                }
                case 1: {
                    stringBuilder.append(alphabet[((n6 & 0xF0) >>> 4) + n4]);
                    n4 = (n6 & 0xF) << 2;
                    if (n5 == n) {
                        stringBuilder.append(alphabet[n4]);
                        stringBuilder.append("=");
                        return stringBuilder.toString();
                    }
                    n3 = (byte)(n3 + 1);
                    break;
                }
                case 2: {
                    stringBuilder.append(alphabet[((n6 & 0xC0) >>> 6) + n4]);
                    stringBuilder.append(alphabet[n6 & 0x3F]);
                    n3 = 0;
                }
            }
        } while (n5 < n);
        return stringBuilder.toString();
    }
}

