/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.net.rr;

import com.internationalnetwork.net.RR;
import com.internationalnetwork.util.ElectronicMailAddress;
import com.internationalnetwork.util.StringParser;
import java.text.ParseException;

public class SOA
extends RR {
    String nameServer;
    ElectronicMailAddress responsiblePerson;
    long serialNumber;
    long refresh;
    long retryInterval;
    long expiry;
    long minimumTTL;

    @Override
    public String toString() {
        return StringParser.join(" ", RR_TYPES[this.rrType], this.nameServer, this.responsiblePerson.toString(), Long.toString(this.serialNumber), Long.toString(this.refresh), Long.toString(this.retryInterval), Long.toString(this.expiry), Long.toString(this.minimumTTL));
    }

    public SOA(String string) {
        super(6, string);
        if (this.rrData.length != 7) {
            throw new IllegalArgumentException("Incorrect number of parameters");
        }
        this.nameServer = this.rrData[0];
        if (StringParser.isIPAddress(this.nameServer)) {
            throw new IllegalArgumentException("Invalid hostname - an IP address is not a hostname");
        }
        try {
            this.responsiblePerson = new ElectronicMailAddress(StringParser.convertFromRNAME(this.rrData[1], this.nameServer));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid responsible person eMail address - " + parseException.getMessage());
        }
        this.serialNumber = StringParser.parseInt(this.rrData[2], -1, new String[0]);
        if (this.serialNumber < 0L || this.serialNumber > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid serial number");
        }
        this.refresh = StringParser.parseInt(this.rrData[3], -1, new String[0]);
        if (this.refresh < 0L || this.refresh > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid refresh");
        }
        this.retryInterval = StringParser.parseInt(this.rrData[4], -1, new String[0]);
        if (this.retryInterval < 0L || this.retryInterval > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid retry interval");
        }
        this.expiry = StringParser.parseInt(this.rrData[5], -1, new String[0]);
        if (this.expiry < 0L || this.expiry > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid expiry");
        }
        this.minimumTTL = StringParser.parseInt(this.rrData[6], -1, new String[0]);
        if (this.minimumTTL < 0L || this.minimumTTL > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid minimum TTL");
        }
    }

    public SOA(String string, String string2, long l, long l2, long l3, long l4, long l5) {
        super(6);
        this.nameServer = string;
        if (StringParser.isIPAddress(this.nameServer)) {
            throw new IllegalArgumentException("Invalid hostname - an IP address is not a hostname");
        }
        try {
            this.responsiblePerson = new ElectronicMailAddress(StringParser.convertFromRNAME(string2, this.nameServer.toString()));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid responsible person eMail address - " + parseException.getMessage());
        }
        this.serialNumber = l;
        if (this.serialNumber < 0L || this.serialNumber > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid serial number");
        }
        this.refresh = l2;
        if (this.refresh < 0L || this.refresh > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid refresh");
        }
        this.retryInterval = l3;
        if (this.retryInterval < 0L || this.retryInterval > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid retry interval");
        }
        this.expiry = l4;
        if (this.expiry < 0L || this.expiry > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid expiry");
        }
        this.minimumTTL = l5;
        if (this.minimumTTL < 0L || this.minimumTTL > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid minimum TTL");
        }
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public ElectronicMailAddress getResponsiblePerson() {
        return this.responsiblePerson;
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public long getRefresh() {
        return this.refresh;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public long getMinimumTTL() {
        return this.minimumTTL;
    }
}

