/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.net.rr;

import com.internationalnetwork.net.RR;
import com.internationalnetwork.util.StringParser;

public class RT
extends RR {
    int preference;
    String intermediateHost;

    @Override
    public String toString() {
        return RR_TYPES[this.rrType] + " " + this.preference + " " + this.intermediateHost;
    }

    public RT(String string) {
        super(21, string);
        if (this.rrData.length != 2) {
            throw new IllegalArgumentException("Incorrect number of parameters");
        }
        this.preference = StringParser.parseInt(this.rrData[0], -1, new String[0]);
        if (this.preference < 0 || this.preference > 65535) {
            throw new IllegalArgumentException("Preference is malformed or out of range");
        }
        this.intermediateHost = this.rrData[1];
        if (StringParser.isIPAddress(this.intermediateHost)) {
            throw new IllegalArgumentException("Invalid intermediate host - an IP address is not a hostname");
        }
    }

    public RT(int n, String string) {
        super(21);
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Preference is malformed or out of range");
        }
        this.preference = n;
        if (StringParser.isIPAddress(string)) {
            throw new IllegalArgumentException("Invalid intermediate host - an IP address is not a hostname");
        }
        this.intermediateHost = string;
    }

    public int getPreference() {
        return this.preference;
    }

    public String getIntermediateHost() {
        return this.intermediateHost;
    }
}

