/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.net.rr;

import com.internationalnetwork.net.RR;
import com.internationalnetwork.util.ElectronicMailAddress;
import com.internationalnetwork.util.StringParser;
import java.text.ParseException;

public class RP
extends RR {
    ElectronicMailAddress responsiblePerson;
    String location;

    @Override
    public String toString() {
        return RR_TYPES[this.rrType] + " " + this.responsiblePerson.toString() + " " + this.location;
    }

    public RP(String string) {
        super(17, string);
        if (this.rrData.length != 2) {
            throw new IllegalArgumentException("Incorrect number of parameters");
        }
        try {
            this.responsiblePerson = new ElectronicMailAddress(StringParser.convertFromRNAME(this.rrData[0], ""));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid responsible person eMail address - " + parseException.getMessage());
        }
        this.location = this.rrData[1];
    }

    public RP(String string, String string2) {
        super(17);
        try {
            this.responsiblePerson = new ElectronicMailAddress(StringParser.convertFromRNAME(string, ""));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid responsible person eMail address - " + parseException.getMessage());
        }
        this.location = string2;
    }

    public ElectronicMailAddress getResponsiblePerson() {
        return this.responsiblePerson;
    }

    public String getLocation() {
        return this.location;
    }
}

