/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.net.rr;

import com.internationalnetwork.net.RR;
import com.internationalnetwork.util.StringParser;

public class MX
extends RR {
    int preference;
    String exchanger;

    @Override
    public String toString() {
        return RR_TYPES[this.rrType] + " " + this.preference + " " + this.exchanger;
    }

    public MX(String string) {
        super(15, string);
        if (this.rrData.length != 2) {
            throw new IllegalArgumentException("Incorrect number of parameters");
        }
        this.preference = StringParser.parseInt(this.rrData[0], -1, new String[0]);
        if (this.preference < 0 || this.preference > 65535) {
            throw new IllegalArgumentException("Preference is malformed or out of range");
        }
        this.exchanger = this.rrData[1];
        if (StringParser.isIPAddress(this.exchanger)) {
            throw new IllegalArgumentException("Invalid hostname - an IP address is not a hostname");
        }
    }

    public MX(int n, String string) {
        super(15, Integer.toString(n), string);
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Preference is malformed or out of range");
        }
        this.preference = n;
        string = this.rrData[1];
        if (StringParser.isIPAddress(string)) {
            throw new IllegalArgumentException("Invalid hostname - an IP address is not a hostname");
        }
    }

    public int getPreference() {
        return this.preference;
    }

    public String getExchanger() {
        return this.exchanger;
    }
}

