/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.net.rr;

import com.internationalnetwork.net.RR;
import com.internationalnetwork.util.StringParser;

public class AFSDB
extends RR {
    int subType;
    String location;

    @Override
    public String toString() {
        return RR_TYPES[this.rrType] + " " + this.subType + " " + this.location;
    }

    public AFSDB(String string) {
        super(18, string);
        if (this.rrData.length != 2) {
            throw new IllegalArgumentException("Incorrect number of parameters");
        }
        this.subType = StringParser.parseInt(this.rrData[0], -1, new String[0]);
        if (this.subType < 0 || this.subType > 65535) {
            throw new IllegalArgumentException("Sub Type is malformed or out of range");
        }
        this.location = this.rrData[1];
        if (StringParser.isIPAddress(this.location)) {
            throw new IllegalArgumentException("Invalid location - an IP address is not a hostname");
        }
    }

    public AFSDB(int n, String string) {
        super(18);
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Preference is malformed or out of range");
        }
        this.subType = n;
        if (StringParser.isIPAddress(string)) {
            throw new IllegalArgumentException("Invalid hostname - an IP address is not a hostname");
        }
        this.location = string;
    }

    public int getSubType() {
        return this.subType;
    }

    public String getLocation() {
        return this.location;
    }
}

