/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.net;

import com.internationalnetwork.util.StringParser;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class ServerSockets {
    public static final String VERSION = "1.02";
    Selector selector;
    Set keys;
    Iterator list = new ArrayList().iterator();

    public ServerSockets() throws IOException {
        this.selector = Selector.open();
    }

    public ServerSockets(String ... stringArray) throws IOException {
        this.selector = Selector.open();
        if (stringArray != null) {
            this.bind(stringArray);
        }
    }

    public ServerSockets(SocketAddress ... socketAddressArray) throws BindException, IOException {
        this.selector = Selector.open();
        if (socketAddressArray != null) {
            this.bind(socketAddressArray);
        }
    }

    public SocketChannel accept() throws IOException {
        SocketChannel socketChannel;
        while ((socketChannel = this.accept(0)) == null) {
        }
        return socketChannel;
    }

    public SocketChannel accept(int n) throws IOException {
        if (this.selector.select(n) > 0) {
            this.keys = this.selector.selectedKeys();
            for (SelectionKey selectionKey : this.keys) {
                this.list.remove();
                if (!selectionKey.isAcceptable()) continue;
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                return serverSocketChannel.accept();
            }
        }
        return null;
    }

    public SocketChannel[] acceptMultiple() throws IOException {
        return this.acceptMultiple(0, 0);
    }

    public SocketChannel[] acceptMultiple(int n) throws IOException {
        return this.acceptMultiple(n, 0);
    }

    public SocketChannel[] acceptMultiple(int n, int n2) throws IOException {
        ArrayList<SocketChannel> arrayList = new ArrayList<SocketChannel>(n);
        if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        int n3 = 0;
        do {
            SocketChannel socketChannel;
            if (n3 == 0) {
                socketChannel = this.accept(n2);
            } else {
                try {
                    socketChannel = this.accept(n2);
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (socketChannel == null) {
                if (n3 != 0) break;
                continue;
            }
            arrayList.add(socketChannel);
            ++n3;
            n2 = 1;
        } while (n3 < n);
        return arrayList.toArray(new SocketChannel[0]);
    }

    public void bind(String ... stringArray) throws BindException, IOException {
        if (stringArray != null) {
            for (String string : stringArray) {
                String[] stringArray2 = StringParser.splitPairs("ip=" + string.toLowerCase(), "ip", "port", "backlog");
                int n = Integer.parseInt(stringArray2[1]);
                if (n < 0 || n > 65535) {
                    throw new IndexOutOfBoundsException("Port number is out of range");
                }
                this.bind((SocketAddress)new InetSocketAddress(stringArray2[0], n), StringParser.parseInt(stringArray2[2], 0, new String[0]));
            }
        } else {
            throw new NullPointerException("Missing an address endpoint");
        }
    }

    public void bind(SocketAddress ... socketAddressArray) throws BindException, IOException {
        if (socketAddressArray != null) {
            for (SocketAddress socketAddress : socketAddressArray) {
                this.bind(socketAddress, 0);
            }
        } else {
            throw new NullPointerException("Missing a SocketAddress endpoint");
        }
    }

    public void bind(SocketAddress socketAddress, int n) throws BindException, IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(socketAddress, n);
        serverSocketChannel.configureBlocking(false);
        serverSocketChannel.register(this.selector, 16);
    }
}

