/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.net;

import com.internationalnetwork.net.rr.A;
import com.internationalnetwork.net.rr.AAAA;
import com.internationalnetwork.net.rr.AFSDB;
import com.internationalnetwork.net.rr.CNAME;
import com.internationalnetwork.net.rr.GPOS;
import com.internationalnetwork.net.rr.HINFO;
import com.internationalnetwork.net.rr.ISDN;
import com.internationalnetwork.net.rr.MB;
import com.internationalnetwork.net.rr.MD;
import com.internationalnetwork.net.rr.MF;
import com.internationalnetwork.net.rr.MG;
import com.internationalnetwork.net.rr.MINFO;
import com.internationalnetwork.net.rr.MR;
import com.internationalnetwork.net.rr.MX;
import com.internationalnetwork.net.rr.NS;
import com.internationalnetwork.net.rr.PTR;
import com.internationalnetwork.net.rr.RP;
import com.internationalnetwork.net.rr.RT;
import com.internationalnetwork.net.rr.SOA;
import com.internationalnetwork.net.rr.TXT;
import com.internationalnetwork.net.rr.X25;

public abstract class RR {
    public static final String VERSION = "1.01";
    public static final String[] RR_TYPES = new String[]{null, "A", "NS", "MD", "MF", "CNAME", "SOA", "MB", "MG", "MR", "NULL", "WKS", "PTR", "HINFO", "MINFO", "MX", "TXT", "RP", "AFSDB", "X25", "ISDN", "RT", "NSAP", "NSAP-PTR", "SIG", "KEY", "PX", "GPOS", "AAAA", "LOC", "NXT", "EID", "NIMLOC", "SRV", "ATMA", "NAPTR", "KX", "CERT", "A6", "DNAME", "SINK", "OPT"};
    public static final int A = 1;
    public static final int NS = 2;
    public static final int MD = 3;
    public static final int MF = 4;
    public static final int CNAME = 5;
    public static final int SOA = 6;
    public static final int MB = 7;
    public static final int MG = 8;
    public static final int MR = 9;
    public static final int NULL = 10;
    public static final int WKS = 11;
    public static final int PTR = 12;
    public static final int HINFO = 13;
    public static final int MINFO = 14;
    public static final int MX = 15;
    public static final int TXT = 16;
    public static final int RP = 17;
    public static final int AFSDB = 18;
    public static final int X25 = 19;
    public static final int ISDN = 20;
    public static final int RT = 21;
    public static final int NSAP = 22;
    public static final int NSAP_PTR = 23;
    public static final int SIG = 24;
    public static final int KEY = 25;
    public static final int PX = 26;
    public static final int GPOS = 27;
    public static final int AAAA = 28;
    public static final int LOC = 29;
    public static final int NXT = 30;
    public static final int EID = 31;
    public static final int NIMLOC = 32;
    public static final int SRV = 33;
    public static final int ATMA = 34;
    public static final int NAPTR = 35;
    public static final int KX = 36;
    public static final int CERT = 37;
    public static final int A6 = 38;
    public static final int DNAME = 39;
    public static final int SINK = 40;
    public static final int OPT = 41;
    public static final int CLASS_IN = 1;
    public static final int CLASS_CS = 2;
    public static final int CLASS_CH = 3;
    public static final int CLASS_HS = 4;
    public final int rrType;
    protected final String[] rrData;

    private RR() {
        throw new Error();
    }

    public RR(int n, int n2) {
        this.rrType = n;
        this.rrData = new String[n2];
    }

    public abstract String toString();

    public RR(int n) {
        this.rrType = n;
        this.rrData = new String[0];
    }

    public RR(int n, String string) {
        this.rrType = n;
        this.rrData = string.split(" ");
    }

    public RR(int n, String ... stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("DNS records can't be instantiated without data");
        }
        this.rrType = n;
        this.rrData = stringArray;
    }

    public RR(String string, String string2) {
        String string3 = string.toUpperCase();
        int n = -1;
        for (int i = 0; i < RR_TYPES.length; ++i) {
            if (!string3.equals(RR_TYPES[i])) continue;
            n = i;
        }
        if (n < 0) {
            if (string3.equals("ICBM")) {
                n = 29;
            } else if (string3.equals("NSAP_PTR")) {
                n = 23;
            } else {
                throw new IllegalArgumentException("RR type " + string3 + " is not supported");
            }
        }
        this.rrType = n;
        this.rrData = string2.split(" ");
    }

    public static RR parseRR(String string) {
        String[] stringArray = string.split(" ", 2);
        return RR.parseRR(stringArray[0], stringArray[1]);
    }

    public static RR parseRR(int n, String string) {
        switch (n) {
            case 1: {
                return new A(string);
            }
            case 28: {
                return new AAAA(string);
            }
            case 2: {
                return new NS(string);
            }
            case 6: {
                return new SOA(string);
            }
            case 15: {
                return new MX(string);
            }
            case 12: {
                return new PTR(string);
            }
            case 16: {
                return new TXT(string);
            }
            case 18: {
                return new AFSDB(string);
            }
            case 5: {
                return new CNAME(string);
            }
            case 27: {
                return new GPOS(string);
            }
            case 13: {
                return new HINFO(string);
            }
            case 20: {
                return new ISDN(string);
            }
            case 7: {
                return new MB(string);
            }
            case 3: {
                return new MD(string);
            }
            case 4: {
                return new MF(string);
            }
            case 8: {
                return new MG(string);
            }
            case 14: {
                return new MINFO(string);
            }
            case 9: {
                return new MR(string);
            }
            case 17: {
                return new RP(string);
            }
            case 21: {
                return new RT(string);
            }
            case 19: {
                return new X25(string);
            }
        }
        return null;
    }

    public static RR parseRR(String string, String string2) {
        string = string.toUpperCase();
        int n = -1;
        for (int i = 0; i < RR_TYPES.length; ++i) {
            if (!string.equals(RR_TYPES[i])) continue;
            n = i;
        }
        return RR.parseRR(n, string2);
    }
}

