/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.math.random;

public class MersenneTwister {
    public static final String VERSION = "1.01";
    private static final long UM = Integer.MIN_VALUE;
    private static final long LM = Integer.MIN_VALUE ^ 0xFFFFFFFFFFFFFFFFL;
    private static final long[] mag01 = new long[]{0L, -5403634167711393303L};
    private static final int NN = 312;
    private static final int MM = 156;
    private long num;
    private long[] mt = new long[312];
    private int mti = 313;

    private MersenneTwister() {
        this.num = 0L;
    }

    public MersenneTwister(long ... lArray) {
        if (lArray.length == 1) {
            this.mt[0] = lArray[0];
            this.mti = 1;
            while (this.mti < 312) {
                this.mt[this.mti] = 6364136223846793005L * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 62) + (long)this.mti;
                ++this.mti;
            }
        } else {
            int n;
            this.mt[0] = 19650218L;
            this.mti = 1;
            while (this.mti < 312) {
                this.mt[this.mti] = 6364136223846793005L * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 62) + (long)this.mti;
                ++this.mti;
            }
            int n2 = 1;
            int n3 = 0;
            int n4 = n = 312 > lArray.length ? 312 : lArray.length;
            while (n != 0) {
                this.mt[n2] = (this.mt[n2] ^ (this.mt[n2 - 1] ^ this.mt[n2 - 1] >>> 62) * 3935559000370003845L) + lArray[n3] + (long)n3;
                ++n3;
                if (++n2 >= 312) {
                    this.mt[0] = this.mt[311];
                    n2 = 1;
                }
                if (n3 >= lArray.length) {
                    n3 = 0;
                }
                --n;
            }
            for (n = 311; n != 0; --n) {
                this.mt[n2] = (this.mt[n2] ^ (this.mt[n2 - 1] ^ this.mt[n2 - 1] >>> 62) * 2862933555777941757L) - (long)n2;
                if (++n2 < 312) continue;
                this.mt[0] = this.mt[311];
                n2 = 1;
            }
            this.mt[0] = Long.MIN_VALUE;
        }
        this.calculateNext();
    }

    public int nextInt() {
        this.calculateNext();
        return (int)this.num;
    }

    public int nextInt(int n) {
        this.calculateNext();
        if (this.num < 0L) {
            this.num = -this.num;
        }
        long l = Integer.MAX_VALUE;
        while (this.num >= (long)n) {
            this.num &= l;
            l >>>= 1;
        }
        return (int)this.num;
    }

    public int currentInt() {
        return (int)this.num;
    }

    public long nextLong() {
        this.calculateNext();
        return this.num;
    }

    public long nextLong(long l) {
        this.calculateNext();
        if (this.num < 0L) {
            this.num = -this.num;
        }
        long l2 = Long.MAX_VALUE;
        while (this.num >= l) {
            this.num &= l2;
            l2 >>>= 1;
        }
        return this.num;
    }

    public long currentLong() {
        return this.num;
    }

    private void calculateNext() {
        if (this.mti >= 312) {
            int n;
            for (n = 0; n < 156; ++n) {
                this.num = this.mt[n] & UM | this.mt[n + 1] & LM;
                this.mt[n] = this.mt[n + 156] ^ this.num >>> 1 ^ mag01[(int)(this.num & 1L)];
            }
            while (n < 311) {
                this.num = this.mt[n] & UM | this.mt[n + 1] & LM;
                this.mt[n] = this.mt[n + -156] ^ this.num >>> 1 ^ mag01[(int)(this.num & 1L)];
                ++n;
            }
            this.num = this.mt[311] & UM | this.mt[0] & LM;
            this.mt[311] = this.mt[155] ^ this.num >>> 1 ^ mag01[(int)(this.num & 1L)];
            this.mti = 0;
        }
        this.num = this.mt[this.mti++];
        this.num ^= this.num >>> 29 & 0x5555555555555555L;
        this.num ^= this.num << 17 & 0x71D67FFFEDA60000L;
        this.num ^= this.num << 37 & 0xFFF7EEE000000000L;
        this.num ^= this.num >>> 43;
    }
}

