/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.lang;

import java.math.BigInteger;

public final class VeryLong
extends Number
implements Comparable {
    public static final String VERSION = "1.00";
    public static final BigInteger MIN_VALUE = new BigInteger("-170141183460469231731687303715884105728");
    public static final BigInteger MAX_VALUE = new BigInteger("170141183460469231731687303715884105727");
    public static final int SIZE = 128;
    public static final int SIZE8 = 16;
    private static final int SIZE8L = 15;
    private final BigInteger value;

    public VeryLong(byte[] byArray) {
        if (byArray.length > 16) {
            throw new NumberFormatException();
        }
        this.value = new BigInteger(byArray);
    }

    public VeryLong(int n) {
        this.value = BigInteger.valueOf(n);
    }

    public VeryLong(BigInteger bigInteger) {
        if (bigInteger.compareTo(MIN_VALUE) < 0 || bigInteger.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
        this.value = bigInteger;
    }

    public VeryLong(String string) {
        this.value = new BigInteger(string, 10);
        if (this.value.compareTo(MIN_VALUE) < 0 || this.value.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
    }

    public VeryLong(String string, int n) {
        this.value = new BigInteger(string, n);
        if (this.value.compareTo(MIN_VALUE) < 0 || this.value.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
    }

    public static String toString(VeryLong veryLong) {
        if (veryLong.compareTo(MIN_VALUE) < 0 || veryLong.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
        return veryLong.toString();
    }

    public static VeryLong parseVeryLong(String string) {
        return new VeryLong(string);
    }

    public static VeryLong parseVeryLong(String string, int n) {
        return new VeryLong(string, n);
    }

    public static VeryLong valueOf(String string, int n) {
        return new VeryLong(string, n);
    }

    public static VeryLong valueOf(String string) {
        return new VeryLong(string);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = this.value.toByteArray();
        int n = 15;
        int n2 = byArray2.length;
        while (n >= 0) {
            byArray[n] = n2 >= 0 ? byArray2[n2] : (byte)0;
            --n;
            --n2;
        }
        return byArray;
    }

    @Override
    public short shortValue() {
        return (short)this.value.intValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public String toString(int n) {
        return this.value.toString(n);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return this.value.equals(object);
    }

    public int compareTo(VeryLong veryLong) {
        return this.value.compareTo(veryLong.value);
    }

    public int compareTo(Object object) {
        return this.compareTo((VeryLong)object);
    }

    public VeryLong negate() {
        return new VeryLong(this.value.negate());
    }

    public static VeryLong coerce(BigInteger bigInteger) {
        return VeryLong._convert(bigInteger);
    }

    private static VeryLong _convert(BigInteger bigInteger) {
        byte[] byArray = new byte[16];
        byte[] byArray2 = bigInteger.toByteArray();
        int n = 15;
        int n2 = byArray2.length;
        while (n >= 0) {
            byArray[n] = n2 >= 0 ? byArray2[n2] : (byte)0;
            --n;
            --n2;
        }
        return bigInteger.signum() >= 0 ? new VeryLong(byArray) : new VeryLong(byArray).negate();
    }
}

