/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.lang;

public final class Nybble
extends Number
implements Comparable {
    public static final String VERSION = "1.00";
    public static final byte MIN_VALUE = -8;
    public static final byte MAX_VALUE = 7;
    public static final int SIZE = 4;
    public static final Class TYPE = Byte.TYPE;
    private final byte value;

    public Nybble(byte by) {
        if (by < -8 || by > 7) {
            throw new NumberFormatException();
        }
        this.value = Nybble._convert(by);
    }

    public Nybble(int n) {
        if (n < -8 || n > 7) {
            throw new NumberFormatException();
        }
        this.value = Nybble._convert((byte)n);
    }

    public Nybble(String string) {
        this.value = Nybble.parseNybble(string, 10);
    }

    public static String toString(byte by) {
        if (by < -8 || by > 7) {
            throw new NumberFormatException();
        }
        return String.valueOf(Nybble._convert(by));
    }

    public static byte parseNybble(String string) {
        byte by = Byte.parseByte(string, 10);
        if (by < -8 || by > 7) {
            throw new NumberFormatException();
        }
        return by;
    }

    public static byte parseNybble(String string, int n) {
        byte by = Byte.parseByte(string, n);
        if (by < -8 || by > 7) {
            throw new NumberFormatException();
        }
        return by;
    }

    public static Nybble valueOf(String string, int n) {
        return new Nybble(Nybble.parseNybble(string, n));
    }

    public static Nybble valueOf(String string) {
        return new Nybble(Nybble.parseNybble(string, 10));
    }

    public static Nybble decode(String string) {
        return new Nybble(Integer.decode(string));
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Nybble && this.value == ((Nybble)object).value;
    }

    public int compareTo(Nybble nybble) {
        if (this.value == nybble.value) {
            return 0;
        }
        return this.value > nybble.value ? 1 : -1;
    }

    public int compareTo(Object object) {
        return this.compareTo((Nybble)object);
    }

    public static byte coerce(byte by) {
        return Nybble._convert(by);
    }

    public static int coerce(int n) {
        return Nybble._convert((byte)n);
    }

    private static byte _convert(byte by) {
        if (by >= 0) {
            return (byte)(by & 7);
        }
        return (byte)((by & 7) - 8);
    }
}

