/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.lang;

import com.internationalnetwork.lang.DynamicThread;
import com.internationalnetwork.lang.ReRunnable;
import com.internationalnetwork.util.StringParser;
import java.io.Serializable;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class DynamicThreadPool<Target extends Runnable>
implements Runnable {
    public static final String VERSION = "1.00";
    private String poolName;
    private volatile int minimumThreads = 0;
    private volatile int maximumThreads = 0;
    private volatile int minimumSpareThreads = 0;
    private volatile int maximumSpareThreads = 0;
    private volatile long maximumDispatches = 1L;
    private volatile long maximumExceptions = 0L;
    private ThreadGroup threadGroup;
    private Thread managerThread;
    private Runnable skulkerRunnable;
    private Thread skulkerThread = null;
    private ThreadGroup poolThreadGroup;
    private Class<Target> poolThread;
    private boolean isReRunnable = false;
    private LinkedBlockingQueue<Object> skulkerQueue = null;
    private volatile int poolPriority = 5;
    private volatile long poolStackSize = 0L;
    private volatile int resetPriority = 5;
    private volatile int managerPriority = 5;
    private volatile long managerStackSize = 0L;
    private volatile int skulkerPriority = 4;
    private volatile long skulkerStackSize = 0L;
    private String threadNamePrefix = "";
    private String threadNameSuffix = "";
    private volatile boolean resetFinalDispatch = false;
    private volatile boolean debug = false;
    private Object o = new Object();
    private long poolAttenuationDelay = 2000L;
    private long poolAttenuationSchedule = 0L;
    private int poolAttenuationDecay = 1;
    private long poolMaintenanceDelay = 2000L;
    private long threadDestructionDelay = 1000L;
    private int spareThreadIncrement = 1;
    private long threadCount = 0L;
    private long threadsExcepted = 0L;
    private long threadsFinished = 0L;
    private ConcurrentHashMap<Long, DynamicThread> pool;
    private LinkedBlockingQueue<Long> ready = new LinkedBlockingQueue();
    private HashSet<Long> active = new HashSet();
    private LinkedBlockingQueue<Long> dead = new LinkedBlockingQueue();

    private DynamicThreadPool() {
    }

    public DynamicThreadPool(Class<Target> clazz, String string) throws InstantiationException, IllegalAccessException {
        this(clazz, string, 10, 100, 5, 25);
    }

    public DynamicThreadPool(Class<Target> clazz, String string, int n) throws InstantiationException, IllegalAccessException {
        this(clazz, string, n, n, 0, 0);
    }

    public DynamicThreadPool(Class<Target> clazz, String string, int n, int n2) throws InstantiationException, IllegalAccessException {
        this(clazz, string, n, n2, 1, 1);
    }

    public DynamicThreadPool(Class<Target> clazz, String string, int n, int n2, int n3) throws InstantiationException, IllegalAccessException {
        this(clazz, string, n, n2, n3, n3);
    }

    public DynamicThreadPool(Class<Target> clazz, String string, int n, int n2, int n3, int n4) throws InstantiationException, IllegalAccessException {
        if (clazz == null) {
            throw new IllegalArgumentException("Null is not a valid Thread object");
        }
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Null or empty pool name");
        }
        if (!StringParser.isInternetName(string)) {
            throw new IllegalArgumentException("Pool name contains invalid characters");
        }
        if (clazz.newInstance() instanceof ReRunnable) {
            this.isReRunnable = true;
        }
        this.poolName = string;
        this.threadNamePrefix = string + "-";
        this.poolThread = clazz;
        this.minimumThreads = n;
        this.maximumThreads = n2;
        this.minimumSpareThreads = n3;
        this.maximumSpareThreads = n4;
    }

    public DynamicThreadPool<Target> start() {
        this.threadGroup = new ThreadGroup(this.poolName + ".root");
        this.poolThreadGroup = new ThreadGroup(this.threadGroup, this.poolName);
        this.managerThread = new Thread(this.threadGroup, this, "Manager", this.managerStackSize);
        this.managerThread.setPriority(this.managerPriority);
        this.fixThreadLimits();
        this.pool = new ConcurrentHashMap(this.minimumThreads + this.minimumSpareThreads);
        if (this.skulkerThread != null) {
            this.skulkerQueue = new LinkedBlockingQueue();
            this.skulkerThread = new Thread(this.threadGroup, this.skulkerRunnable, "Skulker", this.skulkerStackSize);
            this.skulkerThread.setPriority(this.skulkerPriority);
            this.skulkerThread.start();
        }
        this.printDebug("Created " + this.addThreads(this.minimumThreads) + " base thread(s)");
        this.managerThread.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixThreadLimits() {
        if (this.managerThread == null) {
            return;
        }
        Object object = this.o;
        synchronized (object) {
            if (this.maximumThreads < this.minimumThreads) {
                this.maximumThreads = this.minimumThreads;
            }
            if (this.maximumThreads < this.minimumSpareThreads + this.minimumThreads) {
                this.minimumSpareThreads = this.maximumThreads - this.minimumThreads;
            }
            if (this.minimumSpareThreads > this.maximumSpareThreads) {
                this.minimumSpareThreads = this.maximumSpareThreads;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicThread dispatch() {
        boolean bl = false;
        long l = -1L;
        do {
            if (bl) {
                Thread.currentThread();
                Thread.interrupted();
            }
            bl = false;
            try {
                l = this.ready.take();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        } while (bl || this.pool.get(l) == null);
        HashSet<Long> hashSet = this.active;
        synchronized (hashSet) {
            this.active.add(l);
        }
        this.managerThread.interrupt();
        return this.pool.get(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumThreads(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Minimum threads must be greater than zero");
        }
        Object object = this.o;
        synchronized (object) {
            this.minimumThreads = n;
        }
        this.fixThreadLimits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumThreads(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Maximum threads must be greater than zero");
        }
        Object object = this.o;
        synchronized (object) {
            this.maximumThreads = n;
        }
        this.fixThreadLimits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadLimits(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Minimum threads must be greater than zero");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Maximum threads must be greater than zero");
        }
        Object object = this.o;
        synchronized (object) {
            this.minimumThreads = n;
            this.maximumThreads = n2;
        }
        this.fixThreadLimits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumSpareThreads(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Minimum spare threads must be equal to or greater than zero");
        }
        Object object = this.o;
        synchronized (object) {
            this.minimumSpareThreads = n;
        }
        this.fixThreadLimits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumSpareThreads(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Maximum spare threads must be equal to or greater than zero");
        }
        Object object = this.o;
        synchronized (object) {
            this.maximumSpareThreads = n;
        }
        this.fixThreadLimits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpareThreadLimits(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Minimum spare threads must be equal to or greater than zero");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Maximum spare threads must be equal to or greater than zero");
        }
        Object object = this.o;
        synchronized (object) {
            this.minimumSpareThreads = n;
            this.maximumSpareThreads = n;
        }
        this.fixThreadLimits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getThreadLimits() {
        Object object = this.o;
        synchronized (object) {
            return new int[]{this.minimumThreads, this.maximumThreads, this.minimumSpareThreads, this.maximumSpareThreads};
        }
    }

    public void setThreadStackSize(long l) {
        this.poolStackSize = l;
    }

    public void setManagerStackSize(long l) {
        if (this.managerThread != null) {
            throw new IllegalThreadStateException("Manager thread was already started");
        }
        this.managerStackSize = l;
    }

    public void setSkulkerStackSize(long l) {
        if (this.skulkerThread != null) {
            throw new IllegalThreadStateException("Manager thread was already started");
        }
        this.skulkerStackSize = l;
    }

    public void setSkulkerRunnable(Runnable runnable) {
        if (this.managerThread != null) {
            throw new IllegalThreadStateException("Manager thread was already started");
        }
        this.skulkerRunnable = runnable;
    }

    public Thread getSkulkerThread() {
        if (this.managerThread == null) {
            throw new IllegalThreadStateException("Manager thread not started");
        }
        return this.skulkerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadNamePrefix(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() > 0 && !StringParser.isInternetName(string)) {
            throw new IllegalArgumentException("Pool thread name prefix contains invalid characters");
        }
        String string2 = this.threadNamePrefix;
        synchronized (string2) {
            this.threadNamePrefix = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadNameSuffix(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() > 0 && !StringParser.isInternetName(string)) {
            throw new IllegalArgumentException("Pool thread name suffix contains invalid characters");
        }
        String string2 = this.threadNameSuffix;
        synchronized (string2) {
            this.threadNameSuffix = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setThreadPriority(int n) {
        LinkedBlockingQueue<Long> linkedBlockingQueue = this.o;
        synchronized (linkedBlockingQueue) {
            this.poolPriority = n;
        }
        linkedBlockingQueue = this.ready;
        synchronized (linkedBlockingQueue) {
            for (Long l : this.ready.toArray(new Long[0])) {
                this.pool.get(l).setPriority(n);
            }
            return this.ready.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getThreadPriority() {
        Object object = this.o;
        synchronized (object) {
            return this.poolPriority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadResetPriority(int n) {
        Object object = this.o;
        synchronized (object) {
            this.resetPriority = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getThreadResetPriority() {
        Object object = this.o;
        synchronized (object) {
            return this.resetPriority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagerPriority(int n) {
        Object object = this.o;
        synchronized (object) {
            this.managerPriority = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getManagerPriority() {
        Object object = this.o;
        synchronized (object) {
            return this.managerPriority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkulkerPriority(int n) {
        Object object = this.o;
        synchronized (object) {
            this.skulkerPriority = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSkulkerPriority() {
        Object object = this.o;
        synchronized (object) {
            return this.skulkerPriority;
        }
    }

    public boolean isReRunnable() {
        return this.isReRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolAttenuationDelay(long l) {
        Object object = this.o;
        synchronized (object) {
            this.poolAttenuationDelay = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPoolAttenuationDelay() {
        Object object = this.o;
        synchronized (object) {
            return this.poolAttenuationDelay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolAttenuationDecay(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Pool Attenuation Decay out of range (must be greater than 0)");
        }
        Object object = this.o;
        synchronized (object) {
            this.poolAttenuationDecay = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolAttenuationDecay() {
        Object object = this.o;
        synchronized (object) {
            return this.poolAttenuationDecay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpareThreadIncrement(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Spare Thread Increment out of range (must be greater than 0)");
        }
        Object object = this.o;
        synchronized (object) {
            this.spareThreadIncrement = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpareThreadIncrement() {
        Object object = this.o;
        synchronized (object) {
            return this.spareThreadIncrement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadDestructionDelay(long l) {
        Object object = this.o;
        synchronized (object) {
            this.threadDestructionDelay = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getThreadDestructionDelay() {
        Object object = this.o;
        synchronized (object) {
            return this.threadDestructionDelay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolMaintenanceDelay(long l) {
        Object object = this.o;
        synchronized (object) {
            this.poolMaintenanceDelay = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPoolMaintenanceDelay() {
        Object object = this.o;
        synchronized (object) {
            return this.poolMaintenanceDelay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumDispatchesPerThread(long l) {
        if (!this.isReRunnable) {
            throw new ClassCastException("Target does not implement the ReRunnable interface");
        }
        if (l < 1L) {
            throw new IllegalArgumentException("Number of dispatches out of range (must be greater than 0)");
        }
        Object object = this.o;
        synchronized (object) {
            this.maximumDispatches = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumExceptionsPerThread(long l) {
        if (!this.isReRunnable) {
            throw new ClassCastException("Target does not implement the ReRunnable interface");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Number of exceptions out of range (must be equal to or greater than 0)");
        }
        Object object = this.o;
        synchronized (object) {
            this.maximumExceptions = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResetAfterFinalDispatch(boolean bl) {
        if (!this.isReRunnable) {
            throw new ClassCastException("Target does not implement the ReRunnable interface");
        }
        Object object = this.o;
        synchronized (object) {
            this.resetFinalDispatch = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addThread() {
        DynamicThread<Runnable> dynamicThread;
        if (this.pool.size() >= this.maximumThreads) {
            return false;
        }
        boolean bl = false;
        String string = this.threadNamePrefix + this.threadCount + this.threadNameSuffix;
        try {
            dynamicThread = new DynamicThread<Runnable>(this, this.threadCount, this.poolThreadGroup, (Runnable)this.poolThread.newInstance(), string, this.poolStackSize);
            dynamicThread.setPriority(this.poolPriority);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return false;
        }
        ConcurrentHashMap<Long, DynamicThread> concurrentHashMap = this.pool;
        synchronized (concurrentHashMap) {
            this.pool.put(this.threadCount, dynamicThread);
            do {
                if (bl) {
                    Thread.currentThread();
                    Thread.interrupted();
                }
                bl = false;
                try {
                    this.ready.put(this.threadCount);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            } while (bl);
            ++this.threadCount;
        }
        return true;
    }

    public int addThreads(int n) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Number of threads to add must be a positive integer");
        }
        for (n2 = 0; n2 < n && this.addThread(); ++n2) {
        }
        return n2;
    }

    public boolean removeThread() {
        if (this.pool.size() <= this.minimumThreads) {
            return false;
        }
        boolean bl = false;
        long l = 0L;
        do {
            if (bl) {
                Thread.currentThread();
                Thread.interrupted();
            }
            bl = false;
            try {
                l = this.ready.take();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        } while (bl);
        this.pool.get(l).terminate();
        this.pool.remove(l);
        return true;
    }

    public int removeThreads(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Number of threads to remove must be a positive integer");
        }
        if (this.poolAttenuationDelay > 0L) {
            if (System.currentTimeMillis() < this.poolAttenuationSchedule) {
                return 0;
            }
            this.poolAttenuationSchedule = System.currentTimeMillis() + this.poolAttenuationDelay;
        }
        for (n2 = 0; n2 < n && this.removeThread(); ++n2) {
        }
        this.printDebug(n2 + " thread(s) removed");
        return n2;
    }

    public void killThread(long l) {
    }

    public synchronized boolean getDebugMode() {
        return this.debug;
    }

    public synchronized boolean setDebugMode(boolean bl) {
        boolean bl2 = this.debug;
        this.debug = bl;
        return bl2;
    }

    private void printDebug(String string) {
        if (this.debug) {
            System.out.println("com.internationalnetwork.lang.DynamicThreadPool:  " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicThread[] getThreads() {
        ConcurrentHashMap<Long, DynamicThread> concurrentHashMap = this.pool;
        synchronized (concurrentHashMap) {
            return this.pool.values().toArray(new DynamicThread[0]);
        }
    }

    public DynamicThread getDynamicThread(long l) {
        return this.pool.get(l);
    }

    public Object popSkulker() {
        if (this.managerThread == null) {
            throw new IllegalThreadStateException("Manager thread not started");
        }
        if (this.skulkerThread == null) {
            throw new IllegalThreadStateException("Skulker thread not defined");
        }
        boolean bl = false;
        Object object = null;
        do {
            if (bl) {
                Thread.currentThread();
                Thread.interrupted();
            }
            bl = false;
            try {
                object = this.skulkerQueue.take();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        } while (bl);
        return object;
    }

    public void pushSkulker(Object ... objectArray) {
        if (this.managerThread == null) {
            throw new IllegalThreadStateException("Manager thread not started");
        }
        if (this.skulkerThread == null) {
            throw new IllegalThreadStateException("Skulker thread not defined");
        }
        boolean bl = false;
        for (Object object : objectArray) {
            do {
                if (bl) {
                    Thread.currentThread();
                    Thread.interrupted();
                }
                bl = false;
                try {
                    this.skulkerQueue.put(object);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _terminate(long l) {
        boolean bl = false;
        DynamicThread dynamicThread = this.pool.get(l);
        if (dynamicThread == null || dynamicThread.isTerminating()) {
            return true;
        }
        if (dynamicThread.getDispatchCount() >= this.maximumDispatches || dynamicThread.getExceptionCount() > this.maximumExceptions) {
            if (this.resetFinalDispatch) {
                dynamicThread.setPriority(this.resetPriority);
                ((ReRunnable)dynamicThread.getTarget()).reset();
                dynamicThread.setPriority(this.poolPriority);
            }
            do {
                if (bl) {
                    Thread.currentThread();
                    Thread.interrupted();
                }
                bl = false;
                try {
                    this.dead.put(l);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            } while (bl);
            this.managerThread.interrupt();
            return true;
        }
        dynamicThread.setPriority(this.resetPriority);
        ((ReRunnable)dynamicThread.getTarget()).reset();
        dynamicThread.setPriority(this.poolPriority);
        HashSet<Long> hashSet = this.active;
        synchronized (hashSet) {
            this.active.remove(l);
        }
        do {
            if (bl) {
                Thread.currentThread();
                Thread.interrupted();
            }
            bl = false;
            try {
                this.ready.put(l);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        } while (bl);
        this.managerThread.interrupt();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        this.printDebug("Manager started / threadID=" + Thread.currentThread().getId());
        while (true) {
            Long l;
            int n;
            Thread.yield();
            int n2 = this.pool.size();
            if (n2 < this.minimumThreads) {
                this.addThreads(this.minimumThreads - n2);
            }
            if ((n = this.ready.size()) < this.minimumSpareThreads) {
                this.addThreads(this.minimumSpareThreads - n > this.spareThreadIncrement ? this.minimumSpareThreads - n : this.spareThreadIncrement);
            } else if (n > this.maximumSpareThreads) {
                this.removeThread();
            }
            this.printDebug("Manager waiting for dead threads...");
            try {
                if (bl2 || this.poolMaintenanceDelay == 0L) {
                    bl2 = false;
                    l = this.dead.take();
                } else {
                    l = this.dead.poll(this.poolAttenuationDelay, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            if (l == null) {
                if (this.active.size() == 0) {
                    this.removeThreads(this.maximumSpareThreads);
                    bl2 = true;
                    continue;
                }
                if (this.removeThreads(this.poolAttenuationDecay) != 0) continue;
                bl2 = true;
                continue;
            }
            Serializable serializable = this.active;
            synchronized (serializable) {
                this.active.remove(l);
            }
            serializable = this.pool;
            synchronized (serializable) {
                this.pool.remove(l);
            }
        }
    }
}

