/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.lang;

import com.internationalnetwork.lang.DynamicThreadPool;

public final class DynamicThread<Target extends Runnable>
extends Thread {
    public static final String VERSION = "1.00";
    private Boolean suspended = true;
    private final Target target;
    private String status = "Manager: Ready for dispatch";
    private long dispatchCount = 0L;
    private long exceptionCount = 0L;
    private final DynamicThreadPool pool;
    private final long poolID;
    private long threadID = -1L;
    private volatile boolean running = false;
    private volatile boolean terminated = false;

    private DynamicThread() {
        this.target = null;
        this.pool = null;
        this.poolID = -1L;
    }

    public DynamicThread(DynamicThreadPool dynamicThreadPool, long l, ThreadGroup threadGroup, Target Target, String string, long l2) {
        super(threadGroup, (Runnable)Target, string, l2);
        super.start();
        this.pool = dynamicThreadPool;
        this.poolID = l;
        this.target = Target;
    }

    public DynamicThreadPool getPool() {
        return this.pool;
    }

    public long getPoolID() {
        return this.poolID;
    }

    public Thread getThread() {
        if (super.isAlive()) {
            return Thread.currentThread();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getThreadID() {
        if (this.threadID == -1L) {
            DynamicThread dynamicThread = this;
            synchronized (dynamicThread) {
                this.threadID = Thread.currentThread().getId();
            }
        }
        return this.threadID;
    }

    public Target getTarget() {
        return this.target;
    }

    public synchronized String getStatus() {
        return this.status;
    }

    public synchronized String setStatus(String string) {
        String string2 = this.status;
        this.status = string;
        return string2;
    }

    public synchronized long getDispatchCount() {
        return this.dispatchCount;
    }

    public synchronized long getExceptionCount() {
        return this.exceptionCount;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized boolean isTerminating() {
        return this.terminated;
    }

    @Override
    public synchronized void start() {
        this.suspended = false;
        this.notify();
    }

    public synchronized void terminate() {
        this.terminated = true;
        this.suspended = false;
        this.notify();
    }

    @Override
    public synchronized void run() {
        while (true) {
            if (this.suspended.booleanValue()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (this.terminated) {
                this.pool._terminate(this.poolID);
                break;
            }
            this.running = true;
            ++this.dispatchCount;
            try {
                super.run();
            }
            catch (Error error) {
                error.printStackTrace();
                ++this.exceptionCount;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                ++this.exceptionCount;
            }
            this.running = false;
            this.suspended = !this.terminated;
            if (this.pool._terminate(this.poolID)) break;
        }
        this.terminated = true;
        long l = this.pool.getThreadDestructionDelay();
        if (l > 0L) {
            Thread.currentThread();
            Thread.interrupted();
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

