/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.gui.sql;

import java.awt.Dimension;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ViewTable
extends JScrollPane
implements TableModel {
    public static final String VERSION = "1.00";
    public static final String DESCRIPTION = "ICELawFM v1.00 by Randolf Richardson, in beautiful British Columbia, Canada.\nCopyright (C) 2010 Inter-Corporate Computer & Network Services, Inc.\nAll rights reserved.  http://www.inter-corporate.com/\n";
    private final ResultSet query;
    private final String[] col;
    private final String[] colName;
    private final Class[] colClass;
    private JTable jTable;
    private int maxRows;

    private ViewTable() {
        throw new RuntimeException();
    }

    public ViewTable(ResultSet resultSet, String ... stringArray) throws SQLException {
        this.query = resultSet;
        this.col = new String[stringArray.length / 2];
        this.colName = new String[stringArray.length / 2];
        this.colClass = new Class[stringArray.length / 2];
        resultSet.last();
        this.maxRows = resultSet.getRow();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.col[n] = stringArray[n2++];
            this.colName[n] = stringArray[n2++] == null ? this.col[n] : stringArray[n2 - 1];
            this.colClass[n] = resultSet.getObject(this.col[n]).getClass();
            ++n;
        }
        this.jTable = new JTable(this);
        this.jTable.setFillsViewportHeight(true);
        this.setViewportView(this.jTable);
        this.jTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), new ActionMap());
    }

    public void setSelectionMode(int n) {
        this.jTable.setSelectionMode(n);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        Dimension dimension2 = this.getParent().getSize();
        return new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
    }

    public void setMinimumSize(int n, int n2) {
        this.setMinimumSize(new Dimension(n, n2));
    }

    public JTable getJTable() {
        return this.jTable;
    }

    @Override
    public int getRowCount() {
        return this.maxRows;
    }

    @Override
    public int getColumnCount() {
        return this.col.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            this.query.absolute(n + 1);
            Object object = this.query.getObject(this.col[n2]);
            return object == null ? null : object.toString();
        }
        catch (SQLException sQLException) {
            return sQLException.toString();
        }
    }

    public Class getColumnClass(int n) {
        return this.colClass[n];
    }

    @Override
    public String getColumnName(int n) {
        return this.colName[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
    }

    public ResultSet getRow(int n) throws SQLException {
        this.query.absolute(n + 1);
        return this.query;
    }

    public int getPreferredColumnWidth(int n) {
        return this.jTable.getColumnModel().getColumn(n).getPreferredWidth();
    }

    public void setPreferredColumnWidth(int n, int n2) {
        this.jTable.getColumnModel().getColumn(n).setPreferredWidth(n2);
    }
}

