/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.gui;

import com.internationalnetwork.gui.JTextFieldLimit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class Login
implements ActionListener,
KeyListener,
MouseListener,
WindowListener {
    private static String imageRoot = "com/internationalnetwork/gui/images/";
    public static final String VERSION = "1.01";
    private Thread thread = new Thread();
    private char action;
    private boolean returnStatus;
    private StringBuilder loginName = new StringBuilder();
    private StringBuilder password = new StringBuilder();
    private int loginNamePolicyMinimumLength = 1;
    private int loginNamePolicyMaximumLength = 64;
    private int passwordPolicyMinimumLength = 0;
    private int passwordPolicyMaximumLength = 127;
    private Method loginMethod;
    private Method helpMethod;
    private JFrame jFramePrompt = new JFrame();
    private JTextField jTextFieldLoginName = new JTextField(32);
    private JPasswordField jTextFieldPassword = new JPasswordField(32);
    private JLabel jLabelLoginName;
    private JLabel jLabelPassword;
    private JButton jButtonLogin;
    private JButton jButtonHelp;
    private JButton jButtonExit;
    private String iconPromptFrame = imageRoot + "a.gif";
    private String textPromptFrame = "Login";
    private String iconLoginBanner = imageRoot + "login.jpg";
    private String textLoginNameLabel = "<html>Login <u>n</u>ame:</html>";
    private String textPasswordLabel = "<html><u>P</u>assword:</html>";
    private String textLoginButton = "<html><u>L</u>ogin</html>";
    private String textHelpButton = "<html><u>H</u>elp</html>";
    private String textExitButton = "<html>E<u>x</u>it</html>";
    private String iconLoginNameLabel = imageRoot + "user.gif";
    private String iconPasswordLabel = imageRoot + "lock.gif";
    private String iconLoginButton = imageRoot + "logs.gif";
    private String iconHelpButton = imageRoot + "help.gif";
    private String iconExitButton = imageRoot + "exit.gif";

    public Login() {
    }

    public Login(String string) {
        this.setPromptTitle(string);
    }

    protected void finalize() {
        if (this.loginName.length() > 0) {
            this.loginName.replace(0, this.loginName.length() - 1, " ");
        }
        if (this.password.length() > 0) {
            this.password.replace(0, this.password.length() - 1, " ");
        }
    }

    public char getAction() {
        return this.action;
    }

    public String getExitButtonIcon() {
        return this.iconExitButton;
    }

    public Login setExitButtonIcon(String string) {
        this.iconExitButton = string;
        return this;
    }

    public String getExitButtonLabel() {
        return this.textExitButton;
    }

    public Login setExitButtonLabel(String string) {
        this.textExitButton = string == null ? "" : string;
        return this;
    }

    public String getHelpButtonIcon() {
        return this.iconHelpButton;
    }

    public Login setHelpButtonIcon(String string) {
        this.iconHelpButton = string;
        return this;
    }

    public String getHelpButtonLabel() {
        return this.textHelpButton;
    }

    public Login setHelpButtonLabel(String string) {
        this.textHelpButton = string == null ? "" : string;
        return this;
    }

    public Login setHelpMethod(String string, String string2) {
        try {
            this.helpMethod = Class.forName(string).getMethod(string2, String.class);
        }
        catch (Throwable throwable) {
            System.err.println("Exception:  " + throwable);
        }
        return this;
    }

    public String getLoginBanner() {
        return this.iconLoginBanner;
    }

    public Login setLoginBanner(String string) {
        this.iconLoginBanner = string;
        return this;
    }

    public String getLoginButtonIcon() {
        return this.iconLoginButton;
    }

    public Login setLoginButtonIcon(String string) {
        this.iconLoginButton = string;
        return this;
    }

    public String getLoginButtonLabel() {
        return this.textLoginButton;
    }

    public Login setLoginButtonLabel(String string) {
        this.textLoginButton = string == null ? "" : string;
        return this;
    }

    public Login setLoginMethod(String string, String string2) {
        try {
            this.loginMethod = Class.forName(string).getMethod(string2, String.class, String.class);
        }
        catch (Throwable throwable) {
            System.err.println("Exception:  " + throwable);
        }
        return this;
    }

    public String getLoginName() {
        return this.loginName.toString();
    }

    public Login setLoginName(String string) {
        if (string == null) {
            return this;
        }
        if (this.loginName.length() > 0) {
            this.loginName.replace(0, this.loginName.length() - 1, " ");
        }
        this.loginName = new StringBuilder(string);
        return this;
    }

    public String getLoginNameIcon() {
        return this.iconLoginNameLabel;
    }

    public Login setLoginNameIcon(String string) {
        this.iconLoginNameLabel = string;
        return this;
    }

    public String getLoginNameLabel() {
        return this.textLoginNameLabel;
    }

    public boolean setLoginNameLabel(String string) {
        if (string == null) {
            return false;
        }
        this.textLoginNameLabel = string;
        return true;
    }

    public int getLoginNamePolicyMaximumLength() {
        return this.loginNamePolicyMaximumLength;
    }

    public Login setLoginNamePolicyMaximumLength(int n) {
        this.loginNamePolicyMaximumLength = n;
        return this;
    }

    public int getLoginNamePolicyMinimumLength() {
        return this.loginNamePolicyMinimumLength;
    }

    public Login setLoginNamePolicyMinimumLength(int n) {
        this.loginNamePolicyMinimumLength = n;
        return this;
    }

    public String getPassword() {
        return this.password.toString();
    }

    public Login setPassword(String string) {
        if (this.password == null) {
            return this;
        }
        if (this.password.length() > 0) {
            this.password.replace(0, this.password.length() - 1, " ");
        }
        this.password = new StringBuilder(string);
        return this;
    }

    public String getPasswordIcon() {
        return this.iconPasswordLabel;
    }

    public Login setPasswordIcon(String string) {
        this.iconPasswordLabel = string;
        return this;
    }

    public String getPasswordLabel() {
        return this.textPasswordLabel;
    }

    public boolean setPasswordLabel(String string) {
        if (string == null) {
            return false;
        }
        this.textPasswordLabel = string;
        return true;
    }

    public int getPasswordPolicyMaximumLength() {
        return this.passwordPolicyMaximumLength;
    }

    public Login setPasswordPolicyMaximumLength(int n) {
        this.passwordPolicyMaximumLength = n;
        return this;
    }

    public int getPasswordPolicyMinimumLength() {
        return this.passwordPolicyMinimumLength;
    }

    public Login setPasswordPolicyMinimumLength(int n) {
        this.passwordPolicyMinimumLength = n;
        return this;
    }

    public boolean getReturnStatus() {
        return this.returnStatus;
    }

    public String getPromptIcon() {
        return this.iconPromptFrame;
    }

    public Login setPromptIcon(String string) {
        this.iconPromptFrame = string == null || string.length() == 0 ? imageRoot + "a.gif" : string;
        return this;
    }

    public String getPromptTitle() {
        return this.textPromptFrame;
    }

    public Login setPromptTitle(String string) {
        this.textPromptFrame = string == null || string.length() == 0 ? "Login" : string;
        return this;
    }

    public boolean prompt() {
        this.thread = Thread.currentThread();
        this.jFramePrompt.setUndecorated(true);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.jFramePrompt.getRootPane().setWindowDecorationStyle(1);
        this.jFramePrompt.setResizable(false);
        this.jFramePrompt.setTitle(this.textPromptFrame);
        this.jFramePrompt.setIconImage(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(this.iconPromptFrame)));
        this.jLabelLoginName = new JLabel(this.textLoginNameLabel, new ImageIcon(ClassLoader.getSystemResource(this.iconLoginNameLabel)), 2);
        this.jTextFieldLoginName.setDocument(new JTextFieldLimit(this.loginNamePolicyMaximumLength));
        if (this.loginName.length() > this.loginNamePolicyMaximumLength) {
            this.loginName.replace(this.loginName.length() - 1, this.loginNamePolicyMaximumLength - 1, " ");
            this.loginName.setLength(this.loginNamePolicyMaximumLength);
        }
        this.jTextFieldLoginName.setText(this.loginName.toString());
        this.jTextFieldLoginName.setCaretPosition(this.loginName.length());
        this.jLabelPassword = new JLabel(this.textPasswordLabel, new ImageIcon(ClassLoader.getSystemResource(this.iconPasswordLabel)), 2);
        this.jTextFieldPassword.setDocument(new JTextFieldLimit(this.passwordPolicyMaximumLength));
        if (this.password.length() > this.passwordPolicyMaximumLength) {
            this.password.replace(this.password.length() - 1, this.passwordPolicyMaximumLength - 1, " ");
            this.password.setLength(this.passwordPolicyMaximumLength);
        }
        this.jTextFieldPassword.setText(this.password.toString());
        this.jTextFieldPassword.setCaretPosition(this.password.length());
        this.jButtonLogin = new JButton(this.textLoginButton, new ImageIcon(ClassLoader.getSystemResource(this.iconLoginButton)));
        this.jButtonHelp = new JButton(this.textHelpButton, new ImageIcon(ClassLoader.getSystemResource(this.iconHelpButton)));
        this.jButtonExit = new JButton(this.textExitButton, new ImageIcon(ClassLoader.getSystemResource(this.iconExitButton)));
        this.jFramePrompt.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.jFramePrompt.add((Component)new JLabel(new ImageIcon(ClassLoader.getSystemResource(this.iconLoginBanner))), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.jFramePrompt.add((Component)this.jLabelLoginName, gridBagConstraints);
        this.jLabelLoginName.addMouseListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        this.jFramePrompt.add((Component)this.jTextFieldLoginName, gridBagConstraints);
        this.jTextFieldLoginName.setFocusAccelerator('n');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jFramePrompt.add((Component)this.jLabelPassword, gridBagConstraints);
        this.jLabelPassword.addMouseListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        this.jTextFieldPassword.setEchoChar('*');
        this.jFramePrompt.add((Component)this.jTextFieldPassword, gridBagConstraints);
        this.jTextFieldPassword.setFocusAccelerator('p');
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.jButtonLogin.setIconTextGap(12);
        this.jButtonHelp.setIconTextGap(12);
        this.jButtonExit.setIconTextGap(12);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add((Component)this.jButtonLogin, gridBagConstraints);
        jPanel.add(new JLabel("  "));
        jPanel.add((Component)this.jButtonHelp, gridBagConstraints);
        jPanel.add(new JLabel("  "));
        jPanel.add((Component)this.jButtonExit, gridBagConstraints);
        this.jFramePrompt.add((Component)jPanel, gridBagConstraints);
        this.jFramePrompt.getRootPane().setDefaultButton(this.jButtonLogin);
        this.jFramePrompt.addWindowListener(this);
        this.jTextFieldLoginName.addKeyListener(this);
        this.jTextFieldPassword.addKeyListener(this);
        this.jButtonLogin.addActionListener(this);
        this.jButtonLogin.addKeyListener(this);
        this.jButtonHelp.addActionListener(this);
        this.jButtonHelp.addKeyListener(this);
        this.jButtonExit.addActionListener(this);
        this.jButtonExit.addKeyListener(this);
        this.jFramePrompt.pack();
        Dimension dimension = this.jFramePrompt.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(this.jFramePrompt.getGraphicsConfiguration());
        dimension2.width -= insets.left + insets.right;
        dimension2.width /= 2;
        dimension2.height -= insets.top + insets.bottom;
        dimension2.height /= 2;
        this.jFramePrompt.setLocation(dimension2.width - dimension.width / 2, dimension2.height - dimension.height / 2);
        dimension.width += 8;
        dimension.height += 8;
        this.jFramePrompt.setSize(dimension);
        if (this.loginName.length() > 0) {
            this.jTextFieldPassword.grabFocus();
        }
        this.jFramePrompt.setVisible(true);
        try {
            while (true) {
                Thread.sleep(Integer.MAX_VALUE);
            }
        }
        catch (InterruptedException interruptedException) {
            if (this.loginName.length() > 0) {
                this.loginName.replace(0, this.loginName.length() - 1, " ");
            }
            this.loginName = new StringBuilder(this.jTextFieldLoginName.getText());
            if (this.password.length() > 0) {
                this.password.replace(0, this.password.length() - 1, " ");
            }
            this.password = new StringBuilder(new String(this.jTextFieldPassword.getPassword()));
            this.jFramePrompt.dispose();
            switch (this.action) {
                case 'L': {
                    if (this.loginMethod == null) {
                        this.returnStatus = true;
                        break;
                    }
                    try {
                        this.returnStatus = (Boolean)this.loginMethod.invoke((Object)this.loginMethod, this.loginName, this.password);
                    }
                    catch (Throwable throwable) {
                        System.err.println("Error calling loginMethod (" + this.loginMethod.toString() + "):  " + throwable);
                        this.returnStatus = false;
                    }
                    break;
                }
                case 'X': {
                    this.returnStatus = false;
                    break;
                }
                default: {
                    System.out.println("Application error!");
                    this.action = (char)69;
                    this.returnStatus = false;
                }
            }
            return this.returnStatus;
        }
    }

    public String[] prompt(String string) {
        String[] stringArray = new String[string.length()];
        long l = System.currentTimeMillis();
        boolean bl = this.prompt();
        l = System.currentTimeMillis() - l;
        int n = 0;
        block6: for (char c : string.toCharArray()) {
            switch (c) {
                case 'l': {
                    stringArray[n++] = this.getLoginName();
                    continue block6;
                }
                case 'p': {
                    stringArray[n++] = this.getPassword();
                    continue block6;
                }
                case 'r': {
                    stringArray[n++] = bl ? "" : null;
                    continue block6;
                }
                case 't': {
                    stringArray[n++] = "" + l;
                    continue block6;
                }
                default: {
                    stringArray[n++] = null;
                }
            }
        }
        return stringArray;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.jButtonLogin) {
            this.performLogin();
        } else if (jButton == this.jButtonHelp) {
            this.performHelp();
        } else if (jButton == this.jButtonExit) {
            this.performExit();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        String string = KeyEvent.getModifiersExText(keyEvent.getModifiersEx()) + KeyEvent.getKeyText(keyEvent.getKeyCode());
        if (string.equals("Escape")) {
            this.performExit();
        } else if (string.equals("Down")) {
            this.cursorDown();
        } else if (string.equals("Up")) {
            this.cursorUp();
        } else if (string.equals("Page Down")) {
            this.cursorDown();
        } else if (string.equals("Page Up")) {
            this.cursorUp();
        } else if (string.equals("Left")) {
            this.cursorLeft();
        } else if (string.equals("Right")) {
            this.cursorRight();
        } else if (string.equals("CtrlHome")) {
            this.cursorCTRLHome();
        } else if (string.equals("CtrlEnd")) {
            this.cursorCTRLEnd();
        } else if (string.equals("F1")) {
            this.performHelp();
        } else if (string.equals("AltL")) {
            this.performLogin();
        } else if (string.equals("AltH")) {
            this.performHelp();
        } else if (string.equals("AltX")) {
            this.performExit();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        if (this.jLabelLoginName == jLabel) {
            this.jTextFieldLoginName.grabFocus();
        } else if (this.jLabelPassword == jLabel) {
            this.jTextFieldPassword.grabFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.performExit();
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    private void performLogin() {
        if (this.jTextFieldLoginName.getText().length() < this.loginNamePolicyMinimumLength) {
            this.jTextFieldLoginName.grabFocus();
        } else if (new String(this.jTextFieldPassword.getPassword()).length() < this.passwordPolicyMinimumLength) {
            this.jTextFieldPassword.grabFocus();
        } else {
            this.jFramePrompt.setVisible(false);
            this.jFramePrompt.removeNotify();
            this.action = (char)76;
            this.thread.interrupt();
        }
    }

    private void performHelp() {
        this.action = (char)72;
        String string = "unknown,index";
        if (this.jTextFieldLoginName.hasFocus()) {
            string = "input,login name";
        } else if (this.jTextFieldPassword.hasFocus()) {
            string = "input,password";
        } else if (this.jButtonLogin.hasFocus()) {
            string = "button,login";
        } else if (this.jButtonExit.hasFocus()) {
            string = "button,exit";
        } else if (this.jButtonHelp.hasFocus()) {
            string = "button,help";
        }
        if (this.helpMethod != null) {
            try {
                this.helpMethod.invoke((Object)this.helpMethod, string);
            }
            catch (Throwable throwable) {
                System.err.println("Error calling helpMethod (" + this.helpMethod.toString() + "):  " + throwable);
            }
        }
    }

    private void performExit() {
        this.jFramePrompt.setVisible(false);
        this.jFramePrompt.removeNotify();
        this.action = (char)88;
        this.thread.interrupt();
    }

    private void cursorDown() {
        if (this.jTextFieldPassword.hasFocus()) {
            this.jButtonLogin.grabFocus();
        } else if (this.jTextFieldLoginName.hasFocus()) {
            this.jTextFieldPassword.grabFocus();
        }
    }

    private void cursorUp() {
        if (this.jTextFieldPassword.hasFocus()) {
            this.jTextFieldLoginName.grabFocus();
        } else if (this.jButtonLogin.hasFocus() || this.jButtonHelp.hasFocus() || this.jButtonExit.hasFocus()) {
            this.jTextFieldPassword.grabFocus();
        }
    }

    private void cursorLeft() {
        if (this.jButtonHelp.hasFocus()) {
            this.jButtonLogin.grabFocus();
        } else if (this.jButtonExit.hasFocus()) {
            this.jButtonHelp.grabFocus();
        }
    }

    private void cursorRight() {
        if (this.jButtonHelp.hasFocus()) {
            this.jButtonExit.grabFocus();
        } else if (this.jButtonLogin.hasFocus()) {
            this.jButtonHelp.grabFocus();
        }
    }

    private void cursorCTRLHome() {
        this.jTextFieldLoginName.setCaretPosition(0);
        this.jTextFieldLoginName.grabFocus();
    }

    private void cursorCTRLEnd() {
        this.jTextFieldPassword.setCaretPosition(new String(this.jTextFieldPassword.getPassword()).length());
        this.jTextFieldPassword.grabFocus();
    }

    public static void main(String[] stringArray) {
        System.out.println("Commencing login prompt example...");
        Login login = new Login();
        login.setPromptTitle("Login prompt example");
        login.setHelpMethod("com.internationalnetwork.gui.Login", "mainCallbackHelpExample");
        login.setLoginMethod("com.internationalnetwork.gui.Login", "mainCallbackLoginExample");
        switch (stringArray.length) {
            case 0: {
                break;
            }
            case 2: {
                login.setPassword(stringArray[1]);
            }
            case 1: {
                login.setLoginName(stringArray[0]);
                break;
            }
            default: {
                System.err.println("Too many parameters.");
                System.exit(-1);
            }
        }
        if (login.prompt()) {
            System.out.println("Now logging in as " + login.getLoginName() + "...");
        } else {
            switch (login.getAction()) {
                case 'L': {
                    System.err.println("Login unsuccessful (hint: try \"password\" as the password).");
                    break;
                }
                default: {
                    System.err.println("Login aborted.");
                }
            }
        }
    }

    public static void mainCallbackHelpExample(String string) {
        System.out.println("[ Help call-back was successful / code = " + string + " ]");
    }

    public static boolean mainCallbackLoginExample(String string, String string2) {
        return string2.equals("password");
    }
}

