/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.gui;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;

public class JListenerEvent {
    public static final String VERSION = "1.00";
    private final ActionEvent actionEvent;
    private final KeyEvent keyEvent;
    private final MenuEvent menuEvent;
    private final MenuKeyEvent menuKeyEvent;
    private final MouseEvent mouseEvent;
    private final WindowEvent windowEvent;
    private final int eventID;

    private JListenerEvent() {
        throw new RuntimeException();
    }

    public JListenerEvent(ActionEvent actionEvent) {
        this.actionEvent = actionEvent;
        this.keyEvent = null;
        this.menuEvent = null;
        this.menuKeyEvent = null;
        this.mouseEvent = null;
        this.windowEvent = null;
        this.eventID = actionEvent.getID();
    }

    public JListenerEvent(KeyEvent keyEvent) {
        this.actionEvent = null;
        this.keyEvent = keyEvent;
        this.menuEvent = null;
        this.menuKeyEvent = null;
        this.mouseEvent = null;
        this.windowEvent = null;
        this.eventID = keyEvent.getID();
    }

    public JListenerEvent(MenuEvent menuEvent) {
        this.actionEvent = null;
        this.keyEvent = null;
        this.menuEvent = menuEvent;
        this.menuKeyEvent = null;
        this.mouseEvent = null;
        this.windowEvent = null;
        this.eventID = 0;
    }

    public JListenerEvent(MenuKeyEvent menuKeyEvent) {
        this.actionEvent = null;
        this.keyEvent = null;
        this.menuEvent = null;
        this.menuKeyEvent = menuKeyEvent;
        this.mouseEvent = null;
        this.windowEvent = null;
        this.eventID = menuKeyEvent.getID();
    }

    public JListenerEvent(MouseEvent mouseEvent) {
        this.actionEvent = null;
        this.keyEvent = null;
        this.menuEvent = null;
        this.menuKeyEvent = null;
        this.mouseEvent = mouseEvent;
        this.windowEvent = null;
        this.eventID = mouseEvent.getID();
    }

    public JListenerEvent(WindowEvent windowEvent) {
        this.actionEvent = null;
        this.keyEvent = null;
        this.menuEvent = null;
        this.menuKeyEvent = null;
        this.mouseEvent = null;
        this.windowEvent = windowEvent;
        this.eventID = windowEvent.getID();
    }

    public boolean isActionEvent() {
        return this.actionEvent != null;
    }

    public boolean isKeyEvent() {
        return this.keyEvent != null;
    }

    public boolean isMenuEvent() {
        return this.menuEvent != null;
    }

    public boolean isMenuKeyEvent() {
        return this.menuKeyEvent != null;
    }

    public boolean isMouseEvent() {
        return this.mouseEvent != null;
    }

    public boolean isWindowEvent() {
        return this.windowEvent != null;
    }

    public int getID() {
        return this.eventID;
    }

    public char getType() {
        if (this.actionEvent != null) {
            return 'a';
        }
        if (this.keyEvent != null) {
            return 'k';
        }
        if (this.menuKeyEvent != null) {
            return 'K';
        }
        if (this.menuEvent != null) {
            return 'M';
        }
        if (this.mouseEvent != null) {
            return 'm';
        }
        if (this.windowEvent != null) {
            return 'w';
        }
        throw new RuntimeException("Invalid Event type due to internal error");
    }

    public Object getSource() {
        if (this.actionEvent != null) {
            return this.actionEvent.getSource();
        }
        if (this.keyEvent != null) {
            return this.keyEvent.getSource();
        }
        if (this.menuKeyEvent != null) {
            return this.menuKeyEvent.getSource();
        }
        if (this.menuEvent != null) {
            return this.menuEvent.getSource();
        }
        if (this.mouseEvent != null) {
            return this.mouseEvent.getSource();
        }
        if (this.windowEvent != null) {
            return this.windowEvent.getSource();
        }
        throw new RuntimeException("Invalid Event type due to internal error");
    }

    public AWTEvent getAWTEvent() {
        if (this.actionEvent != null) {
            return this.actionEvent;
        }
        if (this.keyEvent != null) {
            return this.keyEvent;
        }
        if (this.menuKeyEvent != null) {
            return this.menuKeyEvent;
        }
        if (this.menuEvent != null) {
            return null;
        }
        if (this.mouseEvent != null) {
            return this.mouseEvent;
        }
        if (this.windowEvent != null) {
            return this.windowEvent;
        }
        throw new RuntimeException("Invalid Event type due to internal error");
    }

    public ActionEvent getActionEvent() {
        return this.actionEvent;
    }

    public KeyEvent getKeyEvent() {
        return this.keyEvent;
    }

    public MenuEvent getMenuEvent() {
        return this.menuEvent;
    }

    public MenuKeyEvent getMenuKeyEvent() {
        return this.menuKeyEvent;
    }

    public MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    public WindowEvent getWindowEvent() {
        return this.windowEvent;
    }

    public boolean consume() {
        if (this.keyEvent != null) {
            this.keyEvent.consume();
            return true;
        }
        if (this.mouseEvent != null) {
            this.mouseEvent.consume();
            return true;
        }
        return false;
    }
}

