/*
 * Decompiled with CFR 0.152.
 */
package com.internationalnetwork.gui;

import com.internationalnetwork.gui.JListenerEvent;
import com.internationalnetwork.util.ArrayTools;
import com.internationalnetwork.util.StringParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JComponent;

public class GridBag<Type extends Container> {
    public static final String VERSION = "1.00";
    public static final String DESCRIPTION = "GridBag v1.00 by Randolf Richardson, in beautiful British Columbia, Canada.\nCopyright (C) 2010 Inter-Corporate Computer & Network Services, Inc.\nAll rights reserved.  http://www.inter-corporate.com/\n";
    private static final String[] KEYS = new String[]{"", "gridx", "x", "col", "gridy", "y", "row", "gridwidth", "colspan", "gridheight", "rowspan", "fill", "ipadx", "ipady", "ipad", "insets", "anchor", "gravity", "align", "weightx", "weighty", "weight", "move", "bgcolour", "bgcolor", "fgcolour", "fgcolor", "ref", "track"};
    private static final String[] ANCHORS = new String[]{"above_baseline=1024", "above_baseline_leading=1280", "above_baseline_trailing=1536", "baseline=256", "baseline_leading=512", "baseline_trailing=768", "below_baseline=1792", "below_baseline_leading=2048", "below_baseline_trailing=2304", "both=1", "center=10", "centre=10", "east=13", "first_line_end=24", "first_line_start=23", "horizontal=2", "last_line_end=26", "last_line_start=25", "line_end=22", "line_start=21", "none=0", "north=11", "northeast=12", "northwest=18", "page_end=20", "page_start=19", "relative=-1", "remainder=0", "south=15", "southeast=14", "southwest=16", "vertical=3", "west=17", "left=17", "right=13", "top=11", "bottom=15"};
    private final Type container;
    private final GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints c;
    private Color bgColour = null;
    private Color fgColour = null;
    private String track = null;
    private HashMap<String, Component[]> compMap = new HashMap();
    private Character ref = null;
    private HashMap<Component, Character> refMap = new HashMap();

    private GridBag() {
        throw new RuntimeException();
    }

    public GridBag(Type Type2) {
        this.container = Type2;
        this.c = new GridBagConstraints();
        this.c.gridy = 0;
        this.c.gridx = 0;
        ((Container)Type2).setLayout(this.layout);
    }

    public GridBag(Type Type2, String ... stringArray) {
        this.container = Type2;
        this.c = new GridBagConstraints();
        this.c.gridy = 0;
        this.c.gridx = 0;
        ((Container)Type2).setLayout(this.layout);
        if (stringArray.length > 0) {
            this.set(stringArray);
            if (this.ref != null) {
                this.refMap.put((Component)Type2, this.ref);
                this.ref = null;
            }
        }
    }

    public GridBag(Type Type2, GridBagConstraints gridBagConstraints) {
        this.container = Type2;
        this.c = (GridBagConstraints)gridBagConstraints.clone();
        this.c.gridy = 0;
        this.c.gridx = 0;
        ((Container)Type2).setLayout(this.layout);
    }

    public Type getContainer() {
        return this.container;
    }

    public GridBagLayout getLayout() {
        return this.layout;
    }

    public GridBagConstraints getConstraints() {
        return this.c;
    }

    public GridBag setConstraints(GridBagConstraints gridBagConstraints) {
        this.c = (GridBagConstraints)gridBagConstraints.clone();
        return this;
    }

    public GridBag set(String ... stringArray) {
        for (String string : stringArray) {
            String[] stringArray2 = StringParser.splitPairs(string, KEYS);
            block26: for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i] == null) continue;
                switch (i) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.c.gridx = StringParser.parseInt(stringArray2[i], -2, "relative=-1");
                        if (this.c.gridx != -2) continue block26;
                        throw new RuntimeException("Invalid value - gridx=" + stringArray2[i]);
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        this.c.gridy = StringParser.parseInt(stringArray2[i], -2, "relative=-1");
                        if (this.c.gridy != -2) continue block26;
                        throw new RuntimeException("Invalid value - gridy=" + stringArray2[i]);
                    }
                    case 7: 
                    case 8: {
                        this.c.gridwidth = StringParser.parseInt(stringArray2[i], 1, "remainder=0", "relative=-1");
                        continue block26;
                    }
                    case 9: 
                    case 10: {
                        this.c.gridheight = StringParser.parseInt(stringArray2[i], 1, "remainder=0", "relative=-1");
                        continue block26;
                    }
                    case 11: {
                        if (stringArray2[i].equals("none")) {
                            this.c.fill = 0;
                            continue block26;
                        }
                        if (stringArray2[i].equals("h") || stringArray2[i].equals("horizontal")) {
                            this.c.fill = 2;
                            continue block26;
                        }
                        if (stringArray2[i].equals("v") || stringArray2[i].equals("vertical")) {
                            this.c.fill = 3;
                            continue block26;
                        }
                        if (stringArray2[i].equals("hv") || stringArray2[i].equals("vh") || stringArray2[i].equals("both")) {
                            this.c.fill = 1;
                            continue block26;
                        }
                        throw new RuntimeException("Invalid value - fill=" + stringArray2[i]);
                    }
                    case 12: {
                        this.c.ipadx = Integer.parseInt(stringArray2[i]);
                        continue block26;
                    }
                    case 13: {
                        this.c.ipady = Integer.parseInt(stringArray2[i]);
                        continue block26;
                    }
                    case 14: {
                        this.c.ipadx = this.c.ipady = Integer.parseInt(stringArray2[i]);
                        continue block26;
                    }
                    case 15: {
                        String[] stringArray3 = stringArray2[i].split(",");
                        switch (stringArray3.length) {
                            case 4: {
                                this.c.insets = new Insets(Integer.parseInt(stringArray3[0]), Integer.parseInt(stringArray3[1]), Integer.parseInt(stringArray3[2]), Integer.parseInt(stringArray3[3]));
                                continue block26;
                            }
                            case 2: {
                                int n = Integer.parseInt(stringArray3[0]);
                                int n2 = Integer.parseInt(stringArray3[1]);
                                this.c.insets = new Insets(n, n2, n, n2);
                                continue block26;
                            }
                            case 1: {
                                int n = Integer.parseInt(stringArray3[0]);
                                this.c.insets = new Insets(n, n, n, n);
                                continue block26;
                            }
                        }
                        throw new RuntimeException("Invalid value - insets=" + stringArray2[i]);
                    }
                    case 16: 
                    case 17: 
                    case 18: {
                        this.c.anchor = StringParser.parseInt(stringArray2[i], -2, ANCHORS);
                        continue block26;
                    }
                    case 19: {
                        this.c.weightx = Double.parseDouble(stringArray2[i]);
                        continue block26;
                    }
                    case 20: {
                        this.c.weighty = Double.parseDouble(stringArray2[i]);
                        continue block26;
                    }
                    case 21: {
                        this.c.weightx = this.c.weighty = Double.parseDouble(stringArray2[i]);
                        continue block26;
                    }
                    case 22: {
                        if (stringArray2[i].equals("x--")) {
                            this.c.gridx = this.c.gridx - (this.c.gridx > 0 ? 1 : 0);
                            continue block26;
                        }
                        if (stringArray2[i].equals("x++")) {
                            ++this.c.gridx;
                            continue block26;
                        }
                        if (stringArray2[i].equals("y--")) {
                            this.c.gridy = this.c.gridy - (this.c.gridy > 0 ? 1 : 0);
                            continue block26;
                        }
                        if (stringArray2[i].equals("y++")) {
                            ++this.c.gridy;
                            continue block26;
                        }
                        if (stringArray2[i].equals("cr")) {
                            this.nextCR();
                            continue block26;
                        }
                        throw new RuntimeException("Invalid value - move=" + stringArray2[i]);
                    }
                    case 23: 
                    case 24: {
                        if (stringArray2[i].equals("default")) {
                            this.bgColour = null;
                            continue block26;
                        }
                        if (stringArray2[i].length() == 6) {
                            this.bgColour = new Color(Integer.valueOf(stringArray2[i], 16), false);
                            continue block26;
                        }
                        if (stringArray2[i].length() == 8) {
                            this.bgColour = new Color(Integer.valueOf(stringArray2[i], 16), true);
                            continue block26;
                        }
                        throw new RuntimeException("Invalid value - bgcolour=" + stringArray2[i]);
                    }
                    case 25: 
                    case 26: {
                        if (stringArray2[i].equals("default")) {
                            this.fgColour = null;
                            continue block26;
                        }
                        if (stringArray2[i].length() == 6) {
                            this.fgColour = new Color(Integer.valueOf(stringArray2[i], 16), false);
                            continue block26;
                        }
                        if (stringArray2[i].length() == 8) {
                            this.fgColour = new Color(Integer.valueOf(stringArray2[i], 16), true);
                            continue block26;
                        }
                        throw new RuntimeException("Invalid value - fgcolour=" + stringArray2[i]);
                    }
                    case 27: {
                        if (stringArray2[i].equals("null")) {
                            this.ref = null;
                            continue block26;
                        }
                        if (stringArray2[i].length() == 1) {
                            this.ref = Character.valueOf(stringArray2[i].charAt(0));
                            continue block26;
                        }
                        throw new RuntimeException("Invalid value - ref=" + stringArray2[i]);
                    }
                    case 28: {
                        this.track = stringArray2[i];
                    }
                }
            }
        }
        return this;
    }

    public GridBag add(JComponent jComponent, String ... stringArray) {
        if (stringArray.length > 0) {
            this.set(stringArray);
        }
        if (this.bgColour != null) {
            jComponent.setOpaque(true);
            jComponent.setBackground(this.bgColour);
        }
        if (this.fgColour != null) {
            jComponent.setForeground(this.fgColour);
        }
        ((Container)this.container).add((Component)jComponent, this.c);
        if (this.track != null) {
            this.track(jComponent);
        }
        if (this.ref != null) {
            this.refMap.put(jComponent, this.ref);
            this.ref = null;
        }
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        return this;
    }

    public GridBag add(Component component, String ... stringArray) {
        if (stringArray.length > 0) {
            this.set(stringArray);
        }
        if (this.bgColour != null) {
            component.setBackground(this.bgColour);
        }
        if (this.fgColour != null) {
            component.setForeground(this.fgColour);
        }
        ((Container)this.container).add(component, this.c);
        if (this.track != null) {
            this.track(component);
        }
        if (this.ref != null) {
            this.refMap.put(component, this.ref);
            this.ref = null;
        }
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        return this;
    }

    public GridBag removeAll(String ... stringArray) {
        if (stringArray.length > 0) {
            this.set(stringArray);
        }
        ((Container)this.container).remove(0);
        return this;
    }

    private void track(Component component) {
        Component[] componentArray = this.compMap.get(this.track);
        if (componentArray == null || componentArray.length == 0) {
            this.compMap.put(this.track, new Component[]{component});
        } else {
            this.compMap.put(this.track, ArrayTools.join(componentArray, {component}));
        }
        Component[] componentArray2 = this.compMap.get(this.track);
        System.out.println("track=" + this.track + ", length=" + (componentArray2 == null ? null : Integer.valueOf(componentArray2.length)));
        this.track = null;
    }

    public GridBag nextColumn() {
        ++this.c.gridx;
        return this;
    }

    public GridBag nextRow() {
        ++this.c.gridy;
        return this;
    }

    public GridBag nextCR() {
        this.c.gridx = 0;
        ++this.c.gridy;
        return this;
    }

    public char lookup(Component component, char c) {
        Character c2 = this.refMap.get(component);
        return c2 == null ? c : c2.charValue();
    }

    public char lookup(JListenerEvent jListenerEvent, char c, int ... nArray) {
        Character c2;
        if (nArray.length > 0) {
            boolean bl = false;
            int n = jListenerEvent.getID();
            for (int n2 : nArray) {
                if (n != n2) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return c;
            }
        }
        return (c2 = this.refMap.get((Component)jListenerEvent.getSource())) == null ? c : c2.charValue();
    }

    public char lookupKey(JListenerEvent jListenerEvent, char c, int ... nArray) {
        if (nArray.length > 0) {
            boolean bl = false;
            int n = jListenerEvent.getID();
            for (int n2 : nArray) {
                if (n != n2) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return c;
            }
        }
        if (jListenerEvent.getType() != 'k') {
            return this.lookup((Component)jListenerEvent.getSource(), c);
        }
        return jListenerEvent.getKeyEvent().getKeyChar();
    }
}

