/*
 * Decompiled with CFR 0.152.
 */
import com.internationalnetwork.util.conf.ConfigurationDirective;
import com.internationalnetwork.util.conf.ConfigurationResource;
import com.internationalnetwork.util.conf.ContainerRoot;
import com.internationalnetwork.util.conf.Rule;
import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.DelayQueue;
import java.util.regex.Pattern;

public class TreeCopy {
    public static final String VERSION = "1.01";
    public static final String DESCRIPTION = "TreeCopy v1.01 by Randolf Richardson, in beautiful British Columbia, Canada.\nCopyright (C) 2013-2015 Inter-Corporate Computer & Network Services, Inc.\nAll rights reserved.  http://www.inter-corporate.com/products/treecopy\n";
    public static final long JAVASTART = System.currentTimeMillis();
    public static final long NANOSTART = System.nanoTime();
    private static final String CONF_FILENAME = "treecopy.conf";
    private static final ConfigurationResource CONF_RESOURCE = new ConfigurationResource(new Rule("<Copy>", "elements=1", "text", "regex=[a-zA-Z0-9_\\-]+"), new Rule("Source", "scope=Copy", "elements=1", "path"), new Rule("SourceCheck", "scope=Copy", "elements=1..2", "filename", "text", "regex=[a-zA-Z]+", "default=CDEFGHIJKLMNOPQRSTUVWXYZAB"), new Rule("BufferSize", "scope=Copy", "elements=1", "number", "range=1..1073741824", "default=8388608"), new Rule("Criteria", "scope=Copy", "text", "equal=include", "equal=exclude", "text"), new Rule("Target", "scope=Copy", "elements=1", "path"), new Rule("TargetCheck", "scope=Copy", "elements=1..2", "filename", "text", "regex=[a-zA-Z]+", "default=CDEFGHIJKLMNOPQRSTUVWXYZAB"), new Rule("TargetCycle", "scope=Copy", "elements=1", "number"), new Rule("Schedule", "scope=Copy", "elements=2", "text", "number"), new Rule("Logs", "scope=Copy", "elements=1", "path", "require=exist"), new Rule("<Mail>", "elements=1", "text", "regex=[a-zA-Z0-9_\\-]+"), new Rule("From", "scope=Mail", "elements=1", "email"), new Rule("To", "scope=Mail", "elements=1", "email"), new Rule("Subject", "scope=Mail", "elements=1", "text"), new Rule("Host", "scope=Mail", "elements=1", "hostname"), new Rule("Port", "scope=Mail", "elements=1", "number", "range=1..65535", "default=25"), new Rule("AuthUser", "scope=Mail", "elements=1", "text"), new Rule("AuthPass", "scope=Mail", "elements=1", "text"));
    private static final Pattern DATE_PATTERN = Pattern.compile("((\\d{1,4}|[a-zA-Z]{3,9})[-/ .](\\d{1,4}|[a-zA-Z]{3,9})[-/ .](\\d{1,4}|[a-zA-Z]{3,9}))|((\\d{4})(\\d{2}|[a-zA-Z]{3,9})(\\d{2}))");
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private boolean DAEMON = false;
    private String FJOB = null;
    public static final DelayQueue<ScheduledTask> SCHEDULE = new DelayQueue();
    public static ContainerRoot ROOT_CONF;

    public static void main(String ... stringArray) {
        System.out.println(DESCRIPTION);
        try {
            ROOT_CONF = CONF_RESOURCE.processStream(CONF_FILENAME);
        }
        catch (IOException iOException) {
            System.err.println("TreeCopy:  Error reading configuration file.\n" + iOException);
            System.exit(1);
            throw new RuntimeException();
        }
        catch (ParseException parseException) {
            System.err.println("TreeCopy:  Error parsing configuration file.\n" + parseException);
            System.exit(1);
            throw new RuntimeException();
        }
        new TreeCopy(stringArray);
    }

    private TreeCopy() {
        throw new RuntimeException();
    }

    private TreeCopy(String ... stringArray) {
        Object object;
        String string2;
        if (stringArray.length > 0) {
            for (String string2 : stringArray) {
                if (string2.equals("-?") || string2.equals("-h")) {
                    System.out.println("Usage:    TreeCopy [-<sw> [-<sw>...]]");
                    System.out.println(" Note:    Either -d or -f are required");
                    System.out.println();
                    System.out.println("<Switches>");
                    System.out.println("  d: Daemon mode; runs all \"Copy\" operations as per their schedules");
                    System.out.println("  f: Run the specified \"Copy\" operation in the foreground, then exit");
                    System.out.println("  h: This help information (same as -?)");
                    System.exit(0);
                    continue;
                }
                if (string2.startsWith("-d")) {
                    if (this.DAEMON) {
                        System.err.println("TreeCopy:  Daemon mode is already enabled");
                        System.exit(1);
                    }
                    if (this.FJOB != null) {
                        System.err.println("TreeCopy:  This switch is not compatible with Foreground mode");
                        System.exit(1);
                    }
                    this.DAEMON = true;
                    continue;
                }
                if (!string2.startsWith("-f")) continue;
                if (this.DAEMON) {
                    System.err.println("TreeCopy:  This switch is not compatible with Daemon mode");
                    System.exit(1);
                }
                if (this.FJOB != null) {
                    System.err.println("TreeCopy:  Only one foreground \"Copy\" operation may be specified");
                    System.exit(1);
                }
                if (string2.length() > 2) {
                    this.FJOB = string2.substring(2);
                    continue;
                }
                System.err.println("TreeCopy:  Name of \"Copy\" operation not specified");
                System.exit(1);
            }
        }
        if (!this.DAEMON && this.FJOB == null) {
            System.err.println("TreeCopy:  Neither the -d or -f switch was specified");
            System.exit(1);
        }
        ConfigurationDirective configurationDirective = ROOT_CONF.getBranches("Copy")[0];
        String string3 = ROOT_CONF.getAtom("<Copy>", 0);
        String[] stringArray2 = configurationDirective.getAtomsCombined("Source", new int[0]);
        string2 = configurationDirective.getAtom("SourceCheck", 0);
        String string4 = configurationDirective.getAtom("SourceCheck", 1);
        int n = Integer.valueOf(configurationDirective.getAtom("BufferSize", 0));
        String[][] stringArray3 = configurationDirective.getAtoms("Criteria", new int[0]);
        String[] stringArray4 = configurationDirective.getAtomsCombined("Target", new int[0]);
        String string5 = configurationDirective.getAtom("TargetCheck", 0);
        String string6 = configurationDirective.getAtom("TargetCheck", 1);
        String string7 = configurationDirective.getAtom("TargetCycle", 0);
        String[][] stringArray5 = configurationDirective.getAtoms("Schedule", 0, 1);
        String string8 = configurationDirective.getAtom("Logs", 0);
        ConfigurationDirective[] configurationDirectiveArray = configurationDirective.getBranches("Mail");
        for (String[] stringArray6 : stringArray5) {
            if (stringArray6 == null) continue;
            SCHEDULE.add(new ScheduledTask(string3, stringArray6[0], stringArray6[1], stringArray2, string2, string4, n, stringArray3, stringArray4, string5, string6, string7, string8, configurationDirectiveArray));
        }
        if (this.DAEMON) {
            System.out.println("Schedules loaded:  " + SCHEDULE.size());
            if (SCHEDULE.size() == 0) {
                System.err.println("TreeCopy:  No schedules found.  Exiting.");
                return;
            }
            System.out.println("Daemon mode started.");
            while (true) {
                try {
                    while (true) {
                        object = (ScheduledTask)SCHEDULE.take();
                        ((ScheduledTask)object).commence(SCHEDULE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if (this.FJOB != null) {
            while (SCHEDULE.size() > 0) {
                object = (ScheduledTask)SCHEDULE.peek();
                if (this.FJOB.equals(((ScheduledTask)object).getTitle())) {
                    ((ScheduledTask)object).commence(SCHEDULE);
                    return;
                }
                SCHEDULE.remove(object);
            }
            System.err.println("TreeCopy:  Could not find \"Copy\" operation:  " + this.FJOB);
        }
    }

    public static String diffDateTime(LocalDateTime localDateTime, LocalDateTime localDateTime2) {
        long l = ChronoUnit.DAYS.between(localDateTime, localDateTime2);
        String string = String.format("%,d", l);
        long l2 = ChronoUnit.HOURS.between(localDateTime, localDateTime2) - ChronoUnit.DAYS.between(localDateTime, localDateTime2) * 24L;
        long l3 = ChronoUnit.MINUTES.between(localDateTime, localDateTime2) - ChronoUnit.HOURS.between(localDateTime, localDateTime2) * 60L;
        long l4 = ChronoUnit.SECONDS.between(localDateTime, localDateTime2) - ChronoUnit.MINUTES.between(localDateTime, localDateTime2) * 60L;
        long l5 = ChronoUnit.MILLIS.between(localDateTime, localDateTime2) - ChronoUnit.SECONDS.between(localDateTime, localDateTime2) * 1000L;
        return (l == 0L ? "" : string + " day" + (l == 1L ? ", " : "s, ")) + (l2 == 0L ? "" : l2 + " hour" + (l2 == 1L ? ", " : "s, ")) + (l3 == 0L ? "" : l3 + " minute" + (l3 == 1L ? ", " : "s, ")) + (l4 == 0L ? "" : l4 + " second" + (l4 == 1L ? ", " : "s, ")) + (l5 == 0L ? "" : l5 + " millisecond" + (l5 == 1L ? "" : "s"));
    }
}

