/*
 * Decompiled with CFR 0.152.
 */
import com.internationalnetwork.util.conf.ConfigurationDirective;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class TransmitMail
implements Runnable {
    public static final String VERSION = "1.00";
    public static final long NANOSTART = System.nanoTime();
    final ConfigurationDirective[] CONF;

    private TransmitMail() {
        throw new RuntimeException();
    }

    public TransmitMail(ConfigurationDirective[] configurationDirectiveArray) {
        this.CONF = configurationDirectiveArray;
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mailcapCommandMap.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mailcapCommandMap.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mailcapCommandMap.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mailcapCommandMap.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap(mailcapCommandMap);
    }

    @Override
    public void run() {
    }

    public void sendMail(String string, Path path, Path path2) {
        for (ConfigurationDirective configurationDirective : this.CONF) {
            Properties properties = new Properties();
            properties.put("mail.smtp.host", configurationDirective.getAtom("Host", 0));
            properties.put("mail.smtp.port", configurationDirective.getAtom("Port", 0));
            Session session = Session.getInstance(properties, null);
            try {
                MimeMessage mimeMessage = new MimeMessage(session);
                mimeMessage.setFrom(configurationDirective.getAtom("From", 0));
                mimeMessage.setRecipients(Message.RecipientType.TO, configurationDirective.getAtom("To", 0));
                mimeMessage.setSubject(configurationDirective.getAtom("Subject", 0) + (path2 == null ? " [Finished]" : " [Errors]"));
                mimeMessage.setSentDate(new Date());
                MimeMultipart mimeMultipart = new MimeMultipart();
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setText(string);
                mimeMultipart.addBodyPart(mimeBodyPart);
                try {
                    mimeBodyPart = new MimeBodyPart();
                    mimeBodyPart.attachFile(path.toFile(), "text/plain", "8bit");
                    mimeMultipart.addBodyPart(mimeBodyPart);
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
                if (path2 != null) {
                    try {
                        mimeBodyPart = new MimeBodyPart();
                        mimeBodyPart.attachFile(path2.toFile(), "text/plain", "8bit");
                        mimeMultipart.addBodyPart(mimeBodyPart);
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                    }
                }
                mimeMessage.setContent(mimeMultipart);
                Transport.send(mimeMessage);
                System.out.println("Sent eMail report(s) to " + configurationDirective.getAtom("To", 0));
            }
            catch (MessagingException messagingException) {
                System.err.println("TreeCopy: Failed to send eMail: " + messagingException);
            }
        }
    }
}

