/*
 * Decompiled with CFR 0.152.
 */
import com.internationalnetwork.util.conf.ConfigurationDirective;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class ScheduledTask
implements Delayed {
    public static final String VERSION = "1.00";
    public static final long NANOSTART = System.nanoTime();
    protected String taskTitle;
    protected LocalDateTime when = LocalDateTime.now();
    protected boolean[] repeat = new boolean[7];
    protected String type;
    protected Path[] sources;
    protected boolean[] sourcesQ;
    protected Path sourceCheck = null;
    protected char[] sourceDrives = null;
    protected int bufferSize;
    protected String[][] criteria;
    protected Path[] targets;
    protected boolean[] targetsQ;
    protected Path targetCheck = null;
    protected char[] targetDrives = null;
    protected int targetCycle;
    protected String logs;
    protected ConfigurationDirective[] mail;

    private ScheduledTask() {
        throw new RuntimeException();
    }

    public ScheduledTask(String string, String string2, String string3, String[] stringArray, String string4, String string5, int n, String[][] stringArray2, String[] stringArray3, String string6, String string7, String string8, String string9, ConfigurationDirective[] configurationDirectiveArray) {
        int n2;
        this.taskTitle = string;
        this.type = string2;
        if (this.type.equals("nightly")) {
            for (n2 = 0; n2 < this.repeat.length; ++n2) {
                this.repeat[n2] = true;
            }
            this.when = LocalTime.parse(string3, DateTimeFormatter.ofPattern("HHmm[ss]")).atDate(LocalDate.now());
            if (this.when.isBefore(LocalDateTime.now())) {
                this.when = this.when.plusDays(1L);
            }
        } else {
            throw new IllegalArgumentException("Scheduling type \"" + string2 + "\" is not supported.");
        }
        this.sources = new Path[stringArray.length];
        this.sourcesQ = new boolean[stringArray.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].startsWith("?:")) {
                this.sourcesQ[n2] = true;
                this.sources[n2] = Paths.get("C" + stringArray[n2].substring(1), new String[0]);
                continue;
            }
            this.sources[n2] = Paths.get(stringArray[n2], new String[0]);
        }
        if (string4 != null) {
            this.sourceCheck = Paths.get(string4, new String[0]);
            if (string5 != null) {
                this.sourceDrives = string5.toCharArray();
            }
        }
        this.bufferSize = n;
        this.criteria = stringArray2;
        this.targets = new Path[stringArray3.length];
        this.targetsQ = new boolean[stringArray3.length];
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            if (stringArray3[n2].startsWith("?:")) {
                this.targetsQ[n2] = true;
                this.targets[n2] = Paths.get("C" + stringArray3[n2].substring(1), new String[0]);
                continue;
            }
            this.targets[n2] = Paths.get(stringArray3[n2], new String[0]);
        }
        if (string6 != null) {
            this.targetCheck = Paths.get(string6, new String[0]);
            if (string7 != null) {
                this.targetDrives = string7.toCharArray();
            }
        }
        this.targetCycle = Integer.parseUnsignedInt(string8);
        this.logs = string9;
        this.mail = configurationDirectiveArray;
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("TimeUnit type specified as NULL");
        }
        switch (timeUnit) {
            case DAYS: {
                return LocalDateTime.now().until(this.when, ChronoUnit.DAYS);
            }
            case HOURS: {
                return LocalDateTime.now().until(this.when, ChronoUnit.HOURS);
            }
            case MICROSECONDS: {
                return LocalDateTime.now().until(this.when, ChronoUnit.MICROS);
            }
            case MILLISECONDS: {
                return LocalDateTime.now().until(this.when, ChronoUnit.MILLIS);
            }
            case MINUTES: {
                return LocalDateTime.now().until(this.when, ChronoUnit.MINUTES);
            }
            case NANOSECONDS: {
                return LocalDateTime.now().until(this.when, ChronoUnit.NANOS);
            }
            case SECONDS: {
                return LocalDateTime.now().until(this.when, ChronoUnit.SECONDS);
            }
        }
        throw new IllegalArgumentException("TimeUnit type specified is not supported");
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == this) {
            return 0;
        }
        return ((ScheduledTask)delayed).when.compareTo(this.when);
    }

    public String toString() {
        return this.type + "->" + this.when;
    }

    public String getTitle() {
        return this.taskTitle;
    }

    public void commence(DelayQueue<ScheduledTask> delayQueue) {
        Runner runner = new Runner(this);
        Thread thread = new Thread(runner);
        thread.start();
    }
}

