/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;

public class RunnerPruneVisitor<Type>
extends SimpleFileVisitor<Path> {
    public static final String VERSION = "1.00";
    public static final long NANOSTART = System.nanoTime();
    private final Runner runner;
    private final Statistics stats;

    private RunnerPruneVisitor() {
        throw new RuntimeException();
    }

    public RunnerPruneVisitor(Runner runner, Statistics statistics) {
        this.runner = runner;
        this.stats = statistics;
        this.stats.prunedTargets.incrementAndGet();
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        if (iOException != null) {
            throw iOException;
        }
        try {
            DosFileAttributes dosFileAttributes = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
            if (dosFileAttributes.isReadOnly()) {
                Files.setAttribute(path, "dos:readonly", false, new LinkOption[0]);
            }
            if (dosFileAttributes.isSystem()) {
                Files.setAttribute(path, "dos:system", false, new LinkOption[0]);
            }
            Files.delete(path);
            this.stats.prunedPaths.incrementAndGet();
        }
        catch (IOException iOException2) {
            this.runner.log('E', true, "Prune path: " + iOException2 + ": " + path);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        try {
            DosFileAttributes dosFileAttributes = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
            if (dosFileAttributes.isReadOnly()) {
                Files.setAttribute(path, "dos:readonly", false, new LinkOption[0]);
            }
            if (dosFileAttributes.isSystem()) {
                Files.setAttribute(path, "dos:system", false, new LinkOption[0]);
            }
            long l = Files.size(path);
            Files.delete(path);
            this.stats.prunedFiles.incrementAndGet();
            this.stats.prunedBytes.addAndGet(l);
        }
        catch (IOException iOException) {
            this.runner.log('E', true, "Prune file: " + iOException + ": " + path);
        }
        return FileVisitResult.CONTINUE;
    }
}

