/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class RunnerCopyVisitor<Type>
extends SimpleFileVisitor<Path> {
    public static final String VERSION = "1.02";
    public static final long NANOSTART = System.nanoTime();
    private final Runner runner;
    private final Statistics stats;
    private final Path source;
    private final String sNum;
    private final int bufferSize;
    private final Path[] targets;

    private RunnerCopyVisitor() {
        throw new RuntimeException();
    }

    public RunnerCopyVisitor(Runner runner, Statistics statistics, Path path, String string, int n, Path ... pathArray) {
        this.runner = runner;
        this.stats = statistics;
        this.source = path;
        this.sNum = string;
        this.bufferSize = n;
        this.targets = pathArray;
        if (this.sNum != null) {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i] = this.targets[i].resolve(this.sNum);
                try {
                    Files.createDirectories(this.targets[i], new FileAttribute[0]);
                    continue;
                }
                catch (IOException iOException) {
                    this.runner.log('E', true, iOException + ": " + this.targets[i]);
                }
            }
        }
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        this.runner.log('C', true, (Files.isSymbolicLink(path) ? "PathLink " : "Path ") + path);
        this.stats.sourcePaths.incrementAndGet();
        for (Path path2 : this.targets) {
            path2 = path2.resolve(this.source.relativize(path));
            try {
                Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
                this.stats.targetPaths.incrementAndGet();
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                this.runner.log('E', true, "Directory already exists: " + path2);
            }
            catch (FileSystemException fileSystemException) {
                this.runner.log('E', true, fileSystemException.toString());
            }
            catch (IOException iOException) {
                this.runner.log('E', true, iOException.toString());
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        if (iOException != null) {
            throw iOException;
        }
        Object object = Files.getAttribute(path, "creationTime", new LinkOption[0]);
        Object object2 = Files.getAttribute(path, "lastAccessTime", new LinkOption[0]);
        Object object3 = Files.getAttribute(path, "lastModifiedTime", new LinkOption[0]);
        DosFileAttributes dosFileAttributes = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
        for (Path path2 : this.targets) {
            path2 = path2.resolve(this.source.relativize(path));
            Files.setAttribute(path2, "creationTime", object, new LinkOption[0]);
            Files.setAttribute(path2, "lastAccessTime", object2, new LinkOption[0]);
            Files.setAttribute(path2, "lastModifiedTime", object3, new LinkOption[0]);
            Files.setAttribute(path2, "dos:archive", dosFileAttributes.isArchive(), new LinkOption[0]);
            Files.setAttribute(path2, "dos:hidden", dosFileAttributes.isHidden(), new LinkOption[0]);
            Files.setAttribute(path2, "dos:readonly", dosFileAttributes.isReadOnly(), new LinkOption[0]);
            Files.setAttribute(path2, "dos:system", dosFileAttributes.isSystem(), new LinkOption[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        void object2;
        InputStream inputStream = null;
        OutputStream[] outputStreamArray = new OutputStream[this.targets.length];
        Path[] pathArray = new Path[this.targets.length];
        try {
            inputStream = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean i = false;
        while (object2 < outputStreamArray.length) {
            pathArray[object2] = this.targets[object2].resolve(this.source.relativize(path));
            try {
                outputStreamArray[object2] = Files.newOutputStream(pathArray[object2], StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                this.runner.log('E', true, iOException.toString());
            }
            ++object2;
        }
        try {
            int n;
            byte[] iOException = new byte[this.bufferSize];
            long l = 0L;
            while ((n = inputStream.read(iOException)) > 0) {
                this.stats.sourceBytes.addAndGet(n);
                for (OutputStream outputStream : outputStreamArray) {
                    outputStream.write(iOException, 0, n);
                }
                l += (long)n;
            }
            this.stats.targetBytes.addAndGet(l * (long)outputStreamArray.length);
            this.stats.sourceFiles.incrementAndGet();
            this.stats.targetFiles.addAndGet(outputStreamArray.length);
            this.runner.log('C', true, (Files.isSymbolicLink(path) ? "FileLink " : "File ") + path + " (" + String.format("%,d", l) + (l == 1L ? " byte" : " bytes") + ")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (OutputStream outputStream : outputStreamArray) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = Files.getAttribute(path, "creationTime", new LinkOption[0]);
        Object object3 = Files.getAttribute(path, "lastAccessTime", new LinkOption[0]);
        Object object4 = Files.getAttribute(path, "lastModifiedTime", new LinkOption[0]);
        DosFileAttributes dosFileAttributes = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
        for (Path path2 : pathArray) {
            Files.setAttribute(path2, "creationTime", object, new LinkOption[0]);
            Files.setAttribute(path2, "lastAccessTime", object3, new LinkOption[0]);
            Files.setAttribute(path2, "lastModifiedTime", object4, new LinkOption[0]);
            Files.setAttribute(path2, "dos:archive", dosFileAttributes.isArchive(), new LinkOption[0]);
            Files.setAttribute(path2, "dos:hidden", dosFileAttributes.isHidden(), new LinkOption[0]);
            Files.setAttribute(path2, "dos:readonly", dosFileAttributes.isReadOnly(), new LinkOption[0]);
            Files.setAttribute(path2, "dos:system", dosFileAttributes.isSystem(), new LinkOption[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
        this.runner.log('E', true, iOException.toString());
        return FileVisitResult.CONTINUE;
    }
}

