/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.TreeSet;

public class Runner
implements Runnable {
    public static final String VERSION = "1.01";
    public static final long NANOSTART = System.nanoTime();
    private final DateTimeFormatter LOGDATEFORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd.HH:mm:ss.SSS");
    private final DateTimeFormatter LOGFILENAMEID = DateTimeFormatter.ofPattern("uuuuMMdd-HHmmss-SSS");
    private final ScheduledTask sTask;
    private String logFilenameID = null;
    private BufferedWriter logCopiedHandle = null;
    private BufferedWriter logErrorsHandle = null;
    ArrayList<Path> sourcePaths = new ArrayList();
    ArrayList<Path> targetPaths = new ArrayList();
    Statistics stats = new Statistics();
    private String checkFileLine = null;

    private Runner() {
        throw new RuntimeException();
    }

    public Runner(ScheduledTask scheduledTask) {
        this.sTask = scheduledTask;
    }

    public String readCheckFile(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(path.toFile(), "r");
                this.checkFileLine = randomAccessFile.readLine();
                randomAccessFile.close();
                System.out.println(this.checkFileLine);
                return this.checkFileLine;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public Path checkFinder(Path path, String string, char[] cArray) {
        for (char c : cArray) {
            Path path2 = Paths.get(c + path.toString().substring(1), string);
            if (!Files.exists(path2, new LinkOption[0])) continue;
            this.readCheckFile(path2);
            return Paths.get(c + path.toString().substring(1), new String[0]);
        }
        return null;
    }

    public void log(char c, boolean bl, String ... stringArray) {
        String string = (bl ? LocalDateTime.now().format(this.LOGDATEFORMAT) : "") + " ";
        switch (c) {
            case 'C': {
                if (this.logCopiedHandle != null) break;
                try {
                    this.logCopiedHandle = Files.newBufferedWriter(Paths.get(this.sTask.logs, this.logFilenameID + ".log"), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                    this.log('C', true, "***** TreeCopy v1.01 transfer log (" + this.logFilenameID + ".log) *****");
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
                break;
            }
            case 'E': {
                if (this.logErrorsHandle != null) break;
                try {
                    this.logErrorsHandle = Files.newBufferedWriter(Paths.get(this.sTask.logs, this.logFilenameID + ".err"), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                    this.log('E', true, "***** TreeCopy v1.01 error log (" + this.logFilenameID + ".err) *****");
                    break;
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
        try {
            switch (c) {
                case 'C': {
                    for (String string2 : stringArray) {
                        if (string2 == null) continue;
                        this.logCopiedHandle.write(string + string2);
                        this.logCopiedHandle.newLine();
                        string = string.replaceAll(".", " ");
                    }
                    break;
                }
                case 'E': {
                    for (String string3 : stringArray) {
                        if (string3 == null) continue;
                        this.logErrorsHandle.write(string + string3);
                        this.logErrorsHandle.newLine();
                        string = string.replaceAll(".", " ");
                        this.stats.errorsLogged.incrementAndGet();
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    @Override
    public void run() {
        Iterable<Path> iterable;
        Path path2;
        int n;
        LocalDateTime localDateTime = LocalDateTime.now();
        this.logFilenameID = this.sTask.taskTitle + "." + localDateTime.format(this.LOGFILENAMEID);
        this.log('C', true, "Commenced copy operation: " + this.sTask.taskTitle);
        System.out.println("Starting: " + this.logFilenameID);
        for (n = 0; n < this.sTask.sources.length; ++n) {
            path2 = this.sTask.sources[n];
            if (this.sTask.sourcesQ[n]) {
                if ((path2 = this.checkFinder(path2, this.sTask.sourceCheck.toString(), this.sTask.sourceDrives)) != null) {
                    this.log('C', true, "Source directory: " + path2);
                    this.sourcePaths.add(path2);
                    if (this.checkFileLine == null) continue;
                    this.log('C', true, "Source identifier: " + this.checkFileLine);
                    continue;
                }
                this.log('E', true, "Could not locate source directory ?:" + this.sTask.sources[n].toString().substring(2));
                continue;
            }
            if (Files.isDirectory(path2, new LinkOption[0])) {
                this.log('C', true, "Source directory: " + path2);
                this.sourcePaths.add(path2);
                if (this.sTask.sourceCheck == null || this.readCheckFile(Paths.get(path2.toString(), this.sTask.sourceCheck.toString())) == null) continue;
                this.log('C', true, "Source identifier: " + this.checkFileLine);
                continue;
            }
            this.log('E', true, "Could not locate source directory " + path2);
        }
        for (n = 0; n < this.sTask.targets.length; ++n) {
            path2 = this.sTask.targets[n];
            if (this.sTask.targetsQ[n]) {
                if ((path2 = this.checkFinder(path2, this.sTask.targetCheck.toString(), this.sTask.targetDrives)) != null) {
                    this.log('C', true, "Target directory: " + path2);
                    this.targetPaths.add(path2);
                    if (this.checkFileLine == null) continue;
                    this.log('C', true, "Target identifier: " + this.checkFileLine);
                    continue;
                }
                this.log('E', true, "Could not find target directory ?:" + this.sTask.targets[n].toString().substring(2));
                continue;
            }
            if (Files.isDirectory(path2, new LinkOption[0])) {
                this.log('C', true, "Target directory: " + path2);
                this.targetPaths.add(path2);
                if (this.sTask.targetCheck == null || this.readCheckFile(Paths.get(path2.toString(), this.sTask.targetCheck.toString())) == null) continue;
                this.log('C', true, "Target identifier: " + this.checkFileLine);
                continue;
            }
            this.log('E', true, "Could not find target directory " + path2);
        }
        if (this.sTask.targetCycle > 0) {
            for (Path path2 : this.targetPaths) {
                iterable = new TreeSet();
                try {
                    DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2, this.sTask.taskTitle + ".*");
                    for (Path path3 : directoryStream) {
                        if (path3.getFileName().toString().compareTo(this.logFilenameID) < 0) {
                            ((TreeSet)iterable).add((Path)path3);
                            continue;
                        }
                        this.log('E', true, "Prune skipped (future target encountered): " + path3);
                    }
                    if (this.sTask.targetCycle <= 0 || ((TreeSet)iterable).size() <= this.sTask.targetCycle - 1) continue;
                    for (int i = 1; i < this.sTask.targetCycle; ++i) {
                        ((TreeSet)iterable).remove(((TreeSet)iterable).last());
                    }
                    for (Path path3 : iterable) {
                        this.log('C', true, "Prune previous target: " + path3);
                        Files.walkFileTree(path3, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new RunnerPruneVisitor(this, this.stats));
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        if (this.sourcePaths.size() > 0) {
            if (this.targetPaths.size() > 0) {
                int n2;
                boolean bl = this.sourcePaths.size() > 1;
                for (n2 = 0; n2 < this.targetPaths.size(); ++n2) {
                    iterable = this.targetPaths.get(n2).resolve(this.logFilenameID);
                    this.targetPaths.set(n2, (Path)iterable);
                }
                for (n2 = 0; n2 < this.sourcePaths.size(); ++n2) {
                    iterable = this.sourcePaths.get(n2);
                    try {
                        Files.walkFileTree(iterable, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new RunnerCopyVisitor(this, this.stats, (Path)iterable, bl ? "" + (n2 + 1) : null, this.sTask.bufferSize, this.targetPaths.toArray(new Path[0])));
                        continue;
                    }
                    catch (IOException iOException) {
                        this.log('E', true, "" + iOException);
                    }
                }
            } else {
                this.log('E', true, "No targets to copy to, operation terminated");
            }
        } else {
            this.log('E', true, "No sources to copy from, operation terminated");
        }
        String string = TreeCopy.diffDateTime(localDateTime, LocalDateTime.now());
        this.log('C', true, "Completed copy operation: " + this.sTask.taskTitle, "Duration: " + string);
        this.log('C', true, this.stats.summary("Final overall statistics"));
        try {
            if (this.logCopiedHandle != null) {
                this.logCopiedHandle.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.logErrorsHandle != null) {
                this.logErrorsHandle.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Finished: " + this.logFilenameID);
        System.out.println("Total duration: " + string);
        TransmitMail transmitMail = new TransmitMail(this.sTask.mail);
        if (this.stats.errorsLogged.get() == 0L) {
            transmitMail.sendMail(this.stats.summaryString("Final overall statistics for:  " + this.logFilenameID), Paths.get(this.sTask.logs, this.logFilenameID + ".log"), null);
        } else {
            transmitMail.sendMail(this.stats.summaryString("Number of errors:  " + this.stats.errorsLogged.get() + " (see attached error log)\n\nFinal overall statistics for:  " + this.logFilenameID), Paths.get(this.sTask.logs, this.logFilenameID + ".log"), Paths.get(this.sTask.logs, this.logFilenameID + ".err"));
        }
    }
}

